/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.connection;

import com.bluepowermod.api.connect.IConnection;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.part.BPPart;
import com.bluepowermod.part.BPPartFace;
import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.redstone.DummyRedstoneDevice;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.helper.RedstoneHelper;
import uk.co.qmunity.lib.util.Dir;

public class GateConnectionDigital
extends GateConnectionBase {
    private boolean input = false;
    private boolean output = false;
    private boolean lastOutput = false;

    public GateConnectionDigital(GateBase<?, ?, ?, ?, ?, ?> gate, Dir direction) {
        super(gate, direction);
    }

    @Override
    public void refresh() {
        IConnection<IRedstoneDevice> c = this.gate.getRedstoneConnectionCache().getConnectionOnSide(this.getForgeDirection());
        if (c == null || c.getB() instanceof DummyRedstoneDevice) {
            this.input = RedstoneHelper.getInput((World)((BPPart)((Object)this.getGate())).getWorld(), (int)((BPPart)((Object)this.getGate())).getX(), (int)((BPPart)((Object)this.getGate())).getY(), (int)((BPPart)((Object)this.getGate())).getZ(), (ForgeDirection)this.getForgeDirection(), (ForgeDirection)((BPPartFace)((Object)this.getGate())).getFace()) > 0;
        }
    }

    @Override
    public boolean canConnect(IRedstoneDevice device) {
        return true;
    }

    @Override
    public boolean canConnect(IBundledDevice device) {
        return false;
    }

    @Override
    public boolean isBundled() {
        return false;
    }

    @Override
    public byte getRedstoneOutput() {
        return (byte)(this.output ? 255 : 0);
    }

    @Override
    public byte[] getBundledOutput() {
        return new byte[16];
    }

    @Override
    public void setRedstonePower(byte power) {
        this.setInput((power & 0xFF) > 0);
    }

    @Override
    public void setBundledPower(byte[] power) {
    }

    public boolean getInput() {
        return this.input;
    }

    public boolean getOutput() {
        return this.output;
    }

    public GateConnectionDigital setInput(boolean input) {
        if (this.input != input) {
            this.setNeedsSyncing(true);
        }
        this.input = input;
        return this;
    }

    public GateConnectionDigital setOutput(boolean output) {
        if (this.output != output) {
            this.setNeedsSyncing(true);
        }
        this.output = output;
        return this;
    }

    @Override
    public GateConnectionDigital disable() {
        super.disable();
        return this;
    }

    @Override
    public GateConnectionDigital enable() {
        super.enable();
        return this;
    }

    @Override
    public GateConnectionDigital setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public GateConnectionDigital setOutputOnly() {
        super.setOutputOnly();
        return this;
    }

    @Override
    public GateConnectionDigital setBidirectional() {
        super.setBidirectional();
        return this;
    }

    @Override
    public double getSignal() {
        if (this.output) {
            return 1.0;
        }
        if (!this.isOutputOnly() && this.input) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("input", this.input);
        tag.func_74757_a("output", this.output);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.input = tag.func_74767_n("input");
        this.output = tag.func_74767_n("output");
    }

    @Override
    public void writeData(DataOutput buffer) throws IOException {
        super.writeData(buffer);
        buffer.writeBoolean(this.input);
        buffer.writeBoolean(this.output);
    }

    @Override
    public void readData(DataInput buffer) throws IOException {
        super.readData(buffer);
        this.input = buffer.readBoolean();
        this.output = buffer.readBoolean();
    }

    @Override
    public void notifyUpdate() {
        super.notifyUpdate();
        this.lastOutput = this.output;
    }

    @Override
    public void notifyUpdateIfNeeded() {
        if (this.lastOutput != this.output) {
            this.notifyUpdate();
        }
    }

    @Override
    public GateConnectionDigital reset() {
        super.reset();
        this.input = false;
        this.output = false;
        this.lastOutput = true;
        return this;
    }
}

