/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.digital;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.gate.connection.GateConnectionDigital;
import com.bluepowermod.part.gate.digital.GateSimpleDigital;
import net.minecraft.nbt.NBTTagCompound;
import uk.co.qmunity.lib.misc.ShiftingBuffer;

public class GateBuffer
extends GateSimpleDigital {
    private ShiftingBuffer<Boolean> buf = new ShiftingBuffer(1, 3, (Object)false);
    private GateComponentTorch t1;
    private GateComponentTorch t2;
    private GateComponentWire w;

    @Override
    public void initializeConnections() {
        ((GateConnectionDigital)this.front()).enable();
        ((GateConnectionDigital)this.right()).enable();
        ((GateConnectionDigital)this.back()).enable();
        ((GateConnectionDigital)this.left()).enable();
    }

    @Override
    public void initComponents() {
        this.t1 = new GateComponentTorch(this, 255, 0.3125, true).setState(true);
        this.addComponent(this.t1);
        this.t2 = new GateComponentTorch(this, 7274677, 0.25, true).setState(false);
        this.addComponent(this.t2);
        this.w = new GateComponentWire(this, 1638144, RedwireType.BLUESTONE).setPower((byte)-1);
        this.addComponent(this.w);
        this.addComponent(new GateComponentWire(this, 0xFFF600, RedwireType.BLUESTONE).bind((GateConnectionBase)this.right()));
        this.addComponent(new GateComponentWire(this, 12976383, RedwireType.BLUESTONE).bind((GateConnectionBase)this.back()));
        this.addComponent(new GateComponentWire(this, 0xFF0000, RedwireType.BLUESTONE).bind((GateConnectionBase)this.left()));
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    public String getGateType() {
        return "buffer";
    }

    @Override
    public void doLogic() {
        this.buf.set(0, (Object)((GateConnectionDigital)this.back()).getInput());
    }

    @Override
    public void tick() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.buf.shift();
        boolean mid = (Boolean)this.buf.get(0, 1) == false;
        this.t1.setState(mid);
        this.w.setPower((byte)(mid ? 255 : 0));
        boolean out = (Boolean)this.buf.get(0);
        this.t2.setState(out);
        ((GateConnectionDigital)this.left()).setOutput(out);
        ((GateConnectionDigital)this.front()).setOutput(out);
        ((GateConnectionDigital)this.right()).setOutput(out);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.buf.writeToNBT(tag, "buffer");
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.buf.readFromNBT(tag, "buffer");
    }
}

