/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.digital;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.gate.connection.GateConnectionDigital;
import com.bluepowermod.part.gate.digital.GateSimpleDigital;
import net.minecraft.nbt.NBTTagCompound;
import uk.co.qmunity.lib.misc.ShiftingBuffer;

public class GateMultiplexer
extends GateSimpleDigital {
    private GateComponentTorch t1;
    private GateComponentTorch t2;
    private GateComponentTorch t3;
    private GateComponentTorch t4;
    private GateComponentWire w1;
    private GateComponentWire w2;
    private ShiftingBuffer<Boolean> buf = null;

    @Override
    protected void initializeConnections() {
        ((GateConnectionDigital)this.front()).enable().setOutputOnly();
        ((GateConnectionDigital)this.left()).enable();
        ((GateConnectionDigital)this.back()).enable();
        ((GateConnectionDigital)this.right()).enable();
    }

    @Override
    protected void initComponents() {
        this.t1 = new GateComponentTorch(this, 2186125, 0.25, true).setState(false);
        this.addComponent(this.t1);
        this.t2 = new GateComponentTorch(this, 255, 0.25, true).setState(true);
        this.addComponent(this.t2);
        this.t3 = new GateComponentTorch(this, 4101340, 0.25, true).setState(true);
        this.addComponent(this.t3);
        this.t4 = new GateComponentTorch(this, 7274677, 0.3125, true).setState(false);
        this.addComponent(this.t4);
        this.w1 = new GateComponentWire(this, 1638144, RedwireType.BLUESTONE).setPower((byte)-1);
        this.addComponent(this.w1);
        this.addComponent(new GateComponentWire(this, 0xFFF600, RedwireType.BLUESTONE).bind((GateConnectionBase)this.right()));
        this.addComponent(new GateComponentWire(this, 12976383, RedwireType.BLUESTONE).bind((GateConnectionBase)this.back()));
        this.addComponent(new GateComponentWire(this, 0xFF0000, RedwireType.BLUESTONE).bind((GateConnectionBase)this.left()));
        this.w2 = new GateComponentWire(this, 13807153, RedwireType.BLUESTONE).setPower((byte)-1);
        this.addComponent(this.w2);
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    protected String getGateType() {
        return "multiplexer";
    }

    @Override
    public void doLogic() {
        if (this.buf == null) {
            this.buf = new ShiftingBuffer(6, 2, (Object)false);
            this.buf.set(4, (Object)true);
            this.buf.set(0, (Object)true);
            this.buf.set(3, (Object)true);
            this.buf.shift();
        }
        this.buf.set(0, (Object)((GateConnectionDigital)this.back()).getInput());
        this.buf.set(1, (Object)((GateConnectionDigital)this.left()).getInput());
        this.buf.set(2, (Object)((GateConnectionDigital)this.right()).getInput());
    }

    @Override
    public void tick() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (this.buf == null) {
            this.buf = new ShiftingBuffer(6, 2, (Object)false);
            this.buf.set(4, (Object)true);
            this.buf.set(0, (Object)true);
            this.buf.set(3, (Object)true);
            this.buf.shift();
        }
        this.buf.shift();
        this.t2.setState((Boolean)this.buf.get(0) == false);
        this.t3.setState((Boolean)this.buf.get(0) == false && (Boolean)this.buf.get(2) == false);
        this.w2.setPower((byte)((Boolean)this.buf.get(3) != false ? 255 : 0));
        this.t1.setState((Boolean)this.buf.get(3) == false && (Boolean)this.buf.get(1) == false);
        this.w1.setPower((byte)((Boolean)this.buf.get(4) != false ? 255 : 0));
        this.t4.setState((Boolean)this.buf.get(5));
        ((GateConnectionDigital)this.front()).setOutput((Boolean)this.buf.get(5));
        this.buf.set(3, (Object)((Boolean)this.buf.get(0) == false ? 1 : 0));
        this.buf.set(4, (Object)((Boolean)this.buf.get(0) == false && (Boolean)this.buf.get(2) == false || (Boolean)this.buf.get(3) == false && (Boolean)this.buf.get(1) == false ? 1 : 0));
        this.buf.set(5, (Object)((Boolean)this.buf.get(4) == false ? 1 : 0));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.buf.writeToNBT(tag, "buffer");
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (this.buf == null) {
            this.buf = new ShiftingBuffer(6, 2, (Object)false);
            this.buf.set(4, (Object)true);
            this.buf.set(0, (Object)true);
            this.buf.set(3, (Object)true);
            this.buf.shift();
        }
        this.buf.readFromNBT(tag, "buffer");
    }
}

