/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.digital;

import com.bluepowermod.client.gui.gate.GuiGateSingleCounter;
import com.bluepowermod.part.IGuiButtonSensitive;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentPointer;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import com.bluepowermod.part.gate.connection.GateConnectionDigital;
import com.bluepowermod.part.gate.digital.GateSimpleDigital;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class GateSequencer
extends GateSimpleDigital
implements IGuiButtonSensitive {
    private long start = -1L;
    private int time = 160;
    private int ticks = 0;
    private GateComponentTorch t1;
    private GateComponentTorch t2;
    private GateComponentTorch t3;
    private GateComponentTorch t4;
    private GateComponentPointer p;

    @Override
    public void initializeConnections() {
        ((GateConnectionDigital)this.front()).enable().setOutputOnly();
        ((GateConnectionDigital)this.left()).enable().setOutputOnly();
        ((GateConnectionDigital)this.back()).enable().setOutputOnly();
        ((GateConnectionDigital)this.right()).enable().setOutputOnly();
    }

    @Override
    public void initComponents() {
        this.t1 = new GateComponentTorch(this, 2346700, 0.1875, true);
        this.addComponent(this.t1);
        this.t2 = new GateComponentTorch(this, 255, 0.1875, true);
        this.addComponent(this.t2);
        this.t3 = new GateComponentTorch(this, 4101340, 0.1875, true).setState(true);
        this.addComponent(this.t3);
        this.t4 = new GateComponentTorch(this, 7274677, 0.1875, true);
        this.addComponent(this.t4);
        this.p = new GateComponentPointer(this, 0xFFFF00, 0.4375, true);
        this.addComponent(this.p.setShouldSync(false).setState(true));
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    public String getGateType() {
        return "sequencer";
    }

    @Override
    public void doLogic() {
    }

    @Override
    public void tick() {
        long curTime = this.getWorld().func_82737_E();
        if (this.start != -1L && curTime != this.start && curTime - this.start >= (long)this.time) {
            while (curTime - this.start >= (long)this.time) {
                this.start += (long)this.time;
            }
        }
        if (this.start != -1L && (curTime - this.start) % (long)(this.time / 4) == 0L) {
            this.playTickSound();
            if (!this.getWorld().field_72995_K) {
                ((GateConnectionDigital)this.front()).setOutput(false);
                ((GateConnectionDigital)this.back()).setOutput(false);
                ((GateConnectionDigital)this.left()).setOutput(false);
                ((GateConnectionDigital)this.right()).setOutput(false);
                this.t1.setState(false);
                this.t2.setState(false);
                this.t3.setState(false);
                this.t4.setState(false);
                int i = (int)((curTime - this.start) / (long)(this.time / 4));
                if (i == 0) {
                    this.t3.setState(true);
                    ((GateConnectionDigital)this.front()).setOutput(true);
                } else if (i == 1) {
                    this.t4.setState(true);
                    ((GateConnectionDigital)this.right()).setOutput(true);
                } else if (i == 2) {
                    this.t1.setState(true);
                    ((GateConnectionDigital)this.back()).setOutput(true);
                } else if (i == 3) {
                    this.t2.setState(true);
                    ((GateConnectionDigital)this.left()).setOutput(true);
                }
            }
        }
        if (this.start == -1L) {
            this.start = curTime;
        }
        this.p.setAngle((double)(curTime - this.start) / (double)this.time);
        this.p.setIncrement(1.0 / (double)this.time);
    }

    @Override
    public void onButtonPress(EntityPlayer player, int messageId, int value) {
        this.time = value * 4;
        this.sendUpdatePacket();
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74772_a("start", this.start);
        tag.func_74768_a("ticks", this.ticks);
        tag.func_74768_a("time", this.time);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.start = tag.func_74763_f("start");
        this.ticks = tag.func_74762_e("ticks");
        this.time = tag.func_74762_e("time");
    }

    @Override
    public void writeUpdateData(DataOutput buffer) throws IOException {
        super.writeUpdateData(buffer);
        buffer.writeInt(this.time);
    }

    @Override
    public void readUpdateData(DataInput buffer) throws IOException {
        super.readUpdateData(buffer);
        this.time = buffer.readInt();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player) {
        return new GuiGateSingleCounter(this){

            @Override
            protected int getCurrentAmount() {
                return GateSequencer.this.time / 4;
            }
        };
    }

    @Override
    protected boolean hasGUI() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addWAILABody(List<String> info) {
        String t = "";
        int time = this.time / 4 * 50;
        t = time >= 1000 ? time / 1000 + "." + new BigDecimal(time % 1000, new MathContext(3)).toString() + "s" : time + "ms";
        info.add(I18n.func_135052_a((String)"gui.bluepower:timer.interval", (Object[])new Object[0]) + ": " + SpecialChars.WHITE + t);
    }
}

