/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.digital;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.client.gui.gate.GuiGateSingleCounter;
import com.bluepowermod.part.IGuiButtonSensitive;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentButton;
import com.bluepowermod.part.gate.component.GateComponentPointer;
import com.bluepowermod.part.gate.component.GateComponentSiliconChip;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.gate.connection.GateConnectionDigital;
import com.bluepowermod.part.gate.digital.GateSimpleDigital;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import uk.co.qmunity.lib.texture.Layout;

public class GateStateCell
extends GateSimpleDigital
implements IGuiButtonSensitive {
    private int time = 40;
    private int ticks = 0;
    private boolean triggered = false;
    private boolean locked = false;
    private boolean mirrored = false;
    private GateComponentPointer t1;
    private GateComponentTorch t2;
    private GateComponentWire w1;
    private GateComponentWire w2;
    private GateComponentButton chip;

    @Override
    public void initializeConnections() {
        ((GateConnectionDigital)this.front()).enable().setOutputOnly();
        ((GateConnectionDigital)this.left()).enable().setOutputOnly();
        ((GateConnectionDigital)this.back()).enable();
        ((GateConnectionDigital)this.right()).enable();
    }

    @Override
    public void initComponents() {
        this.t1 = new GateComponentPointer(this, 255, 0.4375, true).setAngle(0.75);
        this.addComponent(this.t1);
        this.t2 = new GateComponentTorch(this, 7274677, 0.25, true).setState(false);
        this.addComponent(this.t2);
        this.w1 = new GateComponentWire(this, 1638144, RedwireType.BLUESTONE).setPower((byte)-1);
        this.addComponent(this.w1);
        this.w2 = new GateComponentWire(this, 6398237, RedwireType.BLUESTONE).setPower((byte)-1);
        this.addComponent(this.w2);
        this.addComponent(new GateComponentWire(this, 0xFFF600, RedwireType.BLUESTONE).bind((GateConnectionBase)this.right()));
        this.addComponent(new GateComponentWire(this, 12976383, RedwireType.BLUESTONE).bind((GateConnectionBase)this.back()));
        this.addComponent(new GateComponentWire(this, 0xFF0000, RedwireType.BLUESTONE).bind((GateConnectionBase)this.left()));
        this.chip = new GateComponentSiliconChip(this, 14068503);
        this.addComponent(this.chip);
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    public String getGateType() {
        return "state";
    }

    @Override
    public void doLogic() {
        boolean in = ((GateConnectionDigital)this.back()).getInput();
        GateConnectionDigital out = null;
        if (this.mirrored) {
            this.locked = ((GateConnectionDigital)this.left()).getInput();
            out = (GateConnectionDigital)this.right();
        } else {
            this.locked = ((GateConnectionDigital)this.right()).getInput();
            out = (GateConnectionDigital)this.left();
        }
        this.locked |= in;
        this.triggered |= in;
        if (this.triggered && !in && !this.locked) {
            this.t1.setState(true);
            this.w2.setPower((byte)0);
        }
        this.chip.setState(this.triggered);
        out.setOutput(this.triggered);
        if (this.triggered || this.locked) {
            if (this.locked) {
                this.t1.setState(false);
            }
            this.t1.setAngle(this.mirrored ? 0.25 : 0.75);
            this.t1.setIncrement((double)(this.mirrored ? -1 : 1) * 0.1575 * (1.0 / (double)this.time));
        }
        this.sendUpdatePacket();
    }

    @Override
    public void tick() {
        GateConnectionDigital out;
        if (this.getWorld().field_72995_K) {
            return;
        }
        ((GateConnectionDigital)this.front()).setOutput(false);
        this.w1.setPower((byte)-1);
        this.t2.setState(false);
        GateConnectionDigital gateConnectionDigital = out = this.mirrored ? (GateConnectionDigital)this.right() : (GateConnectionDigital)this.left();
        if (this.triggered && !this.locked) {
            ++this.ticks;
        }
        if (!this.triggered || this.locked) {
            this.ticks = 0;
        }
        if (this.ticks == this.time) {
            out.setOutput(false);
            ((GateConnectionDigital)this.front()).setOutput(true);
            this.t1.setState(false);
            this.t1.setAngle(this.mirrored ? 0.25 : 0.75);
            this.w2.setPower((byte)-1);
            this.w1.setPower((byte)0);
            this.t2.setState(true);
            this.chip.setState(false);
            this.triggered = false;
            this.ticks = 0;
        }
    }

    @Override
    public boolean changeMode() {
        if (!this.getWorld().field_72995_K) {
            this.mirrored = !this.mirrored;
            this.getComponents().clear();
            this.initConnections();
            this.initComponents();
            this.doLogic();
            this.sendUpdatePacket();
        }
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74757_a("mirrored", this.mirrored);
        super.writeToNBT(tag);
        tag.func_74768_a("ticks", this.ticks);
        tag.func_74768_a("time", this.time);
        tag.func_74757_a("triggered", this.triggered);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        boolean wasMirrored = this.mirrored;
        this.mirrored = tag.func_74767_n("mirrored");
        if (wasMirrored != this.mirrored) {
            this.getComponents().clear();
            this.initComponents();
        }
        super.readFromNBT(tag);
        this.ticks = tag.func_74762_e("ticks");
        this.time = tag.func_74762_e("time");
        this.triggered = tag.func_74767_n("triggered");
    }

    @Override
    public void writeUpdateData(DataOutput buffer) throws IOException {
        buffer.writeBoolean(this.mirrored);
        super.writeUpdateData(buffer);
        buffer.writeInt(this.ticks);
        buffer.writeInt(this.time);
        buffer.writeBoolean(this.triggered);
    }

    @Override
    public void readUpdateData(DataInput buffer) throws IOException {
        boolean wasMirrored = this.mirrored;
        this.mirrored = buffer.readBoolean();
        if (wasMirrored != this.mirrored) {
            this.getComponents().clear();
            this.initComponents();
        }
        super.readUpdateData(buffer);
        this.ticks = buffer.readInt();
        this.time = buffer.readInt();
        this.triggered = buffer.readBoolean();
    }

    @Override
    public void onButtonPress(EntityPlayer player, int messageId, int value) {
        this.time = value;
        this.sendUpdatePacket();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiScreen getGui(EntityPlayer player) {
        return new GuiGateSingleCounter(this){

            @Override
            protected int getCurrentAmount() {
                return GateStateCell.this.time;
            }
        };
    }

    @Override
    protected boolean hasGUI() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addWAILABody(List<String> info) {
        String t = "";
        int time = this.time * 50;
        if (time >= 1000) {
            String ms = "" + time % 1000;
            if (ms.length() > 1) {
                while (ms.length() < 3) {
                    ms = "0" + ms;
                }
            }
            t = time / 1000 + "." + ms + "s";
        } else {
            t = time + "ms";
        }
        info.add(I18n.func_135052_a((String)"gui.bluepower:timer.interval", (Object[])new Object[0]) + ": " + SpecialChars.WHITE + t);
    }

    @Override
    public Layout getLayout() {
        Layout layout = super.getLayout();
        if (layout == null) {
            return null;
        }
        return layout.getSubLayout(this.mirrored ? 1 : 0);
    }
}

