/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.digital;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentButton;
import com.bluepowermod.part.gate.component.GateComponentSiliconChip;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.gate.connection.GateConnectionDigital;
import com.bluepowermod.part.gate.digital.GateSimpleDigital;
import net.minecraft.nbt.NBTTagCompound;

public class GateSynchronizer
extends GateSimpleDigital {
    private boolean rightTriggered;
    private boolean leftTriggered;
    private boolean oldLeftState;
    private boolean oldRightState;
    private boolean turnOff = false;
    private GateComponentTorch t;
    private GateComponentWire w1;
    private GateComponentWire w2;
    private GateComponentWire w3;
    private GateComponentButton b1;
    private GateComponentButton b2;

    @Override
    public void initializeConnections() {
        ((GateConnectionDigital)this.front()).enable().setOutputOnly();
        ((GateConnectionDigital)this.left()).enable();
        ((GateConnectionDigital)this.back()).enable();
        ((GateConnectionDigital)this.right()).enable();
    }

    @Override
    public void initComponents() {
        this.t = new GateComponentTorch(this, 16757760, 0.3125, true);
        this.addComponent(this.t);
        this.w1 = new GateComponentWire(this, 0x208800, RedwireType.BLUESTONE).setPower((byte)-1);
        this.addComponent(this.w1);
        this.w2 = new GateComponentWire(this, 4172386, RedwireType.BLUESTONE).setPower((byte)-1);
        this.addComponent(this.w2);
        this.w3 = new GateComponentWire(this, 10816895, RedwireType.BLUESTONE);
        this.addComponent(this.w3);
        this.addComponent(new GateComponentWire(this, 0xFFF600, RedwireType.BLUESTONE).bind((GateConnectionBase)this.right()));
        this.addComponent(new GateComponentWire(this, 12976383, RedwireType.BLUESTONE).bind((GateConnectionBase)this.back()));
        this.addComponent(new GateComponentWire(this, 0xFF0000, RedwireType.BLUESTONE).bind((GateConnectionBase)this.left()));
        this.b1 = new GateComponentSiliconChip(this, 255);
        this.addComponent(this.b1);
        this.b2 = new GateComponentSiliconChip(this, 52479);
        this.addComponent(this.b2);
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    public String getGateType() {
        return "synchronizer";
    }

    @Override
    public void doLogic() {
        if (!this.oldLeftState && ((GateConnectionDigital)this.left()).getInput()) {
            this.leftTriggered = true;
            this.b1.setState(true);
            this.w1.setPower((byte)0);
        }
        if (!this.oldRightState && ((GateConnectionDigital)this.right()).getInput()) {
            this.rightTriggered = true;
            this.b2.setState(true);
            this.w2.setPower((byte)0);
        }
        if (((GateConnectionDigital)this.back()).getInput()) {
            this.leftTriggered = false;
            this.b1.setState(false);
            this.rightTriggered = false;
            this.b2.setState(false);
            this.w1.setPower((byte)-1);
            this.w2.setPower((byte)-1);
        }
        if (this.leftTriggered && this.rightTriggered) {
            ((GateConnectionDigital)this.front()).setOutput(true);
            this.w3.setPower((byte)-1);
            this.leftTriggered = false;
            this.b1.setState(false);
            this.rightTriggered = false;
            this.b2.setState(false);
            this.t.setState(true);
        }
        this.oldLeftState = ((GateConnectionDigital)this.left()).getInput();
        this.oldRightState = ((GateConnectionDigital)this.right()).getInput();
    }

    @Override
    public void tick() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (((GateConnectionDigital)this.front()).getOutput()) {
            if (this.turnOff) {
                ((GateConnectionDigital)this.front()).setOutput(false);
                this.w3.setPower((byte)0);
                this.w1.setPower((byte)-1);
                this.w2.setPower((byte)-1);
                this.t.setState(false);
            }
            this.turnOff = !this.turnOff;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("leftTriggered", this.leftTriggered);
        tag.func_74757_a("rightTriggered", this.rightTriggered);
        tag.func_74757_a("oldLeftState", this.oldLeftState);
        tag.func_74757_a("oldRightState", this.oldRightState);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.leftTriggered = tag.func_74767_n("leftTriggered");
        this.rightTriggered = tag.func_74767_n("rightTriggered");
        this.oldLeftState = tag.func_74767_n("oldLeftState");
        this.oldRightState = tag.func_74767_n("oldRightState");
    }
}

