/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.ic;

import com.bluepowermod.part.gate.ic.GateIntegratedCircuit;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.init.QLBlocks;
import uk.co.qmunity.lib.tile.TileMultipart;
import uk.co.qmunity.lib.vec.Vec3d;

public class FakeWorldIC
extends World {
    private static FakeWorldIC INSTANCE = new FakeWorldIC();
    private GateIntegratedCircuit ic;

    public static FakeWorldIC getInstance() {
        return INSTANCE;
    }

    public FakeWorldIC() {
        super((ISaveHandler)new FakeWorldSaveHandler(), "IC_Fake_World", null, new WorldProvider(){

            public String func_80007_l() {
                return "IC_Fake_World";
            }
        }, new Profiler());
    }

    public void setIC(GateIntegratedCircuit ic) {
        this.ic = ic;
    }

    public GateIntegratedCircuit getIC() {
        return this.ic;
    }

    private TileMultipart getTile(int x, int z) {
        GateIntegratedCircuit ic = this.getIC();
        if (ic == null) {
            return null;
        }
        return ic.getTile(x, z);
    }

    protected IChunkProvider func_72970_h() {
        return null;
    }

    protected int func_152379_p() {
        return 0;
    }

    public Entity func_73045_a(int p_73045_1_) {
        return null;
    }

    public Block func_147439_a(int x, int y, int z) {
        try {
            if (y == 63) {
                return Blocks.field_150348_b;
            }
            if (y != 64) {
                return Blocks.field_150350_a;
            }
            if (this.ic == null || this.ic.getParent() == null || this.ic.getWorld() == null) {
                return Blocks.field_150350_a;
            }
            ForgeDirection d = null;
            if (x == -1 && z == (this.ic.getSize() - 1) / 2) {
                d = ForgeDirection.WEST;
            }
            if (x == this.ic.getSize() && z == (this.ic.getSize() - 1) / 2) {
                d = ForgeDirection.EAST;
            }
            if (x == (this.ic.getSize() - 1) / 2 && z == -1) {
                d = ForgeDirection.NORTH;
            }
            if (x == (this.ic.getSize() - 1) / 2 && z == this.ic.getSize()) {
                d = ForgeDirection.SOUTH;
            }
            if (d != null) {
                return new Vec3d(0.0, 0.0, 0.0, this.ic.getWorld()).add(d).rotate(0.0, (double)(90 * -this.ic.getRotation()), 0.0).add((double)this.ic.getX(), (double)this.ic.getY(), (double)this.ic.getZ()).getBlock();
            }
            if (x < 0 || x >= this.ic.getSize() || z < 0 || z >= this.ic.getSize()) {
                return Blocks.field_150350_a;
            }
            return QLBlocks.multipart;
        }
        catch (Exception ex) {
            return Blocks.field_150350_a;
        }
    }

    public int func_72805_g(int x, int y, int z) {
        try {
            if (this.ic == null || this.ic.getParent() == null || this.ic.getWorld() == null) {
                return 0;
            }
            ForgeDirection d = null;
            if (x == -1 && z == (this.ic.getSize() - 1) / 2) {
                d = ForgeDirection.WEST;
            }
            if (x == this.ic.getSize() && z == (this.ic.getSize() - 1) / 2) {
                d = ForgeDirection.EAST;
            }
            if (x == (this.ic.getSize() - 1) / 2 && z == -1) {
                d = ForgeDirection.NORTH;
            }
            if (x == (this.ic.getSize() - 1) / 2 && z == this.ic.getSize()) {
                d = ForgeDirection.SOUTH;
            }
            if (d != null) {
                return new Vec3d(0.0, 0.0, 0.0, this.ic.getWorld()).add(d).rotate(0.0, (double)(90 * -this.ic.getRotation()), 0.0).add((double)this.ic.getX(), (double)this.ic.getY(), (double)this.ic.getZ()).getBlockMeta();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return 0;
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        try {
            if (y != 64) {
                return null;
            }
            if (this.ic == null || this.ic.getParent() == null || this.ic.getWorld() == null) {
                return null;
            }
            ForgeDirection d = null;
            if (x == -1 && z == (this.ic.getSize() - 1) / 2) {
                d = ForgeDirection.WEST;
            }
            if (x == this.ic.getSize() && z == (this.ic.getSize() - 1) / 2) {
                d = ForgeDirection.EAST;
            }
            if (x == (this.ic.getSize() - 1) / 2 && z == -1) {
                d = ForgeDirection.NORTH;
            }
            if (x == (this.ic.getSize() - 1) / 2 && z == this.ic.getSize()) {
                d = ForgeDirection.SOUTH;
            }
            if (d != null) {
                return new Vec3d(0.0, 0.0, 0.0, this.ic.getWorld()).add(d).rotate(0.0, (double)(90 * -this.ic.getRotation()), 0.0).add((double)this.ic.getX(), (double)this.ic.getY(), (double)this.ic.getZ()).getTileEntity();
            }
            return this.getTile(x, z);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void func_147476_b(int p_147476_1_, int p_147476_2_, int p_147476_3_, TileEntity p_147476_4_) {
    }

    public void func_147453_f(int p_147453_1_, int p_147453_2_, int p_147453_3_, Block p_147453_4_) {
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.UP;
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        return side == ForgeDirection.UP;
    }

    private static class FakeWorldSaveHandler
    implements ISaveHandler {
        private FakeWorldSaveHandler() {
        }

        public WorldInfo func_75757_d() {
            return new WorldInfo(new NBTTagCompound());
        }

        public void func_75762_c() throws MinecraftException {
        }

        public IChunkLoader func_75763_a(WorldProvider p_75763_1_) {
            return null;
        }

        public void func_75755_a(WorldInfo p_75755_1_, NBTTagCompound p_75755_2_) {
        }

        public void func_75761_a(WorldInfo p_75761_1_) {
        }

        public IPlayerFileData func_75756_e() {
            return null;
        }

        public void func_75759_a() {
        }

        public File func_75765_b() {
            return null;
        }

        public File func_75758_b(String p_75758_1_) {
            return null;
        }

        public String func_75760_g() {
            return null;
        }
    }
}

