/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.supported;

import com.bluepowermod.BluePower;
import com.bluepowermod.api.block.IAdvancedSilkyRemovable;
import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnection;
import com.bluepowermod.api.gate.IGate;
import com.bluepowermod.api.misc.IScrewdriver;
import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IRedstoneConductor;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedwire;
import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.client.render.IconSupplier;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.item.ItemPart;
import com.bluepowermod.part.BPPartFaceRotate;
import com.bluepowermod.part.PartManager;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.gate.ic.FakeMultipartTileIC;
import com.bluepowermod.part.gate.supported.GateSupported;
import com.bluepowermod.part.wire.redstone.PartRedwireFace;
import com.bluepowermod.part.wire.redstone.WireHelper;
import com.bluepowermod.redstone.DummyRedstoneDevice;
import com.bluepowermod.redstone.RedstoneApi;
import com.bluepowermod.redstone.RedstoneConnectionCache;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.misc.Pair;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.IPartPlacement;
import uk.co.qmunity.lib.raytrace.QMovingObjectPosition;
import uk.co.qmunity.lib.transform.Rotation;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class GateNullCell
extends GateSupported<GateConnectionBase, GateConnectionBase, GateConnectionBase, GateConnectionBase, GateConnectionBase, GateConnectionBase>
implements IAdvancedSilkyRemovable,
IRedstoneConductor.IAdvancedRedstoneConductor,
IRedwire {
    private RedwireType typeA = null;
    private RedwireType typeB = null;
    private boolean bundledA = false;
    private boolean bundledB = false;
    private boolean inWorldA = false;
    private boolean inWorldB = false;
    private byte powerA;
    private byte powerB;
    private boolean[] nullcells = new boolean[7];
    private RedstoneConnectionCache redstoneConnections = new RedstoneConnectionCache(this);
    private boolean updatedA = false;
    private boolean updatedB = false;

    public GateNullCell() {
        this.redstoneConnections.listen();
    }

    public GateNullCell(RedwireType typeA, boolean bundledA, RedwireType typeB, boolean bundledB) {
        this.typeA = typeA;
        this.bundledA = bundledA;
        this.typeB = typeB;
        this.bundledB = bundledB;
        this.redstoneConnections.listen();
    }

    public RedwireType getTypeA() {
        return this.typeA;
    }

    public RedwireType getTypeB() {
        return this.typeB;
    }

    public boolean isBundledA() {
        return this.bundledA;
    }

    public boolean isBundledB() {
        return this.bundledB;
    }

    @Override
    protected String getGateType() {
        return "nullcell";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vec3i translation, RenderHelper renderer, RenderBlocks renderBlocks, int pass) {
        int i;
        ForgeDirection dir;
        super.renderStatic(translation, renderer, renderBlocks, pass);
        double height = 0.125;
        IIcon wire = IconSupplier.wire;
        if (this.typeA != null) {
            renderer.setColor(WireHelper.getColorForPowerLevel(this.typeA, this.powerA));
            dir = ForgeDirection.NORTH;
            for (i = 0; i < this.getRotation(); ++i) {
                dir = dir.getRotation(this.getFace().getOpposite());
            }
            dir = new Vec3d(0.0, 0.0, 0.0).add(dir).rotateUndo(this.getFace(), Vec3d.center).toForgeDirection();
            renderer.renderBox(new Vec3dCube(0.4375, 0.125, 0.0625, 0.5625, 0.125 + height, 0.9375), wire);
            renderer.renderBox(new Vec3dCube(0.4375, 0.125, 0.0, 0.5625, 0.125 + height / (double)(this.nullcells[dir.ordinal()] ? 1 : 2), 0.0625), wire);
            renderer.renderBox(new Vec3dCube(0.4375, 0.125, 0.9375, 0.5625, 0.125 + height / (double)(this.nullcells[dir.getOpposite().ordinal()] ? 1 : 2), 1.0), wire);
        }
        if (this.typeB != null) {
            renderer.setColor(WireHelper.getColorForPowerLevel(this.typeB, this.powerB));
            dir = ForgeDirection.WEST;
            for (i = 0; i < this.getRotation(); ++i) {
                dir = dir.getRotation(this.getFace().getOpposite());
            }
            if (!this.nullcells[(dir = new Vec3d(0.0, 0.0, 0.0).add(dir).rotateUndo(this.getFace(), Vec3d.center).toForgeDirection()).ordinal()]) {
                renderer.renderBox(new Vec3dCube(0.0, 0.125, 0.4375, 0.125, 0.625, 0.5625), wire);
            }
            if (!this.nullcells[dir.getOpposite().ordinal()]) {
                renderer.renderBox(new Vec3dCube(0.875, 0.125, 0.4375, 1.0, 0.625, 0.5625), wire);
            }
            renderer.renderBox(new Vec3dCube(0.0, 0.625, 0.4375, 1.0, 0.75, 0.5625), wire);
        }
        renderer.setColor(0xFFFFFF);
        renderer.resetTransformations();
        return true;
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        l.add(GateNullCell.getStackWithData(new GateNullCell(this.inWorldA ? null : this.typeA, this.inWorldA ? false : this.bundledA, this.inWorldB ? null : this.typeB, this.inWorldB ? false : this.bundledB)));
        if (this.inWorldA && this.typeA != null) {
            l.add(this.typeA.getPartInfo(MinecraftColor.NONE, this.bundledA).getStack());
        }
        if (this.inWorldB && this.typeB != null) {
            l.add(this.typeB.getPartInfo(MinecraftColor.NONE, this.bundledB).getStack());
        }
        return l;
    }

    @Override
    public ItemStack getPickedItem(QMovingObjectPosition mop) {
        if (BluePower.proxy.getPlayer().func_70093_af()) {
            return GateNullCell.getStackWithData(new GateNullCell(null, false, null, false));
        }
        return GateNullCell.getStackWithData(this);
    }

    @Override
    public void addTooltip(ItemStack item, List<String> tip) {
        try {
            GateNullCell gnc = (GateNullCell)((ItemPart)item.func_77973_b()).createPart(item, BluePower.proxy.getPlayer(), null, null);
            tip.add((Object)((Object)gnc.typeA) + (gnc.bundledA ? " (bundled)" : "") + " x " + (Object)((Object)gnc.typeB) + (gnc.bundledB ? " (bundled)" : ""));
            if (gnc.bundledA || gnc.bundledB) {
                tip.add((Object)((Object)MinecraftColor.RED) + "Disabled temporarily. Still not fully working.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<ItemStack> getSubItems() {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        l.addAll(super.getSubItems());
        for (int i = 0; i < 2; ++i) {
            for (RedwireType t : RedwireType.values()) {
                l.add(GateNullCell.getStackWithData(new GateNullCell(t, i == 1, t, i == 1)));
            }
        }
        return l;
    }

    public static ItemStack getStackWithData(GateNullCell gate) {
        ItemStack is = PartManager.getPartInfo("nullcell").getStack();
        if (is.func_77978_p() == null) {
            is.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = new NBTTagCompound();
        gate.writeToNBT(tag);
        is.func_77978_p().func_74782_a("tileData", (NBTBase)tag);
        is.func_77978_p().func_74757_a("hideSilkyTooltip", true);
        return is;
    }

    @Override
    public boolean preSilkyRemoval(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public void postSilkyRemoval(World world, int x, int y, int z) {
    }

    @Override
    public boolean writeSilkyData(World world, int x, int y, int z, NBTTagCompound tag) {
        if (this.typeA != null) {
            tag.func_74768_a("typeA", this.typeA.ordinal());
            tag.func_74757_a("bundledA", this.bundledA);
        }
        if (this.typeB != null) {
            tag.func_74768_a("typeB", this.typeB.ordinal());
            tag.func_74757_a("bundledB", this.bundledB);
        }
        return true;
    }

    @Override
    public void readSilkyData(World world, int x, int y, int z, NBTTagCompound tag) {
        if (tag.func_74764_b("typeA")) {
            this.typeA = RedwireType.values()[tag.func_74762_e("typeA")];
            this.bundledA = tag.func_74767_n("bundledA");
        } else {
            this.typeA = null;
            this.bundledA = false;
        }
        if (tag.func_74764_b("typeB")) {
            this.typeB = RedwireType.values()[tag.func_74762_e("typeB")];
            this.bundledB = tag.func_74767_n("bundledB");
        } else {
            this.typeB = null;
            this.bundledB = false;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        if (this.typeA != null) {
            tag.func_74768_a("typeA", this.typeA.ordinal());
            tag.func_74757_a("bundledA", this.bundledA);
            tag.func_74757_a("inWorldA", this.inWorldA);
        }
        if (this.typeB != null) {
            tag.func_74768_a("typeB", this.typeB.ordinal());
            tag.func_74757_a("bundledB", this.bundledB);
            tag.func_74757_a("inWorldB", this.inWorldB);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.func_74764_b("typeA")) {
            this.typeA = RedwireType.values()[tag.func_74762_e("typeA")];
            this.bundledA = tag.func_74767_n("bundledA");
            this.inWorldA = tag.func_74767_n("inWorldA");
        } else {
            this.typeA = null;
            this.bundledA = false;
            this.inWorldA = false;
        }
        if (tag.func_74764_b("typeB")) {
            this.typeB = RedwireType.values()[tag.func_74762_e("typeB")];
            this.bundledB = tag.func_74767_n("bundledB");
            this.inWorldB = tag.func_74767_n("inWorldB");
        } else {
            this.typeB = null;
            this.bundledB = false;
            this.inWorldB = false;
        }
    }

    public void writeUpdateData(DataOutput buffer, int channel) throws IOException {
        super.writeUpdateData(buffer, channel);
        if (channel == -1) {
            buffer.writeBoolean(this.typeA != null);
            if (this.typeA != null) {
                buffer.writeInt(this.typeA.ordinal());
                buffer.writeBoolean(this.bundledA);
            }
            buffer.writeBoolean(this.typeB != null);
            if (this.typeB != null) {
                buffer.writeInt(this.typeB.ordinal());
                buffer.writeBoolean(this.bundledB);
            }
        }
        if (channel == 1 || channel == -1) {
            buffer.writeByte(this.powerA);
        }
        if (channel == 2 || channel == -1) {
            buffer.writeByte(this.powerB);
        }
        if (channel == 3 || channel == -1) {
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                IConnection<IRedstoneDevice> c = this.redstoneConnections.getConnectionOnSide(d);
                buffer.writeBoolean(c != null && c.getB() instanceof GateNullCell && (this.getType(d) == 1 || ((BPPartFaceRotate)((Object)c.getB())).getRotation() % 2 == this.getRotation() % 2));
            }
        }
    }

    public void readUpdateData(DataInput buffer, int channel) throws IOException {
        super.readUpdateData(buffer, channel);
        if (channel == -1) {
            if (buffer.readBoolean()) {
                this.typeA = RedwireType.values()[buffer.readInt()];
                this.bundledA = buffer.readBoolean();
            } else {
                this.typeA = null;
                this.bundledA = false;
            }
            if (buffer.readBoolean()) {
                this.typeB = RedwireType.values()[buffer.readInt()];
                this.bundledB = buffer.readBoolean();
            } else {
                this.typeB = null;
                this.bundledB = false;
            }
        }
        if (channel == 1 || channel == -1) {
            this.powerA = buffer.readByte();
        }
        if (channel == 2 || channel == -1) {
            this.powerB = buffer.readByte();
        }
        if (channel == 3 || channel == -1) {
            for (int i = 0; i < 6; ++i) {
                this.nullcells[i] = buffer.readBoolean();
            }
        }
        if (this.getParent() != null && this.getWorld() != null) {
            this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
        }
    }

    @Override
    public void onUpdate() {
        if (!RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
            return;
        }
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.redstoneConnections.recalculateConnections();
        ForgeDirection d1 = null;
        ForgeDirection d2 = null;
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            if (d == this.getFace() || d == this.getFace().getOpposite()) continue;
            if (d1 == null) {
                d1 = d;
                continue;
            }
            if (d2 != null || d == d1.getOpposite()) continue;
            d2 = d;
        }
        RedstoneApi.getInstance().getRedstonePropagator(this, d1).propagate();
        RedstoneApi.getInstance().getRedstonePropagator(this, d2).propagate();
    }

    @Override
    public boolean canConnect(ForgeDirection side, IRedstoneDevice device, ConnectionType type) {
        if (type == ConnectionType.OPEN_CORNER && device instanceof IGate) {
            return false;
        }
        if (type == ConnectionType.STRAIGHT && (side == this.getFace().getOpposite() || side == ForgeDirection.UNKNOWN) && device instanceof DummyRedstoneDevice) {
            return false;
        }
        if (type == ConnectionType.CLOSED_CORNER) {
            if (side == this.getFace()) {
                return false;
            }
            if (side == this.getFace().getOpposite()) {
                return false;
            }
            if (side == ForgeDirection.UNKNOWN) {
                return false;
            }
        }
        if (device instanceof IRedwire) {
            RedwireType rwt = this.getRedwireType(side);
            if (rwt == null) {
                return false;
            }
            RedwireType rwt_ = ((IRedwire)((Object)device)).getRedwireType(type == ConnectionType.STRAIGHT ? side.getOpposite() : (type == ConnectionType.CLOSED_CORNER ? this.getFace() : this.getFace().getOpposite()));
            if (rwt_ == null) {
                return false;
            }
            return rwt.canConnectTo(rwt_);
        }
        return true;
    }

    @Override
    public RedstoneConnectionCache getRedstoneConnectionCache() {
        return this.redstoneConnections;
    }

    @Override
    public void setRedstonePower(ForgeDirection side, byte power) {
        int type = this.getType(side);
        if (type == 1 && this.typeA != null) {
            this.updatedA |= this.powerA != power;
            this.powerA = power;
        }
        if (type == 2 && this.typeB != null) {
            this.updatedB |= this.powerB != power;
            this.powerB = power;
        }
    }

    @Override
    public byte getRedstonePower(ForgeDirection side) {
        if (!RedstoneApi.getInstance().shouldWiresOutputPower(this.hasLoss(side))) {
            return 0;
        }
        int type = this.getType(side);
        if (type == 1 && this.typeA != null) {
            return (byte)(this.typeA.isAnalogue() ? ((this.powerA & 0xFF) > 0 ? 255 : 0) : this.powerA);
        }
        if (type == 2 && this.typeB != null) {
            return (byte)(this.typeB.isAnalogue() ? ((this.powerB & 0xFF) > 0 ? 255 : 0) : this.powerB);
        }
        return 0;
    }

    @Override
    public void onRedstoneUpdate() {
        if (this.updatedA) {
            this.sendUpdatePacket(1);
            this.updatedA = false;
        }
        if (this.updatedB) {
            this.sendUpdatePacket(2);
            this.updatedB = false;
        }
    }

    private int getType(ForgeDirection side) {
        ForgeDirection d = new Vec3d(0.0, 0.0, 0.0).add(side).rotateUndo(this.getFace(), new Vec3d(0.0, 0.0, 0.0)).rotate(0.0, (double)(90 * -this.getRotation()), 0.0).toForgeDirection();
        if (d == ForgeDirection.NORTH || d == ForgeDirection.SOUTH) {
            return 1;
        }
        if (d == ForgeDirection.WEST || d == ForgeDirection.EAST) {
            return 2;
        }
        return 0;
    }

    @Override
    public RedwireType getRedwireType(ForgeDirection side) {
        int type = this.getType(side);
        return type == 0 ? null : (type == 1 ? this.typeA : this.typeB);
    }

    @Override
    public boolean hasLoss(ForgeDirection side) {
        int type = this.getType(side);
        if (type == 1 && this.typeA != null) {
            return this.typeA.hasLoss();
        }
        if (type == 2 && this.typeB != null) {
            return this.typeB.hasLoss();
        }
        return false;
    }

    @Override
    public boolean isAnalogue(ForgeDirection side) {
        int type = this.getType(side);
        if (type == 1 && this.typeA != null) {
            return this.typeA.isAnalogue();
        }
        if (type == 2 && this.typeB != null) {
            return this.typeB.isAnalogue();
        }
        return false;
    }

    @Override
    public boolean canPropagateFrom(ForgeDirection fromSide) {
        return fromSide != this.getFace() && fromSide != this.getFace().getOpposite();
    }

    @Override
    public Collection<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> propagate(ForgeDirection fromSide) {
        if (this.getParent() instanceof FakeMultipartTileIC) {
            ((FakeMultipartTileIC)this.getParent()).getIC().loadWorld();
        }
        ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> l = new ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>>();
        if (!this.canPropagateFrom(fromSide)) {
            return l;
        }
        IConnection<IRedstoneDevice> c1 = this.getRedstoneConnectionCache().getConnectionOnSide(fromSide);
        IConnection<IRedstoneDevice> c2 = this.getRedstoneConnectionCache().getConnectionOnSide(fromSide.getOpposite());
        if (c1 != null) {
            l.add((Map.Entry<IConnection<IRedstoneDevice>, Boolean>)new Pair(c1, (Object)false));
        }
        if (c2 != null) {
            l.add((Map.Entry<IConnection<IRedstoneDevice>, Boolean>)new Pair(c2, (Object)false));
        }
        return l;
    }

    @Override
    public void onConnect(IConnection<?> connection) {
        this.sendUpdatePacket(3);
    }

    @Override
    public void onDisconnect(IConnection<?> connection) {
        this.sendUpdatePacket(3);
    }

    @Override
    public IPartPlacement getPlacement(IPart part, World world, Vec3i location, ForgeDirection face, MovingObjectPosition mop, EntityPlayer player) {
        if (this.bundledA || this.bundledB) {
            return null;
        }
        return super.getPlacement(part, world, location, face, mop, player);
    }

    @Override
    protected void addBoxes(List<Vec3dCube> boxes) {
        super.addBoxes(boxes);
        double height = 0.125;
        if (this.typeA != null) {
            boxes.add(new Vec3dCube(0.4375, 0.125, 0.0625, 0.5625, 0.125 + height, 0.9375));
            boxes.add(new Vec3dCube(0.4375, 0.125, 0.0, 0.5625, 0.125 + height / 2.0, 0.0625));
            boxes.add(new Vec3dCube(0.4375, 0.125, 0.9375, 0.5625, 0.125 + height / 2.0, 1.0));
        }
        if (this.typeB != null) {
            boxes.add(new Vec3dCube(0.0, 0.125, 0.4375, 0.125, 0.75, 0.5625));
            boxes.add(new Vec3dCube(0.875, 0.125, 0.4375, 1.0, 0.75, 0.5625));
            boxes.add(new Vec3dCube(0.125, 0.625, 0.4375, 0.875, 0.75, 0.5625));
        }
    }

    @Override
    public QMovingObjectPosition rayTrace(Vec3d start, Vec3d end) {
        QMovingObjectPosition mop = super.rayTrace(start, end);
        if (mop != null) {
            mop = new QMovingObjectPosition((MovingObjectPosition)mop, mop.getPart(), Vec3dCube.merge(this.getSelectionBoxes()));
        }
        return mop;
    }

    @Override
    public boolean drawHighlight(QMovingObjectPosition mop, EntityPlayer player, float frame) {
        Vec3d hit = new Vec3d(mop.field_72307_f).sub((double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d).rotateUndo(this.getFace(), Vec3d.center);
        Vec3 pos = player.func_70666_h(frame);
        ItemStack held = player.func_71045_bC();
        if (held == null) {
            return false;
        }
        if (held.func_77973_b() instanceof ItemPart) {
            IPart part = ((ItemPart)held.func_77973_b()).createPart(held, player, null, null);
            if (part == null) {
                return false;
            }
            if (!(part instanceof PartRedwireFace.PartRedwireFaceUninsulated)) {
                return false;
            }
            PartRedwireFace wire = (PartRedwireFace)part;
            RenderHelper renderer = RenderHelper.instance;
            renderer.fullReset();
            renderer.setRenderCoords((IBlockAccess)this.getWorld(), this.getX(), this.getY(), this.getZ());
            double height = 0.125;
            IIcon wireIcon = IconSupplier.wire;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78372_c((float)(-pos.field_72450_a), (float)(-pos.field_72448_b), (float)(-pos.field_72449_c));
            switch (this.getFace()) {
                case DOWN: {
                    break;
                }
                case UP: {
                    renderer.addTransformation((Transformation)new Rotation(180.0, 180.0, 0.0, Vec3d.center));
                    break;
                }
                case NORTH: {
                    renderer.addTransformation((Transformation)new Rotation(90.0, 0.0, 0.0, Vec3d.center));
                    break;
                }
                case SOUTH: {
                    renderer.addTransformation((Transformation)new Rotation(-90.0, 0.0, 0.0, Vec3d.center));
                    break;
                }
                case WEST: {
                    renderer.addTransformation((Transformation)new Rotation(0.0, 0.0, -90.0, Vec3d.center));
                    break;
                }
                case EAST: {
                    renderer.addTransformation((Transformation)new Rotation(0.0, 0.0, 90.0, Vec3d.center));
                    break;
                }
            }
            int rotation = this.getRotation();
            if (rotation != -1) {
                renderer.addTransformation((Transformation)new Rotation(0.0, (double)(90 * -rotation), 0.0));
            }
            renderer.setOpacity(0.5);
            renderer.setColor(WireHelper.getColorForPowerLevel(wire.getRedwireType(ForgeDirection.UNKNOWN), (byte)127));
            ForgeDirection dir = ForgeDirection.NORTH;
            if (this.getRotation() % 2 == 1) {
                dir = dir.getRotation(this.getFace());
            }
            if (hit.getY() > 0.125) {
                if (this.typeB == null) {
                    renderer.renderBox(new Vec3dCube(0.0, 0.125, 0.4375, 0.125, 0.625, 0.5625), wireIcon);
                    renderer.renderBox(new Vec3dCube(0.875, 0.125, 0.4375, 1.0, 0.625, 0.5625), wireIcon);
                    renderer.renderBox(new Vec3dCube(0.0, 0.625, 0.4375, 1.0, 0.75, 0.5625), wireIcon);
                }
            } else if (this.typeA == null) {
                renderer.renderBox(new Vec3dCube(0.4375, 0.125, 0.0, 0.5625, 0.125 + height, 1.0), wireIcon);
            }
            renderer.fullReset();
            Tessellator.field_78398_a.func_78372_c((float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c);
            Tessellator.field_78398_a.func_78381_a();
            GL11.glDisable((int)3042);
            return true;
        }
        if (held.func_77973_b() instanceof IScrewdriver) {
            // empty if block
        }
        return false;
    }

    @Override
    public boolean onActivated(EntityPlayer player, QMovingObjectPosition mop, ItemStack item) {
        Vec3d hit = new Vec3d(mop.field_72307_f).sub((double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d).rotateUndo(this.getFace(), Vec3d.center);
        if (item != null) {
            if (item.func_77973_b() instanceof ItemPart) {
                IPart part = ((ItemPart)item.func_77973_b()).createPart(item, player, null, null);
                if (part != null && part instanceof PartRedwireFace.PartRedwireFaceUninsulated) {
                    PartRedwireFace wire = (PartRedwireFace)part;
                    if (hit.getY() > 0.125) {
                        if (this.typeB == null) {
                            if (this.getWorld().field_72995_K) {
                                return true;
                            }
                            this.typeB = wire.getRedwireType(ForgeDirection.UNKNOWN);
                            this.bundledB = false;
                            this.inWorldB = true;
                            this.getRedstoneConnectionCache().recalculateConnections();
                            this.sendUpdatePacket();
                            if (!player.field_71075_bZ.field_75098_d) {
                                --item.field_77994_a;
                            }
                            return true;
                        }
                    } else if (this.typeA == null) {
                        if (this.getWorld().field_72995_K) {
                            return true;
                        }
                        this.typeA = wire.getRedwireType(ForgeDirection.UNKNOWN);
                        this.bundledA = false;
                        this.inWorldA = true;
                        this.getRedstoneConnectionCache().recalculateConnections();
                        this.sendUpdatePacket();
                        if (!player.field_71075_bZ.field_75098_d) {
                            --item.field_77994_a;
                        }
                        return true;
                    }
                }
            } else if (item.func_77973_b() instanceof IScrewdriver && player.func_70093_af()) {
                if (hit.getY() > 0.125 && (hit.getY() <= 0.25 && hit.getX() > 0.4375 && hit.getX() > 0.5625 || hit.getY() > 0.25)) {
                    if (this.typeB != null) {
                        if (this.getWorld().field_72995_K) {
                            return true;
                        }
                        IOHelper.spawnItemInWorld(this.getWorld(), this.typeB.getPartInfo(MinecraftColor.NONE, this.bundledB).getStack(), (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5);
                        this.typeB = null;
                        this.bundledB = false;
                        this.inWorldB = false;
                        ((IScrewdriver)item.func_77973_b()).damage(item, 1, player, false);
                        this.getRedstoneConnectionCache().recalculateConnections();
                        this.sendUpdatePacket();
                        return true;
                    }
                } else if (hit.getY() > 0.125 && this.typeA != null) {
                    if (this.getWorld().field_72995_K) {
                        return true;
                    }
                    IOHelper.spawnItemInWorld(this.getWorld(), this.typeA.getPartInfo(MinecraftColor.NONE, this.bundledA).getStack(), (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5);
                    this.typeA = null;
                    this.bundledA = false;
                    this.inWorldA = false;
                    ((IScrewdriver)item.func_77973_b()).damage(item, 1, player, false);
                    this.getRedstoneConnectionCache().recalculateConnections();
                    this.sendUpdatePacket();
                    return true;
                }
            }
        }
        return super.onActivated(player, mop, item);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GateNullCell)) {
            return false;
        }
        if (this.getParent() == null && this.getWorld() == null) {
            GateNullCell g = (GateNullCell)obj;
            return g.typeA == this.typeA && g.bundledA == this.bundledA && g.typeB == this.typeB && g.bundledB == this.bundledB;
        }
        return super.equals(obj);
    }
}

