/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.wireless;

import com.bluepowermod.api.misc.Accessibility;
import com.bluepowermod.api.wireless.IBundledFrequency;
import com.bluepowermod.api.wireless.IFrequency;
import com.bluepowermod.api.wireless.IRedstoneFrequency;
import com.bluepowermod.api.wireless.IWirelessDevice;
import com.bluepowermod.part.gate.wireless.WirelessManager;
import com.mojang.authlib.GameProfile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class Frequency
implements IFrequency {
    private Accessibility accessibility;
    private UUID owner;
    private String ownerName;
    private String frequency;
    private boolean bundled;
    private int devices = 0;

    public Frequency(Accessibility accessibility, UUID owner, String frequency) {
        this.accessibility = accessibility;
        this.owner = owner;
        this.frequency = frequency;
        for (GameProfile p : MinecraftServer.func_71276_C().func_152357_F()) {
            if (!p.getId().equals(owner)) continue;
            this.ownerName = p.getName();
            break;
        }
    }

    public Frequency() {
    }

    @Override
    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public String getFrequencyName() {
        return this.frequency;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setAccessibility(Accessibility accessibility) {
        this.accessibility = accessibility;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("freq_accessibility", this.accessibility.ordinal());
        tag.func_74778_a("freq_owner", this.owner.toString());
        tag.func_74778_a("freq_name", this.frequency);
        tag.func_74757_a("freq_bundled", this.isBundled());
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.accessibility = Accessibility.values()[tag.func_74762_e("freq_accessibility")];
        this.owner = UUID.fromString(tag.func_74779_i("freq_owner"));
        this.frequency = tag.func_74779_i("freq_name");
        this.bundled = tag.func_74767_n("freq_bundled");
    }

    public void writeToBuffer(DataOutput buf) throws IOException {
        buf.writeInt(this.accessibility.ordinal());
        buf.writeUTF(this.owner.toString());
        buf.writeUTF(this.ownerName.toString());
        buf.writeUTF(this.frequency.toString());
        buf.writeBoolean(this.isBundled());
        int amt = 0;
        for (IWirelessDevice d : WirelessManager.COMMON_INSTANCE.getDevices()) {
            if (d.getFrequency() == null || !d.getFrequency().equals(this)) continue;
            ++amt;
        }
        buf.writeInt(amt);
    }

    public void readFromBuffer(DataInput buf) throws IOException {
        this.accessibility = Accessibility.values()[buf.readInt()];
        this.owner = UUID.fromString(buf.readUTF());
        this.ownerName = buf.readUTF();
        this.frequency = buf.readUTF();
        this.bundled = buf.readBoolean();
        this.devices = buf.readInt();
    }

    @Override
    public void notifyClients() {
    }

    public boolean isBundled() {
        if (this instanceof IBundledFrequency) {
            return true;
        }
        return this.bundled;
    }

    public int getDevices() {
        return this.devices;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Frequency) {
            Frequency f = (Frequency)obj;
            return f.accessibility == this.accessibility && f.owner.equals(this.owner) && f.frequency.equals(this.frequency) && f.isBundled() == this.isBundled();
        }
        return false;
    }

    public static final class BundledFrequency
    extends Frequency
    implements IBundledFrequency {
        private byte[] signal = new byte[1];

        public BundledFrequency(Accessibility accessibility, UUID owner, String frequency) {
            super(accessibility, owner, frequency);
        }

        @Override
        public byte[] getSignal() {
            return this.signal;
        }

        @Override
        public void setSignal(byte[] signal) {
            if (signal == null) {
                Arrays.fill(signal, (byte)0);
                return;
            }
            this.signal = signal;
        }
    }

    public static final class RedstoneFrequency
    extends Frequency
    implements IRedstoneFrequency {
        private byte signal = 0;

        public RedstoneFrequency(Accessibility accessibility, UUID owner, String frequency) {
            super(accessibility, owner, frequency);
        }

        @Override
        public byte getSignal() {
            return this.signal;
        }

        @Override
        public void setSignal(byte signal) {
            this.signal = signal;
        }
    }
}

