/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.wireless;

import com.bluepowermod.api.misc.Accessibility;
import com.bluepowermod.api.wireless.IBundledFrequency;
import com.bluepowermod.api.wireless.IFrequency;
import com.bluepowermod.api.wireless.IRedstoneFrequency;
import com.bluepowermod.api.wireless.IWirelessDevice;
import com.bluepowermod.api.wireless.IWirelessManager;
import com.bluepowermod.part.gate.wireless.Frequency;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import uk.co.qmunity.lib.friend.FriendManager;
import uk.co.qmunity.lib.friend.IPlayer;

public final class WirelessManager
implements IWirelessManager {
    public static final WirelessManager COMMON_INSTANCE = new WirelessManager();
    public static final WirelessManager CLIENT_INSTANCE = new WirelessManager();
    private List<IFrequency> frequencies = new ArrayList<IFrequency>();
    private List<IRedstoneFrequency> redstoneFrequencies = new ArrayList<IRedstoneFrequency>();
    private List<IBundledFrequency> bundledFrequencies = new ArrayList<IBundledFrequency>();
    private List<IWirelessDevice> devices = new ArrayList<IWirelessDevice>();

    private WirelessManager() {
    }

    @Override
    public List<IRedstoneFrequency> getRedstoneFrequencies() {
        return this.redstoneFrequencies;
    }

    @Override
    public List<IBundledFrequency> getBundledFrequencies() {
        return this.bundledFrequencies;
    }

    @Override
    public List<IFrequency> getFrequencies() {
        return this.frequencies;
    }

    @Override
    public List<IRedstoneFrequency> getAvailableRedstoneFrequencies(EntityPlayer player) {
        UUID uuid = player.func_146103_bH().getId();
        List friends = FriendManager.getFriends((UUID)uuid);
        ArrayList<IRedstoneFrequency> frequencies = new ArrayList<IRedstoneFrequency>();
        for (IRedstoneFrequency freq : this.redstoneFrequencies) {
            if (!this.canAccess(freq, uuid, friends)) continue;
            frequencies.add(freq);
        }
        return frequencies;
    }

    @Override
    public List<IBundledFrequency> getAvailableBundledFrequencies(EntityPlayer player) {
        UUID uuid = player.func_146103_bH().getId();
        List friends = FriendManager.getFriends((UUID)uuid);
        ArrayList<IBundledFrequency> frequencies = new ArrayList<IBundledFrequency>();
        for (IBundledFrequency freq : this.bundledFrequencies) {
            if (!this.canAccess(freq, uuid, friends)) continue;
            frequencies.add(freq);
        }
        return frequencies;
    }

    private boolean canAccess(IFrequency freq, UUID uuid, List<IPlayer> friends) {
        if (freq.getOwner().equals(uuid) || freq.getAccessibility() == Accessibility.PUBLIC) {
            return true;
        }
        if (freq.getAccessibility() == Accessibility.SHARED) {
            for (IPlayer friend : friends) {
                if (!freq.getOwner().equals(friend.getUUID())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IRedstoneFrequency registerRedstoneFrequency(EntityPlayer owner, String frequency, Accessibility accessibility) {
        for (IRedstoneFrequency iRedstoneFrequency : this.redstoneFrequencies) {
            if (!(accessibility == Accessibility.PUBLIC ? iRedstoneFrequency.getFrequencyName().equals(frequency) && iRedstoneFrequency.getAccessibility() == Accessibility.PUBLIC : iRedstoneFrequency.getOwner().equals(owner.func_146103_bH().getId()) && iRedstoneFrequency.getFrequencyName().equals(frequency) && (iRedstoneFrequency.getAccessibility() == Accessibility.PRIVATE || iRedstoneFrequency.getAccessibility() == Accessibility.SHARED))) continue;
            return iRedstoneFrequency;
        }
        for (IBundledFrequency iBundledFrequency : this.bundledFrequencies) {
            if (!(accessibility == Accessibility.PUBLIC ? iBundledFrequency.getFrequencyName().equals(frequency) && iBundledFrequency.getAccessibility() == Accessibility.PUBLIC : iBundledFrequency.getOwner().equals(owner.func_146103_bH().getId()) && iBundledFrequency.getFrequencyName().equals(frequency) && (iBundledFrequency.getAccessibility() == Accessibility.PRIVATE || iBundledFrequency.getAccessibility() == Accessibility.SHARED))) continue;
            return null;
        }
        System.out.println(":/ " + owner.field_70170_p.field_72995_K + " " + owner.func_146103_bH().getId() + " - " + frequency + " " + (Object)((Object)accessibility));
        Frequency.RedstoneFrequency freq = new Frequency.RedstoneFrequency(accessibility, owner == null ? UUID.randomUUID() : owner.func_146103_bH().getId(), frequency);
        this.redstoneFrequencies.add(freq);
        this.frequencies.add(freq);
        return freq;
    }

    @Override
    public IBundledFrequency registerBundledFrequency(EntityPlayer owner, String frequency, Accessibility accessibility) {
        for (IRedstoneFrequency iRedstoneFrequency : this.redstoneFrequencies) {
            if (!(accessibility == Accessibility.PUBLIC ? iRedstoneFrequency.getFrequencyName().equals(frequency) && iRedstoneFrequency.getAccessibility() == Accessibility.PUBLIC : iRedstoneFrequency.getOwner().equals(owner.func_146103_bH().getId()) && iRedstoneFrequency.getFrequencyName().equals(frequency) && (iRedstoneFrequency.getAccessibility() == Accessibility.PRIVATE || iRedstoneFrequency.getAccessibility() == Accessibility.SHARED))) continue;
            return null;
        }
        for (IBundledFrequency iBundledFrequency : this.bundledFrequencies) {
            if (!(accessibility == Accessibility.PUBLIC ? iBundledFrequency.getFrequencyName().equals(frequency) && iBundledFrequency.getAccessibility() == Accessibility.PUBLIC : iBundledFrequency.getOwner().equals(owner.func_146103_bH().getId()) && iBundledFrequency.getFrequencyName().equals(frequency) && (iBundledFrequency.getAccessibility() == Accessibility.PRIVATE || iBundledFrequency.getAccessibility() == Accessibility.SHARED))) continue;
            return iBundledFrequency;
        }
        Frequency.BundledFrequency freq = new Frequency.BundledFrequency(accessibility, owner == null ? UUID.randomUUID() : owner.func_146103_bH().getId(), frequency);
        this.bundledFrequencies.add(freq);
        this.frequencies.add(freq);
        return freq;
    }

    @Override
    public IFrequency registerFrequency(EntityPlayer owner, String frequency, Accessibility accessibility, boolean isBundled) {
        return isBundled ? this.registerBundledFrequency(owner, frequency, accessibility) : this.registerRedstoneFrequency(owner, frequency, accessibility);
    }

    @Override
    public IFrequency registerFrequency(IFrequency frequency) {
        if (frequency instanceof Frequency) {
            this.frequencies.add(frequency);
        }
        if (frequency instanceof Frequency.BundledFrequency) {
            this.bundledFrequencies.add((IBundledFrequency)frequency);
            return frequency;
        }
        if (frequency instanceof Frequency.RedstoneFrequency) {
            this.redstoneFrequencies.add((IRedstoneFrequency)frequency);
            return frequency;
        }
        if (frequency instanceof Frequency) {
            return frequency;
        }
        return null;
    }

    @Override
    public void unregisterFrequency(IFrequency frequency) {
        this.frequencies.remove(frequency);
        this.redstoneFrequencies.remove(frequency);
        this.bundledFrequencies.remove(frequency);
        for (IWirelessDevice d : this.devices) {
            if (d.getFrequency() == null || !d.getFrequency().equals(frequency)) continue;
            d.setFrequency(null);
        }
    }

    @Override
    public IFrequency getFrequency(Accessibility accessibility, String frequency, UUID owner) {
        for (IRedstoneFrequency iRedstoneFrequency : this.redstoneFrequencies) {
            if (!iRedstoneFrequency.getAccessibility().equals((Object)accessibility) || !iRedstoneFrequency.getFrequencyName().equals(frequency) || !iRedstoneFrequency.getOwner().equals(owner)) continue;
            return iRedstoneFrequency;
        }
        for (IBundledFrequency iBundledFrequency : this.bundledFrequencies) {
            if (!iBundledFrequency.getAccessibility().equals((Object)accessibility) || !iBundledFrequency.getFrequencyName().equals(frequency) || !iBundledFrequency.getOwner().equals(owner)) continue;
            return iBundledFrequency;
        }
        for (IFrequency iFrequency : this.frequencies) {
            if (!iFrequency.getAccessibility().equals((Object)accessibility) || !iFrequency.getFrequencyName().equals(frequency) || !iFrequency.getOwner().equals(owner)) continue;
            return iFrequency;
        }
        return null;
    }

    @Override
    public void registerWirelessDevice(IWirelessDevice device) {
        if (this.devices.contains(device)) {
            return;
        }
        this.devices.add(device);
    }

    @Override
    public void unregisterWirelessDevice(IWirelessDevice device) {
        this.devices.remove(device);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
    }

    @SubscribeEvent
    public void onServerStop(FMLServerStoppingEvent event) {
    }

    public void loadFrequencies(World world) {
    }

    public void unloadFrequencies() {
        this.frequencies.clear();
        this.redstoneFrequencies.clear();
        this.bundledFrequencies.clear();
    }

    public List<IWirelessDevice> getDevices() {
        return this.devices;
    }
}

