/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.tube;

import com.bluepowermod.client.render.IconSupplier;
import com.bluepowermod.part.tube.PneumaticTube;
import com.bluepowermod.part.tube.TubeLogic;
import com.bluepowermod.part.tube.TubeStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.vec.Vec3dCube;

public class MagTube
extends PneumaticTube {
    @Override
    public String getType() {
        return "magTube";
    }

    @Override
    public String getUnlocalizedName() {
        return "magTube";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IIcon getSideIcon() {
        return IconSupplier.magTubeSide;
    }

    @Override
    protected boolean canConnectToInventories() {
        return false;
    }

    @Override
    public List<Vec3dCube> getSelectionBoxes() {
        List<Vec3dCube> aabbs = super.getSelectionBoxes();
        if (!this.shouldRenderNode()) {
            if (this.connections[0]) {
                aabbs.add(new Vec3dCube(0.125, 0.125, 0.125, 0.875, 0.375, 0.875));
                aabbs.add(new Vec3dCube(0.125, 0.625, 0.125, 0.875, 0.875, 0.875));
            } else if (this.connections[2]) {
                aabbs.add(new Vec3dCube(0.125, 0.125, 0.125, 0.875, 0.875, 0.375));
                aabbs.add(new Vec3dCube(0.125, 0.125, 0.625, 0.875, 0.875, 0.875));
            } else if (this.connections[4]) {
                aabbs.add(new Vec3dCube(0.125, 0.125, 0.125, 0.375, 0.875, 0.875));
                aabbs.add(new Vec3dCube(0.625, 0.125, 0.125, 0.875, 0.875, 0.875));
            }
        }
        return aabbs;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void renderSide() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Tessellator t = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        if (this.getParent() != null && this.getWorld() != null) {
            if (this.connections[2]) {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
            } else if (this.connections[4]) {
                GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
            }
        }
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        t.func_78382_b();
        double min = 0.125;
        double max = 0.875;
        double inMin = 0.7500625;
        double inMax = 0.2499375;
        IIcon icon = IconSupplier.magCoilSide;
        double minX = icon.func_94214_a(min * 16.0);
        double maxX = icon.func_94214_a(max * 16.0);
        double minY = icon.func_94207_b(min * 16.0);
        double maxY = icon.func_94207_b(max * 16.0);
        t.func_78375_b(0.0f, 0.0f, 1.0f);
        t.func_78374_a(min, min, max, maxX, maxY);
        t.func_78374_a(max, min, max, minX, maxY);
        t.func_78374_a(max, max, max, minX, minY);
        t.func_78374_a(min, max, max, maxX, minY);
        t.func_78374_a(min, min, inMax, maxX, maxY);
        t.func_78374_a(max, min, inMax, minX, maxY);
        t.func_78374_a(max, max, inMax, minX, minY);
        t.func_78374_a(min, max, inMax, maxX, minY);
        t.func_78375_b(0.0f, 0.0f, -1.0f);
        t.func_78374_a(min, min, min, minX, maxY);
        t.func_78374_a(min, max, min, minX, minY);
        t.func_78374_a(max, max, min, maxX, minY);
        t.func_78374_a(max, min, min, maxX, maxY);
        t.func_78374_a(min, min, inMin, maxX, maxY);
        t.func_78374_a(min, max, inMin, minX, minY);
        t.func_78374_a(max, max, inMin, minX, minY);
        t.func_78374_a(max, min, inMin, maxX, maxY);
        t.func_78375_b(-1.0f, 0.0f, 0.0f);
        t.func_78374_a(min, min, min, maxX, maxY);
        t.func_78374_a(min, min, max, minX, maxY);
        t.func_78374_a(min, max, max, minX, minY);
        t.func_78374_a(min, max, min, maxX, minY);
        t.func_78374_a(inMin, min, min, maxX, maxY);
        t.func_78374_a(inMin, min, max, minX, maxY);
        t.func_78374_a(inMin, max, max, minX, minY);
        t.func_78374_a(inMin, max, min, maxX, minY);
        t.func_78375_b(1.0f, 0.0f, 0.0f);
        t.func_78374_a(max, min, min, minX, minY);
        t.func_78374_a(max, max, min, minX, maxY);
        t.func_78374_a(max, max, max, maxX, maxY);
        t.func_78374_a(max, min, max, maxX, minY);
        t.func_78374_a(inMax, min, min, maxX, minY);
        t.func_78374_a(inMax, max, min, minX, maxY);
        t.func_78374_a(inMax, max, max, minX, maxY);
        t.func_78374_a(inMax, min, max, maxX, minY);
        icon = IconSupplier.magCoilFront;
        minX = icon.func_94214_a(min * 16.0);
        maxX = icon.func_94214_a(max * 16.0);
        minY = icon.func_94207_b(min * 16.0);
        maxY = icon.func_94207_b(max * 16.0);
        for (int i = 2; i < 16; i += 8) {
            t.func_78375_b(0.0f, 1.0f, 0.0f);
            t.func_78374_a(min, 1.0 - (double)i / 16.0, min, maxX, maxY);
            t.func_78374_a(min, 1.0 - (double)i / 16.0, max, minX, maxY);
            t.func_78374_a(max, 1.0 - (double)i / 16.0, max, minX, minY);
            t.func_78374_a(max, 1.0 - (double)i / 16.0, min, maxX, minY);
            t.func_78375_b(0.0f, -1.0f, 0.0f);
            t.func_78374_a(min, (double)i / 16.0, min, maxX, maxY);
            t.func_78374_a(max, (double)i / 16.0, min, minX, maxY);
            t.func_78374_a(max, (double)i / 16.0, max, minX, minY);
            t.func_78374_a(min, (double)i / 16.0, max, maxX, minY);
        }
        t.func_78381_a();
        GL11.glPopMatrix();
    }

    @Override
    public void update() {
        super.update();
        TubeLogic logic = this.getLogic();
        for (TubeStack stack : logic.tubeStacks) {
            stack.setSpeed(Math.max(stack.getSpeed() - 0.03125, 0.0625));
        }
    }
}

