/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.tube;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.client.render.RenderHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.vec.Vec3dCube;

public class TubeStack {
    public ItemStack stack;
    public final IPneumaticTube.TubeColor color;
    public double progress;
    public double oldProgress;
    public ForgeDirection heading;
    public boolean enabled = true;
    public int idleCounter;
    private TileEntity target;
    private int targetX;
    private int targetY;
    private int targetZ;
    private ForgeDirection targetEntryDir = ForgeDirection.UNKNOWN;
    public static final double ITEM_SPEED = 0.0625;
    private double speed = 0.0625;
    public static double tickTimeMultiplier = 1.0;
    @SideOnly(value=Side.CLIENT)
    private static RenderItem customRenderItem;
    private static EntityItem renderedItem;
    public static RenderMode renderMode;

    public TubeStack(ItemStack stack, ForgeDirection from) {
        this(stack, from, IPneumaticTube.TubeColor.NONE);
    }

    public TubeStack(ItemStack stack, ForgeDirection from, IPneumaticTube.TubeColor color) {
        this.heading = from;
        this.stack = stack;
        this.color = color;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getSpeed() {
        return this.speed;
    }

    public boolean update(World worldObj) {
        this.oldProgress = this.progress;
        if (this.enabled) {
            boolean isEntering = this.progress < 0.5;
            this.progress += this.speed * (worldObj.field_72995_K ? tickTimeMultiplier : 1.0);
            return this.progress >= 0.5 && isEntering;
        }
        ++this.idleCounter;
        return false;
    }

    public TileEntity getTarget(World world) {
        if (this.target == null && (this.targetX != 0 || this.targetY != 0 || this.targetZ != 0)) {
            this.target = world.func_147438_o(this.targetX, this.targetY, this.targetZ);
        }
        return this.target;
    }

    public ForgeDirection getTargetEntryDir() {
        return this.targetEntryDir;
    }

    public void setTarget(TileEntity tileEntity, ForgeDirection targetEntryDir) {
        this.targetEntryDir = targetEntryDir;
        this.target = tileEntity;
        if (this.target != null) {
            this.targetX = this.target.field_145851_c;
            this.targetY = this.target.field_145848_d;
            this.targetZ = this.target.field_145849_e;
        } else {
            this.targetX = 0;
            this.targetY = 0;
            this.targetZ = 0;
        }
    }

    public TubeStack copy() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return TubeStack.loadFromNBT(tag);
    }

    public void writeToNBT(NBTTagCompound tag) {
        this.stack.func_77955_b(tag);
        tag.func_74774_a("color", (byte)this.color.ordinal());
        tag.func_74774_a("heading", (byte)this.heading.ordinal());
        tag.func_74780_a("progress", this.progress);
        tag.func_74780_a("speed", this.speed);
        tag.func_74768_a("targetX", this.targetX);
        tag.func_74768_a("targetY", this.targetY);
        tag.func_74768_a("targetZ", this.targetZ);
        tag.func_74774_a("targetEntryDir", (byte)this.targetEntryDir.ordinal());
    }

    public static TubeStack loadFromNBT(NBTTagCompound tag) {
        TubeStack stack = new TubeStack(ItemStack.func_77949_a((NBTTagCompound)tag), ForgeDirection.getOrientation((int)tag.func_74771_c("heading")), IPneumaticTube.TubeColor.values()[tag.func_74771_c("color")]);
        stack.progress = tag.func_74769_h("progress");
        stack.speed = tag.func_74769_h("speed");
        stack.targetX = tag.func_74762_e("targetX");
        stack.targetY = tag.func_74762_e("targetY");
        stack.targetZ = tag.func_74762_e("targetZ");
        stack.targetEntryDir = ForgeDirection.getOrientation((int)tag.func_74771_c("targetEntryDir"));
        return stack;
    }

    public void writeToPacket(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        buf.writeByte(this.heading.ordinal());
        buf.writeByte((int)((byte)this.color.ordinal()));
        buf.writeDouble(this.speed);
        buf.writeDouble(this.progress);
    }

    public static TubeStack loadFromPacket(ByteBuf buf) {
        TubeStack stack = new TubeStack(ByteBufUtils.readItemStack((ByteBuf)buf), ForgeDirection.getOrientation((int)buf.readByte()), IPneumaticTube.TubeColor.values()[buf.readByte()]);
        stack.speed = buf.readDouble();
        stack.progress = buf.readDouble();
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float partialTick) {
        float size;
        if (renderMode == RenderMode.AUTO) {
            renderMode = Minecraft.func_71410_x().field_71474_y.field_74347_j ? RenderMode.NORMAL : RenderMode.REDUCED;
        }
        final RenderMode finalRenderMode = renderMode;
        if (customRenderItem == null) {
            customRenderItem = new RenderItem(){

                public boolean shouldBob() {
                    return false;
                }

                public byte getMiniBlockCount(ItemStack stack, byte original) {
                    return finalRenderMode == RenderMode.REDUCED ? (byte)1 : original;
                }
            };
            customRenderItem.func_76976_a(RenderManager.field_78727_a);
            renderedItem = new EntityItem((World)FMLClientHandler.instance().getWorldClient());
            TubeStack.renderedItem.field_70290_d = 0.0f;
        }
        renderedItem.func_92058_a(this.stack);
        double renderProgress = (this.oldProgress + (this.progress - this.oldProgress) * (double)partialTick) * 2.0 - 1.0;
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)this.heading.offsetX * renderProgress * 0.5), (double)((double)this.heading.offsetY * renderProgress * 0.5), (double)((double)this.heading.offsetZ * renderProgress * 0.5));
        if (finalRenderMode != RenderMode.NONE) {
            GL11.glPushMatrix();
            if (this.stack.field_77994_a > 5) {
                GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
            }
            if (!(this.stack.func_77973_b() instanceof ItemBlock)) {
                GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
                GL11.glTranslated((double)0.0, (double)-0.15, (double)0.0);
            }
            customRenderItem.func_76986_a(renderedItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
        } else {
            size = 0.02f;
            GL11.glDisable((int)3553);
            GL11.glBegin((int)7);
            RenderHelper.drawColoredCube(new Vec3dCube((double)(-size), (double)(-size), (double)(-size), (double)size, (double)size, (double)size), 1.0, 1.0, 1.0, 1.0, new boolean[0]);
            GL11.glEnd();
            GL11.glEnable((int)3553);
        }
        if (this.color != IPneumaticTube.TubeColor.NONE) {
            size = 0.2f;
            int colorInt = ItemDye.field_150922_c[this.color.ordinal()];
            float red = (float)(colorInt >> 16) / 256.0f;
            float green = (float)(colorInt >> 8 & 0xFF) / 256.0f;
            float blue = (float)(colorInt & 0xFF) / 256.0f;
            GL11.glDisable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glColor3f((float)red, (float)green, (float)blue);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("bluepower", "textures/blocks/tubes/inside_color_border.png"));
            RenderHelper.drawTesselatedTexturedCube(new Vec3dCube((double)(-size), (double)(-size), (double)(-size), (double)size, (double)size, (double)size));
            GL11.glEnable((int)2884);
            GL11.glEnable((int)2896);
        }
        GL11.glPopMatrix();
    }

    public static enum RenderMode {
        AUTO,
        NORMAL,
        REDUCED,
        NONE;

    }
}

