/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.wire;

import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.misc.IFace;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.part.MicroblockShape;
import uk.co.qmunity.lib.part.compat.OcclusionHelper;
import uk.co.qmunity.lib.vec.IWorldLocation;
import uk.co.qmunity.lib.vec.Vec3i;

public class ConnectionLogicHelper<T extends IWorldLocation, C> {
    private IConnectableProvider<T, C> provider;

    public ConnectionLogicHelper(IConnectableProvider<T, C> provider) {
        this.provider = provider;
    }

    public C getNeighbor(T device, ForgeDirection side) {
        Vec3i block;
        Block b;
        Vec3i loc;
        T dev;
        ForgeDirection face = ForgeDirection.UNKNOWN;
        if (device instanceof IFace) {
            face = ((IFace)device).getFace();
        }
        if ((dev = this.provider.getConnectableAt((loc = new Vec3i(device)).getWorld(), loc.getX(), loc.getY(), loc.getZ(), side == face.getOpposite() ? ForgeDirection.UNKNOWN : side, face == ForgeDirection.UNKNOWN ? side.getOpposite() : face)) != null && dev != device && this.provider.isValidClosedCorner(dev)) {
            ConnectionType type;
            ConnectionType connectionType = type = (device instanceof IFace || dev instanceof IFace) && device instanceof IFace != dev instanceof IFace ? ConnectionType.STRAIGHT : ConnectionType.CLOSED_CORNER;
            if (this.provider.canConnect(device, dev, side, type) && this.provider.canConnect(dev, device, face, type)) {
                return this.provider.createConnection(device, dev, side, face, type);
            }
        }
        if (face != ForgeDirection.UNKNOWN && (dev = this.provider.getConnectableAt((loc = new Vec3i(device).add(face).add(side)).getWorld(), loc.getX(), loc.getY(), loc.getZ(), side.getOpposite(), face.getOpposite())) != null && dev != device && this.provider.isValidOpenCorner(dev) && !(b = (block = new Vec3i(device).add(side)).getBlock()).func_149721_r() && b != Blocks.field_150451_bX && OcclusionHelper.microblockOcclusionTest((Vec3i)block, (MicroblockShape)MicroblockShape.EDGE, (int)2, (ForgeDirection[])new ForgeDirection[]{face, side.getOpposite()}) && this.provider.canConnect(device, dev, side, ConnectionType.OPEN_CORNER) && this.provider.canConnect(dev, device, face.getOpposite(), ConnectionType.OPEN_CORNER)) {
            return this.provider.createConnection(device, dev, side, face.getOpposite(), ConnectionType.OPEN_CORNER);
        }
        loc = new Vec3i(device).add(side);
        dev = this.provider.getConnectableAt(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ(), face, side.getOpposite());
        if (dev == null && (dev = this.provider.getConnectableAt(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ(), side.getOpposite(), side.getOpposite())) == null && face == ForgeDirection.UNKNOWN && this.provider.isNormalFace(device, side)) {
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                if (d != side && d != side.getOpposite() && (dev = this.provider.getConnectableAt(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ(), d, side.getOpposite())) != null) break;
            }
        }
        if (dev != null && dev != device && this.provider.isValidStraight(dev) && this.provider.canConnect(device, dev, side, ConnectionType.STRAIGHT) && this.provider.canConnect(dev, device, side.getOpposite(), ConnectionType.STRAIGHT)) {
            return this.provider.createConnection(device, dev, side, side.getOpposite(), ConnectionType.STRAIGHT);
        }
        return null;
    }

    public static interface IConnectableProvider<T extends IWorldLocation, C> {
        public T getConnectableAt(World var1, int var2, int var3, int var4, ForgeDirection var5, ForgeDirection var6);

        public C createConnection(T var1, T var2, ForgeDirection var3, ForgeDirection var4, ConnectionType var5);

        public boolean canConnect(T var1, T var2, ForgeDirection var3, ConnectionType var4);

        public boolean isValidClosedCorner(T var1);

        public boolean isValidOpenCorner(T var1);

        public boolean isValidStraight(T var1);

        public boolean isNormalFace(T var1, ForgeDirection var2);
    }
}

