/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.wire;

import com.bluepowermod.part.BPPartFace;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.transform.Rotation;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public abstract class PartWireFace
extends BPPartFace {
    protected abstract boolean shouldRenderConnection(ForgeDirection var1);

    protected abstract double getWidth();

    protected abstract double getHeight();

    protected int getColorMultiplier() {
        return 0xFFFFFF;
    }

    protected boolean extendsToCorner(ForgeDirection side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract IIcon getWireIcon(ForgeDirection var1);

    @SideOnly(value=Side.CLIENT)
    protected IIcon getWireIcon(ForgeDirection side, ForgeDirection face) {
        return this.getWireIcon(face);
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon[] getIcons(ForgeDirection side) {
        return new IIcon[]{this.getWireIcon(side, ForgeDirection.DOWN), this.getWireIcon(side, ForgeDirection.UP), this.getWireIcon(side, ForgeDirection.WEST), this.getWireIcon(side, ForgeDirection.EAST), this.getWireIcon(side, ForgeDirection.NORTH), this.getWireIcon(side, ForgeDirection.SOUTH)};
    }

    protected boolean shouldIgnoreLighting() {
        return false;
    }

    protected int getBrightness() {
        return 0xF000F0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vec3i translation, RenderHelper renderer, RenderBlocks renderBlocks, int pass) {
        renderer.setIgnoreLighting(this.shouldIgnoreLighting());
        renderer.setLightingOverride(this.getBrightness());
        double height = this.getHeight() / 16.0 - 0.001;
        double width = this.getWidth() / 32.0;
        int color = this.getColorMultiplier();
        ForgeDirection d1 = ForgeDirection.NORTH;
        ForgeDirection d2 = ForgeDirection.SOUTH;
        ForgeDirection d3 = ForgeDirection.WEST;
        ForgeDirection d4 = ForgeDirection.EAST;
        if (this.getFace() == ForgeDirection.NORTH) {
            d1 = ForgeDirection.UP;
            d2 = ForgeDirection.DOWN;
        } else if (this.getFace() == ForgeDirection.SOUTH) {
            d1 = ForgeDirection.DOWN;
            d2 = ForgeDirection.UP;
        } else if (this.getFace() == ForgeDirection.WEST) {
            d3 = ForgeDirection.UP;
            d4 = ForgeDirection.DOWN;
        } else if (this.getFace() == ForgeDirection.EAST) {
            d3 = ForgeDirection.DOWN;
            d4 = ForgeDirection.UP;
        } else if (this.getFace() == ForgeDirection.UP) {
            d3 = ForgeDirection.EAST;
            d4 = ForgeDirection.WEST;
        }
        switch (this.getFace()) {
            case DOWN: {
                break;
            }
            case UP: {
                renderer.addTransformation((Transformation)new Rotation(180.0, 180.0, 0.0, Vec3d.center));
                break;
            }
            case NORTH: {
                renderer.addTransformation((Transformation)new Rotation(90.0, 90.0, 0.0, Vec3d.center));
                d1 = d1.getRotation(this.getFace());
                d2 = d2.getRotation(this.getFace());
                d3 = d3.getRotation(this.getFace());
                d4 = d4.getRotation(this.getFace());
                break;
            }
            case SOUTH: {
                renderer.addTransformation((Transformation)new Rotation(-90.0, 90.0, 0.0, Vec3d.center));
                d1 = d1.getRotation(this.getFace());
                d2 = d2.getRotation(this.getFace());
                d3 = d3.getRotation(this.getFace());
                d4 = d4.getRotation(this.getFace());
                break;
            }
            case WEST: {
                renderer.addTransformation((Transformation)new Rotation(0.0, 0.0, -90.0, Vec3d.center));
                break;
            }
            case EAST: {
                renderer.addTransformation((Transformation)new Rotation(0.0, 0.0, 90.0, Vec3d.center));
                break;
            }
        }
        boolean s1 = this.shouldRenderConnection(d1);
        boolean s2 = this.shouldRenderConnection(d2);
        boolean s3 = this.shouldRenderConnection(d3);
        boolean s4 = this.shouldRenderConnection(d4);
        renderer.setColor(color);
        renderer.renderBox(new Vec3dCube(0.5 - width, 0.0, 0.5 - width, 0.5 + width, height, 0.5 + width), this.getIcons(ForgeDirection.UNKNOWN));
        if (s4 || s3) {
            if (s3 || !s3 && s4 && !s1 && !s2) {
                renderer.renderBox(new Vec3dCube(s3 ? (this.extendsToCorner(d3) ? -height : 0.0) : 0.25, 0.0, 0.5 - width, 0.5 - width, height, 0.5 + width), this.getIcons(ForgeDirection.WEST));
            }
            if (s4 || s3 && !s4 && !s1 && !s2) {
                renderer.renderBox(new Vec3dCube(0.5 + width, 0.0, 0.5 - width, s4 ? 1.0 + (this.extendsToCorner(d4) ? height : 0.0) : 0.75, height, 0.5 + width), this.getIcons(ForgeDirection.EAST));
            }
            if (s1) {
                renderer.renderBox(new Vec3dCube(0.5 - width, 0.0, s1 ? (this.extendsToCorner(d1) ? -height : 0.0) : 0.25, 0.5 + width, height, 0.5 - width), this.getIcons(ForgeDirection.NORTH));
            }
            if (s2) {
                renderer.renderBox(new Vec3dCube(0.5 - width, 0.0, 0.5 + width, 0.5 + width, height, s2 ? 1.0 + (this.extendsToCorner(d2) ? height : 0.0) : 0.75), this.getIcons(ForgeDirection.SOUTH));
            }
        } else {
            renderer.renderBox(new Vec3dCube(0.5 - width, 0.0, s1 ? (this.extendsToCorner(d1) ? -height : 0.0) : 0.25, 0.5 + width, height, 0.5 - width), this.getIcons(ForgeDirection.NORTH));
            renderer.renderBox(new Vec3dCube(0.5 - width, 0.0, 0.5 + width, 0.5 + width, height, s2 ? 1.0 + (this.extendsToCorner(d2) ? height : 0.0) : 0.75), this.getIcons(ForgeDirection.SOUTH));
        }
        renderer.setIgnoreLighting(false);
        renderer.setColor(0xFFFFFF);
        return true;
    }
}

