/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.wire.redstone;

import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnection;
import com.bluepowermod.api.connect.IConnectionCache;
import com.bluepowermod.api.connect.IConnectionListener;
import com.bluepowermod.api.gate.IIntegratedCircuitPart;
import com.bluepowermod.api.misc.IFace;
import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IBundledConductor;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IInsulatedRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedConductor;
import com.bluepowermod.api.wire.redstone.IRedstoneConductor;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedwire;
import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.client.render.IconSupplier;
import com.bluepowermod.helper.VectorHelper;
import com.bluepowermod.init.BPCreativeTabs;
import com.bluepowermod.part.gate.ic.FakeMultipartTileIC;
import com.bluepowermod.part.wire.PartWireFace;
import com.bluepowermod.part.wire.redstone.WireHelper;
import com.bluepowermod.redstone.BundledConnectionCache;
import com.bluepowermod.redstone.BundledDeviceWrapper;
import com.bluepowermod.redstone.DummyRedstoneDevice;
import com.bluepowermod.redstone.RedstoneApi;
import com.bluepowermod.redstone.RedstoneConnection;
import com.bluepowermod.redstone.RedstoneConnectionCache;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.helper.MathHelper;
import uk.co.qmunity.lib.helper.RedstoneHelper;
import uk.co.qmunity.lib.misc.Pair;
import uk.co.qmunity.lib.part.IPartRedstone;
import uk.co.qmunity.lib.part.IPartTicking;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.MicroblockShape;
import uk.co.qmunity.lib.part.compat.OcclusionHelper;
import uk.co.qmunity.lib.vec.IWorldLocation;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public abstract class PartRedwireFace
extends PartWireFace
implements IRedwire,
IRedConductor,
IIntegratedCircuitPart,
IPartRedstone {
    private RedwireType type;
    private int width;
    private int height;
    private boolean[] connections = new boolean[6];
    protected boolean[] cornerConnect = new boolean[6];
    protected boolean[] cornerRender = new boolean[6];

    public PartRedwireFace(int width, int height, RedwireType type) {
        this.width = width;
        this.height = height;
        this.type = type;
    }

    @Override
    public RedwireType getRedwireType(ForgeDirection side) {
        return this.type;
    }

    @Override
    public String getUnlocalizedName() {
        return this.getType();
    }

    @Override
    protected boolean shouldRenderConnection(ForgeDirection side) {
        if (this.getParent() == null || this.getWorld() == null) {
            return this.isConnected(side);
        }
        return this.connections[side.ordinal()];
    }

    protected abstract boolean isConnected(ForgeDirection var1);

    @Override
    protected double getWidth() {
        return this.width;
    }

    @Override
    protected double getHeight() {
        return this.height;
    }

    @Override
    protected boolean extendsToCorner(ForgeDirection side) {
        return this.cornerRender[side.ordinal()];
    }

    @Override
    public List<Vec3dCube> getSelectionBoxes() {
        ArrayList<Vec3dCube> boxes = new ArrayList<Vec3dCube>();
        boxes.add(new Vec3dCube(0.0, 0.0, 0.0, 1.0, this.getHeight() / 16.0, 1.0).expand(-1.0E-6));
        VectorHelper.rotateBoxes(boxes, this.getFace(), 0);
        return boxes;
    }

    @Override
    public List<Vec3dCube> getOcclusionBoxes() {
        ArrayList<Vec3dCube> boxes = new ArrayList<Vec3dCube>();
        double h = this.getHeight() / 16.0;
        double d = 0.25;
        boxes.add(new Vec3dCube(d, 0.0, d, 1.0 - d, h, 1.0 - d));
        VectorHelper.rotateBoxes(boxes, this.getFace(), 0);
        return boxes;
    }

    @Override
    public boolean hasLoss(ForgeDirection side) {
        return this.getRedwireType(ForgeDirection.UNKNOWN).hasLoss();
    }

    @Override
    public boolean isAnalogue(ForgeDirection side) {
        return this.getRedwireType(ForgeDirection.UNKNOWN).isAnalogue();
    }

    @Override
    public void writeUpdateData(DataOutput buffer) throws IOException {
        super.writeUpdateData(buffer);
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            buffer.writeBoolean(this.isConnected(d));
        }
    }

    @Override
    public void readUpdateData(DataInput buffer) throws IOException {
        super.readUpdateData(buffer);
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            this.connections[d.ordinal()] = buffer.readBoolean();
        }
        for (int i = 0; i < 6; ++i) {
            this.cornerConnect[i] = buffer.readBoolean();
            this.cornerRender[i] = buffer.readBoolean();
        }
    }

    @Override
    public boolean canPlaceOnIntegratedCircuit() {
        return true;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return BPCreativeTabs.wiring;
    }

    public static class PartRedwireFaceBundled
    extends PartRedwireFace
    implements IBundledConductor.IAdvancedBundledConductor,
    IConnectionListener {
        private BundledConnectionCache bundledConnections = RedstoneApi.getInstance().createBundledConnectionCache(this);
        private byte[] power = new byte[16];
        private MinecraftColor color;

        public PartRedwireFaceBundled(RedwireType type, MinecraftColor color) {
            super(6, 4, type);
            this.color = color;
            this.bundledConnections.listen();
        }

        public String getType() {
            return "wire." + this.getRedwireType(ForgeDirection.UNKNOWN).getName() + ".bundled" + (this.color != MinecraftColor.NONE ? "." + this.color.name().toLowerCase() : "");
        }

        @Override
        protected boolean isConnected(ForgeDirection side) {
            if (this.getParent() == null || this.getWorld() == null) {
                return true;
            }
            return this.bundledConnections.getConnectionOnSide(side) != null;
        }

        @Override
        protected IIcon getWireIcon(ForgeDirection side) {
            return null;
        }

        @Override
        protected IIcon getWireIcon(ForgeDirection side, ForgeDirection face) {
            if (face == ForgeDirection.UP || face == ForgeDirection.DOWN) {
                if (side == ForgeDirection.UNKNOWN) {
                    ForgeDirection d1 = ForgeDirection.NORTH;
                    ForgeDirection d2 = ForgeDirection.SOUTH;
                    ForgeDirection d3 = ForgeDirection.WEST;
                    ForgeDirection d4 = ForgeDirection.EAST;
                    if (this.getFace() == ForgeDirection.NORTH) {
                        d1 = ForgeDirection.UP;
                        d2 = ForgeDirection.DOWN;
                    } else if (this.getFace() == ForgeDirection.SOUTH) {
                        d1 = ForgeDirection.DOWN;
                        d2 = ForgeDirection.UP;
                    } else if (this.getFace() == ForgeDirection.WEST) {
                        d3 = ForgeDirection.UP;
                        d4 = ForgeDirection.DOWN;
                    } else if (this.getFace() == ForgeDirection.EAST) {
                        d3 = ForgeDirection.DOWN;
                        d4 = ForgeDirection.UP;
                    } else if (this.getFace() == ForgeDirection.UP) {
                        d3 = ForgeDirection.EAST;
                        d4 = ForgeDirection.WEST;
                    }
                    if (this.getFace() == ForgeDirection.NORTH || this.getFace() == ForgeDirection.SOUTH) {
                        d1 = d1.getRotation(this.getFace());
                        d2 = d2.getRotation(this.getFace());
                        d3 = d3.getRotation(this.getFace());
                        d4 = d4.getRotation(this.getFace());
                    }
                    boolean s1 = this.shouldRenderConnection(d1);
                    boolean s2 = this.shouldRenderConnection(d2);
                    boolean s3 = this.shouldRenderConnection(d3);
                    boolean s4 = this.shouldRenderConnection(d4);
                    if ((s1 || s2) && !s3 && !s4) {
                        return IconSupplier.wireBundledStraight1;
                    }
                    if (!s1 && !s2 && (s3 || s4)) {
                        return IconSupplier.wireBundledStraight2;
                    }
                }
                return IconSupplier.wireBundledCross;
            }
            if (side == face) {
                return IconSupplier.wireBundledConnection;
            }
            if (face == ForgeDirection.UP || face == ForgeDirection.WEST || face == ForgeDirection.NORTH) {
                return IconSupplier.wireBundledSide1;
            }
            return IconSupplier.wireBundledSide2;
        }

        @Override
        protected int getColorMultiplier() {
            return 0xFFFFFF;
        }

        @Override
        public boolean canConnect(ForgeDirection side, IBundledDevice device, ConnectionType type) {
            if (type == ConnectionType.CLOSED_CORNER) {
                if (side == this.getFace()) {
                    return false;
                }
                if (side == this.getFace().getOpposite()) {
                    return false;
                }
                if (side == ForgeDirection.UNKNOWN) {
                    return false;
                }
            }
            if (device instanceof IRedwire) {
                RedwireType rwt = this.getRedwireType(side);
                if (type == null) {
                    return false;
                }
                RedwireType rwt_ = ((IRedwire)((Object)device)).getRedwireType(type == ConnectionType.STRAIGHT ? side.getOpposite() : (type == ConnectionType.CLOSED_CORNER ? this.getFace() : this.getFace().getOpposite()));
                if (rwt_ == null) {
                    return false;
                }
                if (!rwt.canConnectTo(rwt_)) {
                    return false;
                }
            }
            if (!this.color.canConnect(device.getBundledColor(type == ConnectionType.STRAIGHT ? side.getOpposite() : (type == ConnectionType.CLOSED_CORNER ? this.getFace() : this.getFace().getOpposite())))) {
                return false;
            }
            return OcclusionHelper.microblockOcclusionTest((ITilePartHolder)this.getParent(), (MicroblockShape)MicroblockShape.EDGE, (int)2, (ForgeDirection[])new ForgeDirection[]{this.getFace(), side});
        }

        @Override
        public IConnectionCache<? extends IBundledDevice> getBundledConnectionCache() {
            return this.bundledConnections;
        }

        @Override
        public void onConnect(IConnection<?> connection) {
            this.sendUpdatePacket();
        }

        @Override
        public void onDisconnect(IConnection<?> connection) {
            this.sendUpdatePacket();
        }

        @Override
        public byte[] getBundledOutput(ForgeDirection side) {
            if (!RedstoneApi.getInstance().shouldWiresOutputPower(this.hasLoss(side))) {
                return new byte[16];
            }
            return this.getBundledPower(side);
        }

        @Override
        public void setBundledPower(ForgeDirection side, byte[] power) {
            this.power = power;
        }

        @Override
        public byte[] getBundledPower(ForgeDirection side) {
            return this.power;
        }

        @Override
        public void onBundledUpdate() {
        }

        @Override
        public boolean canPropagateBundledFrom(ForgeDirection fromSide) {
            return true;
        }

        @Override
        public Collection<Map.Entry<IConnection<IBundledDevice>, Boolean>> propagateBundled(ForgeDirection fromSide) {
            ArrayList<Map.Entry<IConnection<IBundledDevice>, Boolean>> l = new ArrayList<Map.Entry<IConnection<IBundledDevice>, Boolean>>();
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                IConnection<IBundledDevice> c = this.bundledConnections.getConnectionOnSide(d);
                if (c == null) continue;
                l.add((Map.Entry<IConnection<IBundledDevice>, Boolean>)new Pair(c, (Object)(c.getB() instanceof IRedwire && ((IRedwire)((Object)c.getB())).getRedwireType(c.getSideB()) != this.getRedwireType(c.getSideA()) ? 1 : 0)));
            }
            return l;
        }

        @Override
        public MinecraftColor getBundledColor(ForgeDirection side) {
            return this.color;
        }

        @Override
        public void onUpdate() {
            if (!RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
                return;
            }
            super.onUpdate();
            if (this.getWorld().field_72995_K) {
                return;
            }
            this.bundledConnections.recalculateConnections();
            RedstoneApi.getInstance().getBundledPropagator(this, this.getFace()).propagate();
        }

        @Override
        public void onRemoved() {
            if (!RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
                return;
            }
            super.onRemoved();
            if (this.getWorld().field_72995_K) {
                return;
            }
            boolean should = RedstoneApi.getInstance().shouldWiresHandleUpdates();
            RedstoneApi.getInstance().setWiresHandleUpdates(false);
            this.bundledConnections.disconnectAll();
            RedstoneApi.getInstance().setWiresHandleUpdates(should);
        }

        @Override
        public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
            double scale = 1.25;
            double translation = 0.25;
            double droppedTranslation = 0.0;
            RenderHelper rh = RenderHelper.instance;
            rh.setRenderCoords(null, 0, 0, 0);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glPushMatrix();
            if (type == IItemRenderer.ItemRenderType.ENTITY) {
                GL11.glTranslated((double)droppedTranslation, (double)0.0, (double)droppedTranslation);
            }
            GL11.glTranslated((double)0.0, (double)translation, (double)0.0);
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            Tessellator.field_78398_a.func_78382_b();
            this.renderStatic(new Vec3i(0, 0, 0), rh, RenderBlocks.getInstance(), 0);
            Tessellator.field_78398_a.func_78381_a();
            GL11.glPopMatrix();
            rh.reset();
        }

        @Override
        public boolean renderStatic(Vec3i translation, RenderHelper renderer, RenderBlocks renderBlocks, int pass) {
            super.renderStatic(translation, renderer, renderBlocks, pass);
            ForgeDirection d1 = ForgeDirection.NORTH;
            ForgeDirection d2 = ForgeDirection.SOUTH;
            ForgeDirection d3 = ForgeDirection.WEST;
            ForgeDirection d4 = ForgeDirection.EAST;
            if (this.getFace() == ForgeDirection.NORTH) {
                d1 = ForgeDirection.UP;
                d2 = ForgeDirection.DOWN;
            } else if (this.getFace() == ForgeDirection.SOUTH) {
                d1 = ForgeDirection.DOWN;
                d2 = ForgeDirection.UP;
            } else if (this.getFace() == ForgeDirection.WEST) {
                d3 = ForgeDirection.UP;
                d4 = ForgeDirection.DOWN;
            } else if (this.getFace() == ForgeDirection.EAST) {
                d3 = ForgeDirection.DOWN;
                d4 = ForgeDirection.UP;
            } else if (this.getFace() == ForgeDirection.UP) {
                d3 = ForgeDirection.EAST;
                d4 = ForgeDirection.WEST;
            }
            if (this.getFace() == ForgeDirection.NORTH || this.getFace() == ForgeDirection.SOUTH) {
                d1 = d1.getRotation(this.getFace());
                d2 = d2.getRotation(this.getFace());
                d3 = d3.getRotation(this.getFace());
                d4 = d4.getRotation(this.getFace());
            }
            boolean s1 = this.shouldRenderConnection(d1);
            boolean s2 = this.shouldRenderConnection(d2);
            boolean s3 = this.shouldRenderConnection(d3);
            boolean s4 = this.shouldRenderConnection(d4);
            double size = 0.015625;
            double width = 0.020833333333333332;
            double y = 0.0;
            double height = this.getHeight() / 16.0;
            renderer.setColor(WireHelper.getColorForPowerLevel(this.getRedwireType(ForgeDirection.UNKNOWN), (byte)127));
            if (s1 && s3 || s3 && s2 || s2 && s4 || s4 && s1) {
                renderer.renderBox(new Vec3dCube(0.5 - width - size, height, 0.5 - width - size, 0.5 + width + size, height + size, 0.5 + width + size), IconSupplier.wire);
            } else {
                renderer.renderBox(new Vec3dCube(0.5 - width, height, 0.5 - width, 0.5 + width, height + size, 0.5 + width), IconSupplier.wire);
            }
            if (s4 || s3) {
                if (s3 || !s1 && !s2) {
                    renderer.renderBox(new Vec3dCube(s3 ? (this.cornerConnect[d3.ordinal()] ? -height - size : -size) : 0.3125, y, 0.5 - width, 0.5 - width, height + size, 0.5 + width), IconSupplier.wire);
                }
                if (s4 || !s1 && !s2) {
                    renderer.renderBox(new Vec3dCube(0.5 + width, y, 0.5 - width, s4 ? (this.cornerConnect[d4.ordinal()] ? 1.0 + height + size : 1.0 + size) : 0.6875, height + size, 0.5 + width), IconSupplier.wire);
                }
                if (s1) {
                    renderer.renderBox(new Vec3dCube(0.5 - width, y, s1 ? (this.cornerConnect[d1.ordinal()] ? -height - size : -size) : 0.25, 0.5 + width, height + size, 0.5 - width), IconSupplier.wire);
                }
                if (s2) {
                    renderer.renderBox(new Vec3dCube(0.5 - width, y, 0.5 + width, 0.5 + width, height + size, s2 ? (this.cornerConnect[d2.ordinal()] ? 1.0 + height + size : 1.0 + size) : 0.75), IconSupplier.wire);
                }
            } else {
                renderer.renderBox(new Vec3dCube(0.5 - width, y, s1 ? (this.cornerConnect[d1.ordinal()] ? -height - size : -size) : 0.3125, 0.5 + width, height + size, 0.5 - width), IconSupplier.wire);
                renderer.renderBox(new Vec3dCube(0.5 - width, y, 0.5 + width, 0.5 + width, height + size, s2 ? (this.cornerConnect[d2.ordinal()] ? 1.0 + height + size : 1.0 + size) : 0.6875), IconSupplier.wire);
            }
            return true;
        }

        @Override
        public void writeUpdateData(DataOutput buffer) throws IOException {
            super.writeUpdateData(buffer);
            for (int i = 0; i < 6; ++i) {
                IBundledDevice dev;
                boolean connected = false;
                boolean render = false;
                IConnection<? extends IBundledDevice> bc = this.getBundledConnectionCache().getConnectionOnSide(ForgeDirection.getOrientation((int)i));
                if (bc != null && (dev = bc.getB()) instanceof IFace && ((IFace)((Object)dev)).getFace() == ForgeDirection.getOrientation((int)i).getOpposite()) {
                    if (dev instanceof IRedwire) {
                        if (dev instanceof IFace && this.getFace().ordinal() > ((IFace)((Object)dev)).getFace().ordinal()) {
                            if (!(dev instanceof IInsulatedRedstoneDevice) && dev instanceof IRedwire) {
                                render = true;
                                connected = true;
                            }
                        } else if (dev instanceof PartRedwireFaceBundled) {
                            connected = true;
                        }
                    } else {
                        connected = true;
                        render = true;
                    }
                }
                buffer.writeBoolean(connected);
                buffer.writeBoolean(render);
            }
        }

        @Override
        public void readUpdateData(DataInput buffer) throws IOException {
            super.readUpdateData(buffer);
            if (this.getParent() != null && this.getWorld() != null) {
                this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
            }
        }

        public boolean canConnectRedstone(ForgeDirection side) {
            return false;
        }

        public int getWeakPower(ForgeDirection side) {
            return 0;
        }

        public int getStrongPower(ForgeDirection side) {
            return 0;
        }

        @Override
        public boolean isNormalFace(ForgeDirection side) {
            return false;
        }
    }

    public static class PartRedwireFaceInsulated
    extends PartRedwireFace
    implements IRedstoneConductor.IAdvancedRedstoneConductor,
    IInsulatedRedstoneDevice,
    IBundledConductor.IAdvancedBundledConductor,
    IConnectionListener,
    IRedwire.IInsulatedRedwire,
    IPartTicking {
        private RedstoneConnectionCache connections = RedstoneApi.getInstance().createRedstoneConnectionCache(this);
        private BundledConnectionCache bundledConnections = RedstoneApi.getInstance().createBundledConnectionCache(this);
        private boolean hasUpdated = false;
        private byte power = 0;
        private MinecraftColor color;
        private boolean scheduled = false;

        public PartRedwireFaceInsulated(RedwireType type, MinecraftColor color) {
            super(4, 3, type);
            this.color = color;
            this.connections.listen();
            this.bundledConnections.listen();
        }

        public String getType() {
            return "wire." + this.getRedwireType(ForgeDirection.UNKNOWN).getName() + "." + this.color.name().toLowerCase();
        }

        @Override
        protected boolean isConnected(ForgeDirection side) {
            if (this.getParent() == null || this.getWorld() == null) {
                return true;
            }
            return this.connections.getConnectionOnSide(side) != null || this.bundledConnections.getConnectionOnSide(side) != null;
        }

        @Override
        protected IIcon getWireIcon(ForgeDirection side) {
            return side == ForgeDirection.UP || side == ForgeDirection.DOWN ? IconSupplier.wireInsulation1 : IconSupplier.wireInsulation2;
        }

        @Override
        protected int getColorMultiplier() {
            return this.color.getHex();
        }

        @Override
        public boolean canConnect(ForgeDirection side, IRedstoneDevice device, ConnectionType type) {
            MinecraftColor c;
            if (type == ConnectionType.STRAIGHT && side == this.getFace().getOpposite() || side == ForgeDirection.UNKNOWN) {
                return false;
            }
            if (type == ConnectionType.CLOSED_CORNER) {
                if (side == this.getFace()) {
                    return false;
                }
                if (side == this.getFace().getOpposite()) {
                    return false;
                }
                if (side == ForgeDirection.UNKNOWN) {
                    return false;
                }
            }
            if (device instanceof IInsulatedRedstoneDevice && (c = ((IInsulatedRedstoneDevice)device).getInsulationColor(type == ConnectionType.STRAIGHT ? side.getOpposite() : (type == ConnectionType.CLOSED_CORNER ? this.getFace() : this.getFace().getOpposite()))) != null && c != this.getInsulationColor(side)) {
                return false;
            }
            if (device instanceof IRedwire) {
                RedwireType rwt = this.getRedwireType(side);
                if (type == null) {
                    return false;
                }
                RedwireType rwt_ = ((IRedwire)((Object)device)).getRedwireType(type == ConnectionType.STRAIGHT ? side.getOpposite() : (type == ConnectionType.CLOSED_CORNER ? this.getFace() : this.getFace().getOpposite()));
                if (rwt_ == null) {
                    return false;
                }
                if (!rwt.canConnectTo(rwt_)) {
                    return false;
                }
            }
            return OcclusionHelper.microblockOcclusionTest((ITilePartHolder)this.getParent(), (MicroblockShape)MicroblockShape.EDGE, (int)2, (ForgeDirection[])new ForgeDirection[]{this.getFace(), side});
        }

        @Override
        public boolean canConnect(ForgeDirection side, IBundledDevice device, ConnectionType type) {
            if (device instanceof IInsulatedRedstoneDevice) {
                return false;
            }
            if (device instanceof IRedwire) {
                RedwireType rwt = this.getRedwireType(side);
                if (type == null) {
                    return false;
                }
                RedwireType rwt_ = ((IRedwire)((Object)device)).getRedwireType(type == ConnectionType.STRAIGHT ? side.getOpposite() : (type == ConnectionType.CLOSED_CORNER ? this.getFace() : this.getFace().getOpposite()));
                if (rwt_ == null) {
                    return false;
                }
                if (!rwt.canConnectTo(rwt_)) {
                    return false;
                }
            }
            return OcclusionHelper.microblockOcclusionTest((ITilePartHolder)this.getParent(), (MicroblockShape)MicroblockShape.EDGE, (int)2, (ForgeDirection[])new ForgeDirection[]{this.getFace(), side});
        }

        public RedstoneConnectionCache getRedstoneConnectionCache() {
            return this.connections;
        }

        @Override
        public IConnectionCache<? extends IBundledDevice> getBundledConnectionCache() {
            return this.bundledConnections;
        }

        @Override
        public void onConnect(IConnection<?> connection) {
            this.sendUpdatePacket();
        }

        @Override
        public void onDisconnect(IConnection<?> connection) {
            this.scheduled = true;
            this.sendUpdatePacket();
        }

        @Override
        public byte getRedstonePower(ForgeDirection side) {
            if (!RedstoneApi.getInstance().shouldWiresOutputPower(this.hasLoss(side))) {
                return 0;
            }
            if (!this.isAnalogue(side)) {
                return (byte)((this.power & 0xFF) > 0 ? 255 : 0);
            }
            return this.power;
        }

        @Override
        public void setRedstonePower(ForgeDirection side, byte power) {
            byte pow = this.isAnalogue(side) ? power : ((power & 0xFF) > 0 ? (byte)-1 : 0);
            this.hasUpdated |= pow != this.power;
            this.power = pow;
        }

        @Override
        public byte[] getBundledOutput(ForgeDirection side) {
            if (!RedstoneApi.getInstance().shouldWiresOutputPower(this.hasLoss(side))) {
                return new byte[16];
            }
            return this.getBundledPower(side);
        }

        @Override
        public void setBundledPower(ForgeDirection side, byte[] power) {
            this.power = power[this.getInsulationColor(side).ordinal()];
            this.hasUpdated = true;
        }

        @Override
        public byte[] getBundledPower(ForgeDirection side) {
            byte[] val = new byte[16];
            val[this.color.ordinal()] = this.power;
            return val;
        }

        @Override
        public void onRedstoneUpdate() {
            if (this.getParent() == null || this.getWorld() == null) {
                return;
            }
            if (this.hasUpdated) {
                this.sendUpdatePacket();
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    IConnection<IRedstoneDevice> c = this.connections.getConnectionOnSide(dir);
                    if (c == null) continue;
                    IRedstoneDevice dev = c.getB();
                    if (dir == this.getFace()) {
                        RedstoneHelper.notifyRedstoneUpdate((World)this.getWorld(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), (ForgeDirection)dir, (boolean)true);
                        continue;
                    }
                    if (dev != null && !(dev instanceof DummyRedstoneDevice) || dir == this.getFace().getOpposite()) continue;
                    RedstoneHelper.notifyRedstoneUpdate((World)this.getWorld(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), (ForgeDirection)dir, (boolean)false);
                }
                this.hasUpdated = false;
            }
        }

        @Override
        public void onBundledUpdate() {
            this.onRedstoneUpdate();
        }

        @Override
        public boolean canPropagateFrom(ForgeDirection fromSide) {
            return true;
        }

        @Override
        public boolean canPropagateBundledFrom(ForgeDirection fromSide) {
            return true;
        }

        public List<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> propagate(ForgeDirection fromSide) {
            ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> l = new ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>>();
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                IConnection<IBundledDevice> cB;
                IConnection<IRedstoneDevice> c = this.connections.getConnectionOnSide(d);
                if (c != null) {
                    l.add((Map.Entry<IConnection<IRedstoneDevice>, Boolean>)new Pair(c, (Object)(c.getB() instanceof IRedwire && ((IRedwire)((Object)c.getB())).getRedwireType(c.getSideB()) != this.getRedwireType(c.getSideA()) ? 1 : 0)));
                }
                if ((cB = this.bundledConnections.getConnectionOnSide(d)) == null) continue;
                l.add((Map.Entry<IConnection<IRedstoneDevice>, Boolean>)new Pair((Object)new RedstoneConnection(this, BundledDeviceWrapper.wrap(cB.getB(), this.color), cB.getSideA(), cB.getSideB(), cB.getType()), (Object)(cB.getB() instanceof IRedwire && ((IRedwire)((Object)cB.getB())).getRedwireType(cB.getSideB()) != this.getRedwireType(cB.getSideA()) ? 1 : 0)));
            }
            return l;
        }

        @Override
        public Collection<Map.Entry<IConnection<IBundledDevice>, Boolean>> propagateBundled(ForgeDirection fromSide) {
            ArrayList<Map.Entry<IConnection<IBundledDevice>, Boolean>> l = new ArrayList<Map.Entry<IConnection<IBundledDevice>, Boolean>>();
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                IConnection<IBundledDevice> c = this.bundledConnections.getConnectionOnSide(d);
                if (c == null) continue;
                l.add((Map.Entry<IConnection<IBundledDevice>, Boolean>)new Pair(c, (Object)(c.getB() instanceof IRedwire && ((IRedwire)((Object)c.getB())).getRedwireType(c.getSideB()) != this.getRedwireType(c.getSideA()) ? 1 : 0)));
            }
            return l;
        }

        @Override
        public MinecraftColor getBundledColor(ForgeDirection side) {
            return MinecraftColor.NONE;
        }

        @Override
        public void onUpdate() {
            if (!RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
                return;
            }
            super.onUpdate();
            if (this.getWorld().field_72995_K) {
                return;
            }
            this.connections.recalculateConnections();
            this.bundledConnections.recalculateConnections();
            RedstoneApi.getInstance().getRedstonePropagator(this, this.getFace()).propagate();
            RedstoneApi.getInstance().getBundledPropagator(this, this.getFace()).propagate();
        }

        public void update() {
            if (this.scheduled) {
                this.onUpdate();
            }
            this.scheduled = false;
        }

        @Override
        public void onRemoved() {
            boolean should;
            if (!this.getWorld().field_72995_K) {
                this.power = 0;
                this.hasUpdated = true;
                should = RedstoneApi.getInstance().shouldWiresHandleUpdates();
                RedstoneApi.getInstance().setWiresHandleUpdates(false);
                this.onRedstoneUpdate();
                RedstoneApi.getInstance().setWiresHandleUpdates(should);
            }
            if (!RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
                return;
            }
            super.onRemoved();
            if (this.getWorld().field_72995_K) {
                return;
            }
            should = RedstoneApi.getInstance().shouldWiresHandleUpdates();
            RedstoneApi.getInstance().setWiresHandleUpdates(false);
            this.connections.disconnectAll();
            this.bundledConnections.disconnectAll();
            RedstoneApi.getInstance().setWiresHandleUpdates(should);
        }

        @Override
        public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
            this.power = (byte)-1;
            double scale = 1.25;
            double translation = 0.25;
            double droppedTranslation = 0.0;
            RenderHelper rh = RenderHelper.instance;
            rh.setRenderCoords(null, 0, 0, 0);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glPushMatrix();
            if (type == IItemRenderer.ItemRenderType.ENTITY) {
                GL11.glTranslated((double)droppedTranslation, (double)0.0, (double)droppedTranslation);
            }
            GL11.glTranslated((double)0.0, (double)translation, (double)0.0);
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            Tessellator.field_78398_a.func_78382_b();
            this.renderStatic(new Vec3i(0, 0, 0), rh, RenderBlocks.getInstance(), 0);
            Tessellator.field_78398_a.func_78381_a();
            GL11.glPopMatrix();
            rh.reset();
        }

        @Override
        public boolean renderStatic(Vec3i translation, RenderHelper renderer, RenderBlocks renderBlocks, int pass) {
            super.renderStatic(translation, renderer, renderBlocks, pass);
            ForgeDirection d1 = ForgeDirection.NORTH;
            ForgeDirection d2 = ForgeDirection.SOUTH;
            ForgeDirection d3 = ForgeDirection.WEST;
            ForgeDirection d4 = ForgeDirection.EAST;
            if (this.getFace() == ForgeDirection.NORTH) {
                d1 = ForgeDirection.UP;
                d2 = ForgeDirection.DOWN;
            } else if (this.getFace() == ForgeDirection.SOUTH) {
                d1 = ForgeDirection.DOWN;
                d2 = ForgeDirection.UP;
            } else if (this.getFace() == ForgeDirection.WEST) {
                d3 = ForgeDirection.UP;
                d4 = ForgeDirection.DOWN;
            } else if (this.getFace() == ForgeDirection.EAST) {
                d3 = ForgeDirection.DOWN;
                d4 = ForgeDirection.UP;
            } else if (this.getFace() == ForgeDirection.UP) {
                d3 = ForgeDirection.EAST;
                d4 = ForgeDirection.WEST;
            }
            if (this.getFace() == ForgeDirection.NORTH || this.getFace() == ForgeDirection.SOUTH) {
                d1 = d1.getRotation(this.getFace());
                d2 = d2.getRotation(this.getFace());
                d3 = d3.getRotation(this.getFace());
                d4 = d4.getRotation(this.getFace());
            }
            boolean s1 = this.shouldRenderConnection(d1);
            boolean s2 = this.shouldRenderConnection(d2);
            boolean s3 = this.shouldRenderConnection(d3);
            boolean s4 = this.shouldRenderConnection(d4);
            double size = 0.015625;
            double width = 0.03125;
            double y = 0.001;
            double height = this.getHeight() / 16.0;
            renderer.setColor(WireHelper.getColorForPowerLevel(this.getRedwireType(ForgeDirection.UNKNOWN), this.power));
            if (s1 && s3 || s3 && s2 || s2 && s4 || s4 && s1) {
                renderer.renderBox(new Vec3dCube(0.5 - width - size, y, 0.5 - width - size, 0.5 + width + size, height + size, 0.5 + width + size), IconSupplier.wire);
            } else {
                renderer.renderBox(new Vec3dCube(0.5 - width, y, 0.5 - width, 0.5 + width, height + size, 0.5 + width), IconSupplier.wire);
            }
            if (s4 || s3) {
                if (s3 || !s1 && !s2) {
                    renderer.renderBox(new Vec3dCube(s3 ? (this.cornerConnect[d3.ordinal()] ? -height - size : 0.001) : 0.3125, y, 0.5 - width, 0.5 - width, height + size, 0.5 + width), IconSupplier.wire);
                }
                if (s4 || !s1 && !s2) {
                    renderer.renderBox(new Vec3dCube(0.5 + width, y, 0.5 - width, s4 ? (this.cornerConnect[d4.ordinal()] ? 1.0 + height + size : 0.999) : 0.6875, height + size, 0.5 + width), IconSupplier.wire);
                }
                if (s1) {
                    renderer.renderBox(new Vec3dCube(0.5 - width, y, s1 ? (this.cornerConnect[d1.ordinal()] ? -height - size : 0.001) : 0.25, 0.5 + width, height + size, 0.5 - width), IconSupplier.wire);
                }
                if (s2) {
                    renderer.renderBox(new Vec3dCube(0.5 - width, y, 0.5 + width, 0.5 + width, height + size, s2 ? (this.cornerConnect[d2.ordinal()] ? 1.0 + height + size : 0.999) : 0.75), IconSupplier.wire);
                }
            } else {
                renderer.renderBox(new Vec3dCube(0.5 - width, y, s1 ? (this.cornerConnect[d1.ordinal()] ? -height - size : 0.001) : 0.3125, 0.5 + width, height + size, 0.5 - width), IconSupplier.wire);
                renderer.renderBox(new Vec3dCube(0.5 - width, y, 0.5 + width, 0.5 + width, height + size, s2 ? (this.cornerConnect[d2.ordinal()] ? 1.0 + height + size : 0.999) : 0.6875), IconSupplier.wire);
            }
            double len = 0.0625;
            width = 0.0625;
            if (s4 || s3) {
                if (s3 || !s1 && !s2) {
                    renderer.renderBox(new Vec3dCube(0.25 - len, 0.0, 0.5 - width, 0.25, 0.125, 0.5 + width), IconSupplier.wire);
                }
                if (s4 || !s1 && !s2) {
                    renderer.renderBox(new Vec3dCube(0.75, 0.0, 0.5 - width, 0.75 + len, 0.125, 0.5 + width), IconSupplier.wire);
                }
            } else {
                if (!s1) {
                    renderer.renderBox(new Vec3dCube(0.5 - width, 0.0, 0.25 - len, 0.5 + width, 0.125, 0.25), IconSupplier.wire);
                }
                if (!s2) {
                    renderer.renderBox(new Vec3dCube(0.5 - width, 0.0, 0.75, 0.5 + width, 0.125, 0.75 + len), IconSupplier.wire);
                }
            }
            return true;
        }

        @Override
        public void writeUpdateData(DataOutput buffer) throws IOException {
            super.writeUpdateData(buffer);
            for (int i = 0; i < 6; ++i) {
                IBundledDevice dev;
                IConnection<? extends IBundledDevice> bc;
                IRedstoneDevice dev2;
                boolean connected = false;
                boolean render = false;
                IConnection<IRedstoneDevice> c = this.getRedstoneConnectionCache().getConnectionOnSide(ForgeDirection.getOrientation((int)i));
                if (c != null && (dev2 = c.getB()) instanceof IFace && ((IFace)((Object)dev2)).getFace() == ForgeDirection.getOrientation((int)i).getOpposite()) {
                    if (dev2 instanceof IRedwire) {
                        if (dev2 instanceof IInsulatedRedstoneDevice && ((IInsulatedRedstoneDevice)dev2).getInsulationColor(c.getSideB()) != MinecraftColor.NONE) {
                            connected = true;
                        }
                        if (dev2 instanceof IFace && this.getFace().ordinal() > ((IFace)((Object)dev2)).getFace().ordinal()) {
                            if (dev2 instanceof IInsulatedRedstoneDevice && ((IInsulatedRedstoneDevice)dev2).getInsulationColor(c.getSideB()) == this.getInsulationColor(c.getSideA())) {
                                render = true;
                            }
                            if (this.getInsulationColor(c.getSideA()) == MinecraftColor.NONE) {
                                render = true;
                            }
                        }
                    } else {
                        connected = true;
                        render = true;
                    }
                }
                if ((bc = this.getBundledConnectionCache().getConnectionOnSide(ForgeDirection.getOrientation((int)i))) != null && (dev = bc.getB()) instanceof IFace && ((IFace)((Object)dev)).getFace() == ForgeDirection.getOrientation((int)i).getOpposite()) {
                    if (dev instanceof IRedwire) {
                        if (dev instanceof IInsulatedRedstoneDevice && ((IInsulatedRedstoneDevice)((Object)dev)).getInsulationColor(bc.getSideB()) != MinecraftColor.NONE) {
                            connected = true;
                        }
                        if (dev instanceof IFace && this.getFace().ordinal() > ((IFace)((Object)dev)).getFace().ordinal()) {
                            if (dev instanceof IInsulatedRedstoneDevice && ((IInsulatedRedstoneDevice)((Object)dev)).getInsulationColor(bc.getSideB()) == this.getInsulationColor(bc.getSideA())) {
                                render = true;
                            }
                            if (this.getInsulationColor(bc.getSideA()) == MinecraftColor.NONE) {
                                render = true;
                            }
                        }
                        if (!(dev instanceof IInsulatedRedstoneDevice)) {
                            render = true;
                            connected = true;
                        }
                    } else {
                        connected = true;
                        render = true;
                    }
                }
                buffer.writeBoolean(connected);
                buffer.writeBoolean(render);
            }
            buffer.writeByte(this.power);
        }

        @Override
        public void readUpdateData(DataInput buffer) throws IOException {
            super.readUpdateData(buffer);
            this.power = buffer.readByte();
            if (this.getParent() != null && this.getWorld() != null) {
                this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
            }
        }

        @Override
        public void addWAILABody(List<String> text) {
            super.addWAILABody(text);
            text.add("Power: " + (this.power & 0xFF));
        }

        @Override
        public MinecraftColor getInsulationColor(ForgeDirection side) {
            return this.color;
        }

        public boolean canConnectRedstone(ForgeDirection side) {
            return side != this.getFace().getOpposite();
        }

        public int getWeakPower(ForgeDirection side) {
            if (!RedstoneApi.getInstance().shouldWiresOutputPower(this.hasLoss(side))) {
                return 0;
            }
            if (new Vec3i((IWorldLocation)this).add(side).getBlock() instanceof BlockRedstoneWire) {
                return 0;
            }
            if (side == this.getFace() || side == this.getFace().getOpposite()) {
                return 0;
            }
            return MathHelper.map((int)(this.power & 0xFF), (int)0, (int)255, (int)0, (int)15);
        }

        public int getStrongPower(ForgeDirection side) {
            return 0;
        }

        @Override
        public boolean isNormalFace(ForgeDirection side) {
            return false;
        }
    }

    public static class PartRedwireFaceUninsulated
    extends PartRedwireFace
    implements IRedstoneConductor.IAdvancedRedstoneConductor,
    IConnectionListener,
    IPartTicking {
        private RedstoneConnectionCache connections = RedstoneApi.getInstance().createRedstoneConnectionCache(this);
        private boolean hasUpdated = false;
        private byte power = 0;
        private boolean scheduled = false;

        public PartRedwireFaceUninsulated(RedwireType type) {
            super(2, 2, type);
            this.connections.listen();
        }

        public String getType() {
            return "wire." + this.getRedwireType(ForgeDirection.UNKNOWN).getName();
        }

        @Override
        protected boolean isConnected(ForgeDirection side) {
            return this.connections.getConnectionOnSide(side) != null;
        }

        @Override
        protected IIcon getWireIcon(ForgeDirection side) {
            return IconSupplier.wire;
        }

        @Override
        protected int getColorMultiplier() {
            return WireHelper.getColorForPowerLevel(this.getRedwireType(ForgeDirection.UNKNOWN), this.power);
        }

        @Override
        public boolean canConnect(ForgeDirection side, IRedstoneDevice device, ConnectionType type) {
            if (type == ConnectionType.STRAIGHT && side == this.getFace().getOpposite() && device instanceof IFace || side == ForgeDirection.UNKNOWN) {
                return false;
            }
            if (type == ConnectionType.CLOSED_CORNER) {
                if (side == this.getFace()) {
                    return false;
                }
                if (side == this.getFace().getOpposite()) {
                    return false;
                }
                if (side == ForgeDirection.UNKNOWN) {
                    return false;
                }
            }
            if (device instanceof IRedwire) {
                RedwireType rwt = this.getRedwireType(side);
                if (type == null) {
                    return false;
                }
                RedwireType rwt_ = ((IRedwire)((Object)device)).getRedwireType(type == ConnectionType.STRAIGHT ? side.getOpposite() : (type == ConnectionType.CLOSED_CORNER ? this.getFace() : this.getFace().getOpposite()));
                if (rwt_ == null) {
                    return false;
                }
                if (!rwt.canConnectTo(rwt_)) {
                    return false;
                }
            }
            return OcclusionHelper.microblockOcclusionTest((ITilePartHolder)this.getParent(), (MicroblockShape)MicroblockShape.EDGE, (int)2, (ForgeDirection[])new ForgeDirection[]{this.getFace(), side});
        }

        public RedstoneConnectionCache getRedstoneConnectionCache() {
            return this.connections;
        }

        @Override
        public void onConnect(IConnection<?> connection) {
            this.sendUpdatePacket();
        }

        @Override
        public void onDisconnect(IConnection<?> connection) {
            this.scheduled = true;
            this.sendUpdatePacket();
        }

        @Override
        public byte getRedstonePower(ForgeDirection side) {
            if (!RedstoneApi.getInstance().shouldWiresOutputPower(this.hasLoss(side))) {
                return 0;
            }
            if (!this.isAnalogue(side)) {
                return (byte)((this.power & 0xFF) > 0 ? 255 : 0);
            }
            return this.power;
        }

        @Override
        public void setRedstonePower(ForgeDirection side, byte power) {
            byte pow = this.hasLoss(side) ? power : ((power & 0xFF) > 0 ? (byte)-1 : 0);
            this.hasUpdated |= pow != this.power;
            this.power = pow;
        }

        @Override
        public void onRedstoneUpdate() {
            if (this.getParent() instanceof FakeMultipartTileIC) {
                ((FakeMultipartTileIC)this.getParent()).getIC().loadWorld();
            }
            if (this.hasUpdated) {
                this.sendUpdatePacket();
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    IConnection<IRedstoneDevice> c = this.connections.getConnectionOnSide(dir);
                    IRedstoneDevice dev = null;
                    if (c != null) {
                        dev = c.getB();
                    }
                    if (dir == this.getFace()) {
                        RedstoneHelper.notifyRedstoneUpdate((World)this.getWorld(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), (ForgeDirection)dir, (boolean)true);
                        continue;
                    }
                    if (dev != null && !(dev instanceof DummyRedstoneDevice) || dir == this.getFace().getOpposite()) continue;
                    RedstoneHelper.notifyRedstoneUpdate((World)this.getWorld(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), (ForgeDirection)dir, (boolean)false);
                }
                this.hasUpdated = false;
            }
        }

        @Override
        public boolean canPropagateFrom(ForgeDirection fromSide) {
            return true;
        }

        public List<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> propagate(ForgeDirection fromSide) {
            if (this.getParent() instanceof FakeMultipartTileIC) {
                ((FakeMultipartTileIC)this.getParent()).getIC().loadWorld();
            }
            ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> l = new ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>>();
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                IConnection<IRedstoneDevice> c = this.connections.getConnectionOnSide(d);
                if (c == null) continue;
                l.add((Map.Entry<IConnection<IRedstoneDevice>, Boolean>)new Pair(c, (Object)(c.getB() instanceof IRedwire && ((IRedwire)((Object)c.getB())).getRedwireType(c.getSideB()) != this.getRedwireType(c.getSideA()) ? 1 : 0)));
            }
            return l;
        }

        @Override
        public void onUpdate() {
            if (!RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
                return;
            }
            super.onUpdate();
            if (this.getWorld().field_72995_K) {
                return;
            }
            this.connections.recalculateConnections();
            if (this.connections.getConnectionOnSide(this.getFace()) == null) {
                DummyRedstoneDevice drd = DummyRedstoneDevice.getDeviceAt(new Vec3i((IWorldLocation)this).add(this.getFace()));
                this.connections.onConnect(this.getFace(), drd, this.getFace().getOpposite(), ConnectionType.STRAIGHT);
                drd.getRedstoneConnectionCache().onConnect(this.getFace().getOpposite(), this, this.getFace(), ConnectionType.STRAIGHT);
            }
            RedstoneApi.getInstance().getRedstonePropagator(this, this.getFace()).propagate();
        }

        public void update() {
            if (this.scheduled) {
                this.onUpdate();
            }
            this.scheduled = false;
        }

        @Override
        public void onRemoved() {
            if (this.getWorld().field_72995_K) {
                return;
            }
            if (!RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
                return;
            }
            this.power = 0;
            this.hasUpdated = true;
            boolean should = RedstoneApi.getInstance().shouldWiresHandleUpdates();
            RedstoneApi.getInstance().setWiresHandleUpdates(false);
            this.onRedstoneUpdate();
            this.connections.disconnectAll();
            RedstoneApi.getInstance().setWiresHandleUpdates(should);
        }

        @Override
        public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
            this.power = (byte)-1;
            double scale = 2.0;
            double translation = 0.5;
            double droppedTranslation = -0.5;
            RenderHelper rh = RenderHelper.instance;
            rh.setRenderCoords(null, 0, 0, 0);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glPushMatrix();
            if (type == IItemRenderer.ItemRenderType.ENTITY) {
                GL11.glTranslated((double)droppedTranslation, (double)0.0, (double)droppedTranslation);
            }
            GL11.glTranslated((double)0.0, (double)translation, (double)0.0);
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            Tessellator.field_78398_a.func_78382_b();
            this.renderStatic(new Vec3i(0, 0, 0), rh, RenderBlocks.getInstance(), 0);
            Tessellator.field_78398_a.func_78381_a();
            GL11.glPopMatrix();
            rh.reset();
        }

        @Override
        public void writeUpdateData(DataOutput buffer) throws IOException {
            super.writeUpdateData(buffer);
            for (int i = 0; i < 6; ++i) {
                IRedstoneDevice dev;
                boolean connected = false;
                boolean render = false;
                IConnection<IRedstoneDevice> c = this.getRedstoneConnectionCache().getConnectionOnSide(ForgeDirection.getOrientation((int)i));
                if (c != null && (dev = c.getB()) instanceof IFace && ((IFace)((Object)dev)).getFace() == ForgeDirection.getOrientation((int)i).getOpposite()) {
                    if (dev instanceof IRedwire) {
                        if (dev instanceof IInsulatedRedstoneDevice && ((IInsulatedRedstoneDevice)dev).getInsulationColor(c.getSideB()) != MinecraftColor.NONE) {
                            render = true;
                        }
                        if (dev instanceof IFace && this.getFace().ordinal() > ((IFace)((Object)dev)).getFace().ordinal()) {
                            render = true;
                        }
                    } else {
                        connected = true;
                        render = true;
                    }
                }
                buffer.writeBoolean(connected);
                buffer.writeBoolean(render);
            }
            buffer.writeByte(this.power);
        }

        @Override
        public void readUpdateData(DataInput buffer) throws IOException {
            super.readUpdateData(buffer);
            this.power = buffer.readByte();
            if (this.getParent() != null && this.getWorld() != null) {
                this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
            }
        }

        @Override
        public void addWAILABody(List<String> text) {
            super.addWAILABody(text);
            text.add("Power: " + (this.power & 0xFF));
        }

        public boolean canConnectRedstone(ForgeDirection side) {
            return side != this.getFace().getOpposite();
        }

        public int getWeakPower(ForgeDirection side) {
            if (!RedstoneApi.getInstance().shouldWiresOutputPower(this.hasLoss(side))) {
                return 0;
            }
            if (new Vec3i((IWorldLocation)this).add(side).getBlock() instanceof BlockRedstoneWire) {
                return 0;
            }
            if (side == this.getFace().getOpposite()) {
                return 0;
            }
            return MathHelper.map((int)(this.power & 0xFF), (int)0, (int)255, (int)0, (int)15);
        }

        public int getStrongPower(ForgeDirection side) {
            if (!RedstoneApi.getInstance().shouldWiresOutputPower(this.hasLoss(side))) {
                return 0;
            }
            if (side != this.getFace()) {
                return 0;
            }
            return MathHelper.map((int)(this.power & 0xFF), (int)0, (int)255, (int)0, (int)15);
        }

        @Override
        public boolean isNormalFace(ForgeDirection side) {
            return false;
        }
    }
}

