/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.wire.redstone;

import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnection;
import com.bluepowermod.api.connect.IConnectionCache;
import com.bluepowermod.api.connect.IConnectionListener;
import com.bluepowermod.api.gate.IIntegratedCircuitPart;
import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IBundledConductor;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IInsulatedRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedConductor;
import com.bluepowermod.api.wire.redstone.IRedstoneConductor;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedwire;
import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.client.render.IconSupplier;
import com.bluepowermod.init.BPCreativeTabs;
import com.bluepowermod.part.gate.ic.FakeMultipartTileIC;
import com.bluepowermod.part.wire.PartWireFreestanding;
import com.bluepowermod.part.wire.redstone.WireHelper;
import com.bluepowermod.redstone.BundledConnectionCache;
import com.bluepowermod.redstone.BundledDeviceWrapper;
import com.bluepowermod.redstone.DummyRedstoneDevice;
import com.bluepowermod.redstone.RedstoneApi;
import com.bluepowermod.redstone.RedstoneConnection;
import com.bluepowermod.redstone.RedstoneConnectionCache;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.helper.MathHelper;
import uk.co.qmunity.lib.helper.RedstoneHelper;
import uk.co.qmunity.lib.misc.Pair;
import uk.co.qmunity.lib.part.IPartRedstone;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.MicroblockShape;
import uk.co.qmunity.lib.part.compat.OcclusionHelper;
import uk.co.qmunity.lib.vec.IWorldLocation;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public abstract class PartRedwireFreestanding
extends PartWireFreestanding
implements IRedwire,
IRedConductor,
IIntegratedCircuitPart,
IPartRedstone {
    private RedwireType type;
    private int size;
    private boolean[] connections = new boolean[6];

    public PartRedwireFreestanding(int size, RedwireType type) {
        this.size = size;
        this.type = type;
    }

    @Override
    public RedwireType getRedwireType(ForgeDirection side) {
        return this.type;
    }

    @Override
    public String getUnlocalizedName() {
        return this.getType();
    }

    @Override
    protected boolean shouldRenderConnection(ForgeDirection side) {
        if (this.getParent() == null || this.getWorld() == null) {
            return this.isConnected(side);
        }
        return this.connections[side.ordinal()];
    }

    protected abstract boolean isConnected(ForgeDirection var1);

    @Override
    protected int getSize() {
        return this.size;
    }

    @Override
    protected IIcon getFrameIcon() {
        return Blocks.field_150344_f.func_149691_a(0, 0);
    }

    @Override
    public List<Vec3dCube> getSelectionBoxes() {
        ArrayList<Vec3dCube> boxes = new ArrayList<Vec3dCube>();
        double size = 0.5;
        boxes.add(new Vec3dCube(0.5 - size / 2.0, 0.5 - size / 2.0, 0.5 - size / 2.0, 0.5 + size / 2.0, 0.5 + size / 2.0, 0.5 + size / 2.0));
        if (this.getParent() == null || this.getWorld() == null) {
            return boxes;
        }
        Vec3dCube box = new Vec3dCube(0.5 - size / 2.0, 0.0, 0.5 - size / 2.0, 0.5 + size / 2.0, 0.5 - size / 2.0, 0.5 + size / 2.0);
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.isConnected(d) && !this.shouldRenderConnection(d)) continue;
            boxes.add(box.clone().rotate(d, Vec3d.center));
        }
        return boxes;
    }

    @Override
    public List<Vec3dCube> getOcclusionBoxes() {
        ArrayList<Vec3dCube> boxes = new ArrayList<Vec3dCube>();
        double size = 0.5;
        boxes.add(new Vec3dCube(0.5 - size / 2.0, 0.5 - size / 2.0, 0.5 - size / 2.0, 0.5 + size / 2.0, 0.5 + size / 2.0, 0.5 + size / 2.0));
        return boxes;
    }

    @Override
    public void addCollisionBoxesToList(List<Vec3dCube> boxes, Entity entity) {
        boxes.addAll(this.getSelectionBoxes());
    }

    @Override
    public boolean hasLoss(ForgeDirection side) {
        return this.getRedwireType(ForgeDirection.UNKNOWN).hasLoss();
    }

    @Override
    public boolean isAnalogue(ForgeDirection side) {
        return this.getRedwireType(ForgeDirection.UNKNOWN).isAnalogue();
    }

    public void writeUpdateData(DataOutput buffer) throws IOException {
        super.writeUpdateData(buffer);
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            buffer.writeBoolean(this.isConnected(d));
        }
    }

    public void readUpdateData(DataInput buffer) throws IOException {
        super.readUpdateData(buffer);
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            this.connections[d.ordinal()] = buffer.readBoolean();
        }
    }

    @Override
    public boolean canPlaceOnIntegratedCircuit() {
        return true;
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return BPCreativeTabs.wiring;
    }

    public static class PartRedwireFreestandingBundled
    extends PartRedwireFreestanding
    implements IBundledConductor.IAdvancedBundledConductor,
    IConnectionListener {
        private BundledConnectionCache bundledConnections = RedstoneApi.getInstance().createBundledConnectionCache(this);
        private byte[] power = new byte[16];
        private MinecraftColor color;

        public PartRedwireFreestandingBundled(RedwireType type, MinecraftColor color) {
            super(6, type);
            this.color = color;
            this.bundledConnections.listen();
        }

        public String getType() {
            return "wire.freestanding." + this.getRedwireType(ForgeDirection.UNKNOWN).getName() + ".bundled" + (this.color != MinecraftColor.NONE ? "." + this.color.name().toLowerCase() : "");
        }

        @Override
        protected boolean isConnected(ForgeDirection side) {
            if (this.getParent() == null || this.getWorld() == null) {
                return true;
            }
            return this.bundledConnections.getConnectionOnSide(side) != null;
        }

        @Override
        protected IIcon getWireIcon(ForgeDirection side) {
            return null;
        }

        @Override
        protected IIcon getWireIcon(ForgeDirection side, ForgeDirection face) {
            if (side == ForgeDirection.UNKNOWN) {
                boolean up = this.shouldRenderConnection(ForgeDirection.UP);
                boolean down = this.shouldRenderConnection(ForgeDirection.DOWN);
                boolean west = this.shouldRenderConnection(ForgeDirection.WEST);
                boolean east = this.shouldRenderConnection(ForgeDirection.EAST);
                boolean north = this.shouldRenderConnection(ForgeDirection.NORTH);
                boolean south = this.shouldRenderConnection(ForgeDirection.SOUTH);
                if (face == ForgeDirection.UP || face == ForgeDirection.DOWN) {
                    if ((west || east) != (north || south)) {
                        if (west || east) {
                            return IconSupplier.wireBundledStraight2;
                        }
                        return IconSupplier.wireBundledStraight1;
                    }
                    if (west || east || north || south) {
                        return IconSupplier.wireBundledCross;
                    }
                } else if (face == ForgeDirection.EAST || face == ForgeDirection.WEST) {
                    if ((up || down) != (north || south)) {
                        if (up || down) {
                            return IconSupplier.wireBundledStraight1;
                        }
                        return IconSupplier.wireBundledStraight2;
                    }
                    if (up || down || north || south) {
                        return IconSupplier.wireBundledCross;
                    }
                } else if (face == ForgeDirection.NORTH || face == ForgeDirection.SOUTH) {
                    if ((up || down) != (west || east)) {
                        if (up || down) {
                            return IconSupplier.wireBundledStraight1;
                        }
                        return IconSupplier.wireBundledStraight2;
                    }
                    if (up || down || west || east) {
                        return IconSupplier.wireBundledCross;
                    }
                }
                if (!this.shouldRenderConnection(face) && this.shouldRenderConnection(face.getOpposite())) {
                    return IconSupplier.wireBundledConnection;
                }
                return IconSupplier.wireBundledCross;
            }
            if (side == face) {
                return IconSupplier.wireBundledConnection;
            }
            return IconSupplier.wireBundledCross;
        }

        @Override
        protected int getColorMultiplier() {
            return 0xFFFFFF;
        }

        @Override
        public boolean canConnect(ForgeDirection side, IBundledDevice device, ConnectionType type) {
            if (type == ConnectionType.STRAIGHT && side == ForgeDirection.UNKNOWN && device instanceof DummyRedstoneDevice) {
                return false;
            }
            if (type == ConnectionType.CLOSED_CORNER && side == ForgeDirection.UNKNOWN) {
                return false;
            }
            if (device instanceof IRedwire) {
                RedwireType rwt = this.getRedwireType(side);
                if (type == null) {
                    return false;
                }
                RedwireType rwt_ = ((IRedwire)((Object)device)).getRedwireType(type == ConnectionType.STRAIGHT ? side.getOpposite() : side);
                if (rwt_ == null) {
                    return false;
                }
                if (!rwt.canConnectTo(rwt_)) {
                    return false;
                }
            }
            return OcclusionHelper.microblockOcclusionTest((ITilePartHolder)this.getParent(), (MicroblockShape)MicroblockShape.FACE_HOLLOW, (int)1, (ForgeDirection[])new ForgeDirection[]{side});
        }

        @Override
        public IConnectionCache<? extends IBundledDevice> getBundledConnectionCache() {
            return this.bundledConnections;
        }

        @Override
        public void onConnect(IConnection<?> connection) {
            this.sendUpdatePacket();
        }

        @Override
        public void onDisconnect(IConnection<?> connection) {
            this.sendUpdatePacket();
        }

        @Override
        public byte[] getBundledOutput(ForgeDirection side) {
            if (!RedstoneApi.getInstance().shouldWiresOutputPower(this.hasLoss(side))) {
                return new byte[16];
            }
            return this.getBundledPower(side);
        }

        @Override
        public void setBundledPower(ForgeDirection side, byte[] power) {
            this.power = power;
        }

        @Override
        public byte[] getBundledPower(ForgeDirection side) {
            return this.power;
        }

        @Override
        public void onBundledUpdate() {
        }

        @Override
        public boolean canPropagateBundledFrom(ForgeDirection fromSide) {
            return true;
        }

        @Override
        public Collection<Map.Entry<IConnection<IBundledDevice>, Boolean>> propagateBundled(ForgeDirection fromSide) {
            ArrayList<Map.Entry<IConnection<IBundledDevice>, Boolean>> l = new ArrayList<Map.Entry<IConnection<IBundledDevice>, Boolean>>();
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                IConnection<IBundledDevice> c = this.bundledConnections.getConnectionOnSide(d);
                if (c == null) continue;
                l.add((Map.Entry<IConnection<IBundledDevice>, Boolean>)new Pair(c, (Object)(c.getB() instanceof IRedwire && ((IRedwire)((Object)c.getB())).getRedwireType(c.getSideB()) != this.getRedwireType(c.getSideA()) ? 1 : 0)));
            }
            return l;
        }

        @Override
        public MinecraftColor getBundledColor(ForgeDirection side) {
            return this.color;
        }

        @Override
        public void onUpdate() {
            if (!RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
                return;
            }
            super.onUpdate();
            if (this.getWorld().field_72995_K) {
                return;
            }
            this.bundledConnections.recalculateConnections();
            RedstoneApi.getInstance().getBundledPropagator(this, ForgeDirection.DOWN).propagate();
        }

        @Override
        public void onRemoved() {
            if (!RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
                return;
            }
            super.onRemoved();
            if (this.getWorld().field_72995_K) {
                return;
            }
            this.bundledConnections.disconnectAll();
        }

        @Override
        public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
            RenderHelper rh = RenderHelper.instance;
            rh.setRenderCoords(null, 0, 0, 0);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glTranslated((double)0.0, (double)-0.125, (double)0.0);
            GL11.glScaled((double)1.25, (double)1.25, (double)1.25);
            Tessellator.field_78398_a.func_78382_b();
            this.renderStatic(new Vec3i(0, 0, 0), rh, RenderBlocks.getInstance(), 0);
            Tessellator.field_78398_a.func_78381_a();
            GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
            rh.reset();
        }

        @Override
        public void writeUpdateData(DataOutput buffer) throws IOException {
            super.writeUpdateData(buffer);
        }

        @Override
        public void readUpdateData(DataInput buffer) throws IOException {
            super.readUpdateData(buffer);
            if (this.getParent() != null && this.getWorld() != null) {
                this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
            }
        }

        public boolean canConnectRedstone(ForgeDirection side) {
            return false;
        }

        public int getWeakPower(ForgeDirection side) {
            return 0;
        }

        public int getStrongPower(ForgeDirection side) {
            return 0;
        }

        @Override
        public boolean isNormalFace(ForgeDirection side) {
            return false;
        }
    }

    public static class PartRedwireFreestandingInsulated
    extends PartRedwireFreestanding
    implements IRedstoneConductor.IAdvancedRedstoneConductor,
    IInsulatedRedstoneDevice,
    IBundledConductor.IAdvancedBundledConductor,
    IRedwire.IInsulatedRedwire,
    IConnectionListener {
        private RedstoneConnectionCache connections = RedstoneApi.getInstance().createRedstoneConnectionCache(this);
        private BundledConnectionCache bundledConnections = RedstoneApi.getInstance().createBundledConnectionCache(this);
        private boolean hasUpdated = false;
        private byte power = 0;
        private MinecraftColor color;

        public PartRedwireFreestandingInsulated(RedwireType type, MinecraftColor color) {
            super(4, type);
            this.color = color;
            this.connections.listen();
        }

        public String getType() {
            return "wire.freestanding." + this.getRedwireType(ForgeDirection.UNKNOWN).getName() + "." + this.color.name().toLowerCase();
        }

        @Override
        protected boolean isConnected(ForgeDirection side) {
            if (this.getParent() == null || this.getWorld() == null) {
                return true;
            }
            return this.connections.getConnectionOnSide(side) != null || this.bundledConnections.getConnectionOnSide(side) != null;
        }

        @Override
        protected IIcon getWireIcon(ForgeDirection side) {
            return IconSupplier.wireInsulation1;
        }

        @Override
        protected int getColorMultiplier() {
            return this.color.getHex();
        }

        @Override
        public boolean canConnect(ForgeDirection side, IRedstoneDevice device, ConnectionType type) {
            MinecraftColor c;
            if (type == ConnectionType.STRAIGHT && side == ForgeDirection.UNKNOWN && device instanceof DummyRedstoneDevice) {
                return false;
            }
            if (type == ConnectionType.CLOSED_CORNER && side == ForgeDirection.UNKNOWN) {
                return false;
            }
            if (device instanceof IInsulatedRedstoneDevice && (c = ((IInsulatedRedstoneDevice)device).getInsulationColor(type == ConnectionType.STRAIGHT ? side.getOpposite() : null)) != null && c != this.getInsulationColor(side)) {
                return false;
            }
            if (device instanceof IRedwire) {
                RedwireType rwt = this.getRedwireType(side);
                if (type == null) {
                    return false;
                }
                RedwireType rwt_ = ((IRedwire)((Object)device)).getRedwireType(type == ConnectionType.STRAIGHT ? side.getOpposite() : side);
                if (rwt_ == null) {
                    return false;
                }
                if (!rwt.canConnectTo(rwt_)) {
                    return false;
                }
            }
            return OcclusionHelper.microblockOcclusionTest((ITilePartHolder)this.getParent(), (MicroblockShape)MicroblockShape.FACE_HOLLOW, (int)1, (ForgeDirection[])new ForgeDirection[]{side});
        }

        @Override
        public boolean canConnect(ForgeDirection side, IBundledDevice device, ConnectionType type) {
            if (type == ConnectionType.STRAIGHT && side == ForgeDirection.UNKNOWN && device instanceof DummyRedstoneDevice) {
                return false;
            }
            if (type == ConnectionType.CLOSED_CORNER && side == ForgeDirection.UNKNOWN) {
                return false;
            }
            if (device instanceof IInsulatedRedstoneDevice) {
                return false;
            }
            if (!OcclusionHelper.microblockOcclusionTest((ITilePartHolder)this.getParent(), (MicroblockShape)MicroblockShape.FACE_HOLLOW, (int)1, (ForgeDirection[])new ForgeDirection[]{side})) {
                return false;
            }
            if (device instanceof IRedwire) {
                RedwireType rwt = this.getRedwireType(side);
                if (type == null) {
                    return false;
                }
                RedwireType rwt_ = ((IRedwire)((Object)device)).getRedwireType(type == ConnectionType.STRAIGHT ? side.getOpposite() : side);
                if (rwt_ == null) {
                    return false;
                }
                return rwt.canConnectTo(rwt_);
            }
            return false;
        }

        public RedstoneConnectionCache getRedstoneConnectionCache() {
            return this.connections;
        }

        @Override
        public IConnectionCache<? extends IBundledDevice> getBundledConnectionCache() {
            return this.bundledConnections;
        }

        @Override
        public void onConnect(IConnection<?> connection) {
            this.sendUpdatePacket();
        }

        @Override
        public void onDisconnect(IConnection<?> connection) {
            this.sendUpdatePacket();
        }

        @Override
        public byte getRedstonePower(ForgeDirection side) {
            if (!RedstoneApi.getInstance().shouldWiresOutputPower(this.hasLoss(side))) {
                return 0;
            }
            if (!this.isAnalogue(side)) {
                return (byte)((this.power & 0xFF) > 0 ? 255 : 0);
            }
            return this.power;
        }

        @Override
        public void setRedstonePower(ForgeDirection side, byte power) {
            byte pow = this.isAnalogue(side) ? power : ((power & 0xFF) > 0 ? (byte)-1 : 0);
            this.hasUpdated |= pow != this.power;
            this.power = pow;
        }

        @Override
        public byte[] getBundledOutput(ForgeDirection side) {
            if (!RedstoneApi.getInstance().shouldWiresOutputPower(this.hasLoss(side))) {
                return new byte[16];
            }
            return this.getBundledPower(side);
        }

        @Override
        public void setBundledPower(ForgeDirection side, byte[] power) {
            this.power = power[this.getInsulationColor(side).ordinal()];
            this.hasUpdated = true;
        }

        @Override
        public byte[] getBundledPower(ForgeDirection side) {
            byte[] val = new byte[16];
            val[this.color.ordinal()] = this.power;
            return val;
        }

        @Override
        public void onRedstoneUpdate() {
            if (this.getParent() instanceof FakeMultipartTileIC) {
                ((FakeMultipartTileIC)this.getParent()).getIC().loadWorld();
            }
            if (this.hasUpdated) {
                this.sendUpdatePacket();
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    IConnection<IRedstoneDevice> c = this.connections.getConnectionOnSide(dir);
                    IRedstoneDevice dev = null;
                    if (c != null) {
                        dev = c.getB();
                    }
                    if (dev != null && !(dev instanceof DummyRedstoneDevice)) continue;
                    RedstoneHelper.notifyRedstoneUpdate((World)this.getWorld(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), (ForgeDirection)dir, (boolean)false);
                }
                this.hasUpdated = false;
            }
        }

        @Override
        public void onRemoved() {
            if (!RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
                return;
            }
            super.onRemoved();
            if (this.getWorld().field_72995_K) {
                return;
            }
            this.connections.disconnectAll();
            this.bundledConnections.disconnectAll();
        }

        @Override
        public void onBundledUpdate() {
            this.onRedstoneUpdate();
        }

        @Override
        public boolean canPropagateFrom(ForgeDirection fromSide) {
            return true;
        }

        @Override
        public boolean canPropagateBundledFrom(ForgeDirection fromSide) {
            return true;
        }

        public List<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> propagate(ForgeDirection fromSide) {
            ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> l = new ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>>();
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                IConnection<IBundledDevice> cB;
                IConnection<IRedstoneDevice> c = this.connections.getConnectionOnSide(d);
                if (c != null) {
                    l.add((Map.Entry<IConnection<IRedstoneDevice>, Boolean>)new Pair(c, (Object)(c.getB() instanceof IRedwire && ((IRedwire)((Object)c.getB())).getRedwireType(c.getSideB()) != this.getRedwireType(c.getSideA()) ? 1 : 0)));
                }
                if ((cB = this.bundledConnections.getConnectionOnSide(d)) == null) continue;
                l.add((Map.Entry<IConnection<IRedstoneDevice>, Boolean>)new Pair((Object)new RedstoneConnection(this, BundledDeviceWrapper.wrap(cB.getB(), this.color), cB.getSideA(), cB.getSideB(), cB.getType()), (Object)(cB.getB() instanceof IRedwire && ((IRedwire)((Object)cB.getB())).getRedwireType(cB.getSideB()) != this.getRedwireType(cB.getSideA()) ? 1 : 0)));
            }
            return l;
        }

        @Override
        public Collection<Map.Entry<IConnection<IBundledDevice>, Boolean>> propagateBundled(ForgeDirection fromSide) {
            ArrayList<Map.Entry<IConnection<IBundledDevice>, Boolean>> l = new ArrayList<Map.Entry<IConnection<IBundledDevice>, Boolean>>();
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                IConnection<IBundledDevice> c = this.bundledConnections.getConnectionOnSide(d);
                if (c == null) continue;
                l.add((Map.Entry<IConnection<IBundledDevice>, Boolean>)new Pair(c, (Object)(c.getB() instanceof IRedwire && ((IRedwire)((Object)c.getB())).getRedwireType(c.getSideB()) != this.getRedwireType(c.getSideA()) ? 1 : 0)));
            }
            return l;
        }

        @Override
        public MinecraftColor getBundledColor(ForgeDirection side) {
            return null;
        }

        @Override
        public void onUpdate() {
            if (!RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
                return;
            }
            super.onUpdate();
            if (this.getWorld().field_72995_K) {
                return;
            }
            this.connections.recalculateConnections();
            this.bundledConnections.recalculateConnections();
            RedstoneApi.getInstance().getRedstonePropagator(this, ForgeDirection.DOWN).propagate();
            RedstoneApi.getInstance().getBundledPropagator(this, ForgeDirection.DOWN).propagate();
        }

        @Override
        public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
            this.power = (byte)-1;
            RenderHelper rh = RenderHelper.instance;
            rh.setRenderCoords(null, 0, 0, 0);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glTranslated((double)0.0, (double)-0.125, (double)0.0);
            GL11.glScaled((double)1.25, (double)1.25, (double)1.25);
            Tessellator.field_78398_a.func_78382_b();
            this.renderStatic(new Vec3i(0, 0, 0), rh, RenderBlocks.getInstance(), 0);
            Tessellator.field_78398_a.func_78381_a();
            GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
            rh.reset();
        }

        @Override
        public void writeUpdateData(DataOutput buffer) throws IOException {
            super.writeUpdateData(buffer);
            buffer.writeByte(this.power);
        }

        @Override
        public void readUpdateData(DataInput buffer) throws IOException {
            super.readUpdateData(buffer);
            this.power = buffer.readByte();
            if (this.getParent() != null && this.getWorld() != null) {
                this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
            }
        }

        @Override
        public void addWAILABody(List<String> text) {
            super.addWAILABody(text);
            text.add("Power: " + (this.power & 0xFF));
        }

        @Override
        public MinecraftColor getInsulationColor(ForgeDirection side) {
            return this.color;
        }

        public boolean canConnectRedstone(ForgeDirection side) {
            return true;
        }

        public int getWeakPower(ForgeDirection side) {
            if (!RedstoneApi.getInstance().shouldWiresOutputPower(this.hasLoss(side))) {
                return 0;
            }
            if (new Vec3i((IWorldLocation)this).add(side).getBlock() instanceof BlockRedstoneWire) {
                return 0;
            }
            return MathHelper.map((int)(this.power & 0xFF), (int)0, (int)255, (int)0, (int)15);
        }

        public int getStrongPower(ForgeDirection side) {
            return 0;
        }

        @Override
        public boolean isNormalFace(ForgeDirection side) {
            return false;
        }
    }

    public static class PartRedwireFreestandingUninsulated
    extends PartRedwireFreestanding
    implements IRedstoneConductor.IAdvancedRedstoneConductor,
    IConnectionListener {
        private RedstoneConnectionCache connections = RedstoneApi.getInstance().createRedstoneConnectionCache(this);
        private boolean hasUpdated = false;
        private byte power = 0;

        public PartRedwireFreestandingUninsulated(RedwireType type) {
            super(2, type);
            this.connections.listen();
        }

        public String getType() {
            return "wire.freestanding." + this.getRedwireType(ForgeDirection.UNKNOWN).getName();
        }

        @Override
        protected boolean isConnected(ForgeDirection side) {
            return this.connections.getConnectionOnSide(side) != null;
        }

        @Override
        protected IIcon getWireIcon(ForgeDirection side) {
            return IconSupplier.wire;
        }

        @Override
        protected int getColorMultiplier() {
            return WireHelper.getColorForPowerLevel(this.getRedwireType(ForgeDirection.UNKNOWN), this.power);
        }

        @Override
        public boolean canConnect(ForgeDirection side, IRedstoneDevice device, ConnectionType type) {
            if (type == ConnectionType.STRAIGHT && side == ForgeDirection.UNKNOWN && device instanceof DummyRedstoneDevice) {
                return false;
            }
            if (type == ConnectionType.CLOSED_CORNER && side == ForgeDirection.UNKNOWN) {
                return false;
            }
            if (device instanceof IRedwire) {
                RedwireType rwt = this.getRedwireType(side);
                if (type == null) {
                    return false;
                }
                RedwireType rwt_ = ((IRedwire)((Object)device)).getRedwireType(type == ConnectionType.STRAIGHT ? side.getOpposite() : side);
                if (rwt_ == null) {
                    return false;
                }
                if (!rwt.canConnectTo(rwt_)) {
                    return false;
                }
            }
            return OcclusionHelper.microblockOcclusionTest((ITilePartHolder)this.getParent(), (MicroblockShape)MicroblockShape.FACE_HOLLOW, (int)1, (ForgeDirection[])new ForgeDirection[]{side});
        }

        public RedstoneConnectionCache getRedstoneConnectionCache() {
            return this.connections;
        }

        @Override
        public void onConnect(IConnection<?> connection) {
            this.sendUpdatePacket();
        }

        @Override
        public void onDisconnect(IConnection<?> connection) {
            this.sendUpdatePacket();
        }

        @Override
        public byte getRedstonePower(ForgeDirection side) {
            if (!RedstoneApi.getInstance().shouldWiresOutputPower(this.hasLoss(side))) {
                return 0;
            }
            if (!this.isAnalogue(side)) {
                return (byte)((this.power & 0xFF) > 0 ? 255 : 0);
            }
            return this.power;
        }

        @Override
        public void setRedstonePower(ForgeDirection side, byte power) {
            byte pow = this.isAnalogue(side) ? power : ((power & 0xFF) > 0 ? (byte)-1 : 0);
            this.hasUpdated |= pow != this.power;
            this.power = pow;
        }

        @Override
        public void onRedstoneUpdate() {
            if (this.getParent() instanceof FakeMultipartTileIC) {
                ((FakeMultipartTileIC)this.getParent()).getIC().loadWorld();
            }
            if (this.hasUpdated) {
                this.sendUpdatePacket();
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    IConnection<IRedstoneDevice> c = this.connections.getConnectionOnSide(dir);
                    IRedstoneDevice dev = null;
                    if (c != null) {
                        dev = c.getB();
                    }
                    if (dev != null && !(dev instanceof DummyRedstoneDevice)) continue;
                    RedstoneHelper.notifyRedstoneUpdate((World)this.getWorld(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), (ForgeDirection)dir, (boolean)false);
                }
                this.hasUpdated = false;
            }
        }

        @Override
        public boolean canPropagateFrom(ForgeDirection fromSide) {
            return true;
        }

        public List<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> propagate(ForgeDirection fromSide) {
            if (this.getParent() instanceof FakeMultipartTileIC) {
                ((FakeMultipartTileIC)this.getParent()).getIC().loadWorld();
            }
            ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> l = new ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>>();
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                IConnection<IRedstoneDevice> c = this.connections.getConnectionOnSide(d);
                if (c == null) continue;
                l.add((Map.Entry<IConnection<IRedstoneDevice>, Boolean>)new Pair(c, (Object)(c.getB() instanceof IRedwire && ((IRedwire)((Object)c.getB())).getRedwireType(c.getSideB()) != this.getRedwireType(c.getSideA()) ? 1 : 0)));
            }
            return l;
        }

        @Override
        public void onUpdate() {
            if (!RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
                return;
            }
            super.onUpdate();
            if (this.getWorld().field_72995_K) {
                return;
            }
            this.connections.recalculateConnections();
            ForgeDirection d = ForgeDirection.UNKNOWN;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (this.getRedstoneConnectionCache().getConnectionOnSide(dir) == null) continue;
                d = dir;
            }
            RedstoneApi.getInstance().getRedstonePropagator(this, d).propagate();
        }

        @Override
        public void onRemoved() {
            if (!RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
                return;
            }
            super.onRemoved();
            if (this.getWorld().field_72995_K) {
                return;
            }
            this.connections.disconnectAll();
        }

        @Override
        public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
            this.power = (byte)-1;
            RenderHelper rh = RenderHelper.instance;
            rh.setRenderCoords(null, 0, 0, 0);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glTranslated((double)0.0, (double)-0.125, (double)0.0);
            GL11.glScaled((double)1.25, (double)1.25, (double)1.25);
            Tessellator.field_78398_a.func_78382_b();
            this.renderStatic(new Vec3i(0, 0, 0), rh, RenderBlocks.getInstance(), 0);
            Tessellator.field_78398_a.func_78381_a();
            GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
            rh.reset();
        }

        @Override
        public void writeUpdateData(DataOutput buffer) throws IOException {
            super.writeUpdateData(buffer);
            buffer.writeByte(this.power);
        }

        @Override
        public void readUpdateData(DataInput buffer) throws IOException {
            super.readUpdateData(buffer);
            this.power = buffer.readByte();
            if (this.getParent() != null && this.getWorld() != null) {
                this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
            }
        }

        @Override
        public void addWAILABody(List<String> text) {
            super.addWAILABody(text);
            text.add("Power: " + (this.power & 0xFF));
        }

        public boolean canConnectRedstone(ForgeDirection side) {
            return true;
        }

        public int getWeakPower(ForgeDirection side) {
            if (!RedstoneApi.getInstance().shouldWiresOutputPower(this.hasLoss(side))) {
                return 0;
            }
            if (new Vec3i((IWorldLocation)this).add(side).getBlock() instanceof BlockRedstoneWire) {
                return 0;
            }
            return MathHelper.map((int)(this.power & 0xFF), (int)0, (int)255, (int)0, (int)15);
        }

        public int getStrongPower(ForgeDirection side) {
            return 0;
        }

        @Override
        public boolean isNormalFace(ForgeDirection side) {
            return false;
        }
    }
}

