/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.redstone;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IPropagator;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedwire;
import com.bluepowermod.redstone.BundledDeviceWrapper;
import com.bluepowermod.redstone.RedstoneApi;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.part.IPart;

public class BundledPropagator
implements IPropagator<IBundledDevice> {
    private IBundledDevice device;
    private ForgeDirection side;

    public BundledPropagator(IBundledDevice device, ForgeDirection side) {
        this.device = device;
        this.side = side;
    }

    @Override
    public void propagate() {
        if (this.device instanceof IPart && ((IPart)this.device).getParent() == null || this.device.getWorld() == null) {
            return;
        }
        for (MinecraftColor c : MinecraftColor.VALID_COLORS) {
            IRedstoneDevice dev = this.device instanceof IRedwire.IInsulatedRedwire ? (IRedstoneDevice)((Object)this.device) : BundledDeviceWrapper.wrap(this.device, c);
            if (dev == null) continue;
            RedstoneApi.getInstance().getRedstonePropagator(dev, this.side).propagate();
        }
    }
}

