/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.redstone;

import com.bluepowermod.api.misc.IFace;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IBundledDeviceWrapper;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneDeviceWrapper;
import com.bluepowermod.api.wire.redstone.IRedstoneProvider;
import com.bluepowermod.redstone.RedstoneApi;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.compat.MultipartCompatibility;

public class RedstoneProviderQmunityLib
implements IRedstoneProvider {
    @Override
    public IRedstoneDevice getRedstoneDeviceAt(World world, int x, int y, int z, ForgeDirection face, ForgeDirection side) {
        ITilePartHolder holder = MultipartCompatibility.getPartHolder((World)world, (int)x, (int)y, (int)z);
        if (holder != null) {
            boolean foundOnlyFace = holder.getParts().size() > 0;
            for (IPart p : holder.getParts()) {
                if (p instanceof IRedstoneDeviceWrapper) {
                    if (!(p instanceof IFace ? ((IFace)p).getFace() == face : face == ForgeDirection.UNKNOWN)) continue;
                    return ((IRedstoneDeviceWrapper)p).getDeviceOnSide(side);
                }
                if (p instanceof IRedstoneDevice) {
                    if (p instanceof IFace ? ((IFace)p).getFace() == face : face == ForgeDirection.UNKNOWN) {
                        return (IRedstoneDevice)p;
                    }
                    foundOnlyFace = true;
                    continue;
                }
                if (p instanceof IFace) continue;
                foundOnlyFace = false;
            }
            if (foundOnlyFace) {
                return RedstoneApi.getInstance().getReturnDevice();
            }
        }
        return null;
    }

    @Override
    public IBundledDevice getBundledDeviceAt(World world, int x, int y, int z, ForgeDirection face, ForgeDirection side) {
        ITilePartHolder holder = MultipartCompatibility.getPartHolder((World)world, (int)x, (int)y, (int)z);
        if (holder != null) {
            boolean foundOnlyFace = holder.getParts().size() > 0;
            for (IPart p : holder.getParts()) {
                if (p instanceof IBundledDeviceWrapper) {
                    if (!(p instanceof IFace ? ((IFace)p).getFace() == face : face == ForgeDirection.UNKNOWN)) continue;
                    return ((IBundledDeviceWrapper)p).getBundledDeviceOnSide(side);
                }
                if (p instanceof IBundledDevice) {
                    if (p instanceof IFace ? ((IFace)p).getFace() == face : face == ForgeDirection.UNKNOWN) {
                        return (IBundledDevice)p;
                    }
                    foundOnlyFace = true;
                    continue;
                }
                if (p instanceof IFace) continue;
                foundOnlyFace = false;
            }
            if (foundOnlyFace) {
                return null;
            }
        }
        return null;
    }
}

