/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.part.IGuiButtonSensitive;
import com.bluepowermod.part.tube.PneumaticTube;
import com.bluepowermod.part.tube.TubeStack;
import com.bluepowermod.tile.IFuzzyRetrieving;
import com.bluepowermod.tile.IRejectAnimator;
import com.bluepowermod.tile.TileMachineBase;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.part.compat.MultipartCompatibility;

public class TileManager
extends TileMachineBase
implements ISidedInventory,
IGuiButtonSensitive,
IRejectAnimator,
IFuzzyRetrieving {
    protected final ItemStack[] inventory = new ItemStack[24];
    public IPneumaticTube.TubeColor filterColor = IPneumaticTube.TubeColor.NONE;
    public int priority;
    public int mode;
    public int fuzzySetting;
    private int rejectTicker = -1;

    @Override
    public TubeStack acceptItemFromTube(TubeStack stack, ForgeDirection from, boolean simulate) {
        int itemsAccepted;
        if (from == this.getFacingDirection().getOpposite() && (itemsAccepted = this.acceptedItems(stack.stack)) > 0) {
            if (itemsAccepted >= stack.stack.field_77994_a) {
                ItemStack rejectedStack = IOHelper.insert(this.getTileCache(this.getFacingDirection()), stack.stack, from, simulate);
                if (!(rejectedStack != null && rejectedStack.field_77994_a == stack.stack.field_77994_a || simulate)) {
                    this.rejectTicker = 0;
                    this.sendUpdatePacket();
                }
                if (rejectedStack == null) {
                    return null;
                }
                stack.stack = rejectedStack;
                return stack;
            }
            TubeStack injectedStack = stack.copy();
            stack.stack.field_77994_a -= itemsAccepted;
            injectedStack.stack.field_77994_a = itemsAccepted;
            ItemStack rejectedStack = IOHelper.insert(this.getTileCache(this.getFacingDirection()), injectedStack.stack, from, simulate);
            if (!(rejectedStack != null && rejectedStack.field_77994_a == injectedStack.stack.field_77994_a || simulate)) {
                this.rejectTicker = 0;
                this.sendUpdatePacket();
            }
            if (rejectedStack != null) {
                stack.stack.field_77994_a += rejectedStack.field_77994_a;
            }
        }
        stack.setTarget(null, null);
        return super.acceptItemFromTube(stack, from, simulate);
    }

    private int acceptedItems(ItemStack item) {
        if (item == null) {
            return 0;
        }
        int managerCount = IOHelper.getItemCount(item, this, ForgeDirection.UNKNOWN, this.fuzzySetting);
        if (this.mode == 1 && managerCount > 0) {
            return item.field_77994_a;
        }
        return managerCount - IOHelper.getItemCount(item, this.getTileCache(this.getFacingDirection()), this.getFacingDirection().getOpposite(), this.fuzzySetting);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.getTicker() % 10 == 0 && this.isBufferEmpty()) {
            this.dumpUnwantedItems();
            this.retrieveItemsFromManagers();
            this.setOutputtingRedstone(this.mode == 0 && this.shouldEmitRedstone());
        }
        if (this.rejectTicker >= 0 && ++this.rejectTicker > 7) {
            this.rejectTicker = -1;
            this.markForRenderUpdate();
        }
        super.func_145845_h();
    }

    private boolean shouldEmitRedstone() {
        for (ItemStack stack : this.inventory) {
            if (stack == null || this.acceptedItems(stack) <= 0) continue;
            return false;
        }
        return true;
    }

    private void retrieveItemsFromManagers() {
        PneumaticTube tube = (PneumaticTube)MultipartCompatibility.getPart((World)this.field_145850_b, (int)(this.field_145851_c + this.getOutputDirection().offsetX), (int)(this.field_145848_d + this.getOutputDirection().offsetY), (int)(this.field_145849_e + this.getOutputDirection().offsetZ), PneumaticTube.class);
        if (tube != null) {
            for (ItemStack stack : this.inventory) {
                int acceptedItems = this.acceptedItems(stack);
                if (acceptedItems <= 0) continue;
                ItemStack retrievingStack = stack.func_77946_l();
                retrievingStack.field_77994_a = retrievingStack.func_77976_d();
                if (!tube.getLogic().retrieveStack(this, this.getOutputDirection(), retrievingStack, this.filterColor)) continue;
                return;
            }
        }
    }

    private void dumpUnwantedItems() {
        int[] slots;
        TileEntity te = this.getTileCache(this.getFacingDirection());
        IInventory inv = IOHelper.getInventoryForTE(te);
        for (int slot : slots = IOHelper.getAccessibleSlotsForInventory(inv, this.getFacingDirection().getOpposite())) {
            ItemStack stack = inv.func_70301_a(slot);
            int acceptedItems = this.acceptedItems(stack);
            if (acceptedItems >= 0) continue;
            int rejectedItems = -acceptedItems;
            ItemStack rejectingStack = stack.func_77946_l();
            rejectingStack.field_77994_a = Math.min(rejectedItems, rejectingStack.func_77976_d());
            rejectingStack = IOHelper.extract(te, this.getFacingDirection().getOpposite(), rejectingStack, true, false, this.fuzzySetting);
            if (rejectingStack == null) continue;
            this.addItemToOutputBuffer(rejectingStack, this.filterColor);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tCompound) {
        super.func_145839_a(tCompound);
        for (int i = 0; i < 24; ++i) {
            NBTTagCompound tc = tCompound.func_74775_l("inventory" + i);
            this.inventory[i] = ItemStack.func_77949_a((NBTTagCompound)tc);
        }
        this.filterColor = IPneumaticTube.TubeColor.values()[tCompound.func_74771_c("filterColor")];
        this.mode = tCompound.func_74771_c("mode");
        this.priority = tCompound.func_74771_c("priority");
        this.fuzzySetting = tCompound.func_74771_c("fuzzySetting");
    }

    @Override
    public void func_145841_b(NBTTagCompound tCompound) {
        super.func_145841_b(tCompound);
        for (int i = 0; i < 24; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound tc = new NBTTagCompound();
            this.inventory[i].func_77955_b(tc);
            tCompound.func_74782_a("inventory" + i, (NBTBase)tc);
        }
        tCompound.func_74774_a("filterColor", (byte)this.filterColor.ordinal());
        tCompound.func_74774_a("mode", (byte)this.mode);
        tCompound.func_74774_a("priority", (byte)this.priority);
        tCompound.func_74774_a("fuzzySetting", (byte)this.fuzzySetting);
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound tag) {
        super.writeToPacketNBT(tag);
        tag.func_74774_a("rejectAnimation", (byte)this.rejectTicker);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound tag) {
        super.readFromPacketNBT(tag);
        this.rejectTicker = tag.func_74771_c("rejectAnimation");
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack itemStack = this.func_70301_a(i);
        if (itemStack != null) {
            this.func_70299_a(i, null);
        }
        return itemStack;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory[i] = itemStack;
    }

    public String func_145825_b() {
        return BPBlocks.manager.func_149739_a();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.inventory) {
            if (stack == null) continue;
            drops.add(stack);
        }
        return drops;
    }

    public int[] func_94128_d(int var1) {
        ForgeDirection direction = this.getFacingDirection();
        if (var1 == direction.ordinal() || var1 == direction.getOpposite().ordinal()) {
            return new int[0];
        }
        int[] slots = new int[this.inventory.length];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return true;
    }

    @Override
    public void onButtonPress(EntityPlayer player, int messageId, int value) {
        if (messageId == 0) {
            this.filterColor = IPneumaticTube.TubeColor.values()[value];
        } else if (messageId == 1) {
            this.mode = value;
        } else if (messageId == 2) {
            this.priority = value;
        } else {
            this.fuzzySetting = value;
        }
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public boolean isRejecting() {
        return this.rejectTicker >= 0;
    }

    @Override
    public int getFuzzySetting() {
        return this.fuzzySetting;
    }
}

