/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiChemicalCrystallizer;
import mekanism.client.nei.BaseRecipeHandler;
import mekanism.common.ObfuscatedNames;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ChemicalCrystallizerRecipeHandler
extends BaseRecipeHandler {
    private int ticksPassed;
    public static int xOffset = 5;
    public static int yOffset = 3;

    public String getRecipeName() {
        return LangUtils.localize("tile.MachineBlock2.ChemicalCrystallizer.name");
    }

    public String getOverlayIdentifier() {
        return "chemicalcrystallizer";
    }

    public String getGuiTexture() {
        return "mekanism:gui/nei/GuiChemicalCrystallizer.png";
    }

    public Class getGuiClass() {
        return GuiChemicalCrystallizer.class;
    }

    public String getRecipeId() {
        return "mekanism.chemicalcrystallizer";
    }

    public Collection<CrystallizerRecipe> getRecipes() {
        return RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.get().values();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-2, (int)0, (int)3, (int)yOffset, (int)147, (int)79);
    }

    public void drawExtras(int i) {
        GasStack gas = ((CachedIORecipe)((Object)this.arecipes.get((int)i))).inputStack;
        float f = (float)(this.ticksPassed % 20) / 20.0f;
        this.drawProgressBar(53 - xOffset, 61 - yOffset, 176, 63, 48, 8, f, 0);
        if (gas != null) {
            this.displayGauge(58, 6 - xOffset, 5 - yOffset, 176, 4, 58, null, gas);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(53 - xOffset, 61 - yOffset, 48, 8), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (CrystallizerRecipe irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (CrystallizerRecipe irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ItemStackOutput)irecipe.getOutput()).output, (ItemStack)result)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe));
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        if (xAxis >= 6 && xAxis <= 22 && yAxis >= 18 && yAxis <= 76) {
            currenttip.add(LangUtils.localizeGasStack(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).inputStack));
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        GasStack stack = null;
        if (xAxis >= 6 && xAxis <= 22 && yAxis >= 18 && yAxis <= 76) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).inputStack;
        }
        if (stack != null && (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doGasLookup(stack, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doGasLookup(stack, true))) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        GasStack stack = null;
        if (xAxis >= 6 && xAxis <= 22 && yAxis >= 18 && yAxis <= 76) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).inputStack;
        }
        if (stack != null && (button == 0 ? this.doGasLookup(stack, false) : button == 1 && this.doGasLookup(stack, true))) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("gas") && ingredients.length == 1 && ingredients[0] instanceof GasStack) {
            for (CrystallizerRecipe irecipe : this.getRecipes()) {
                if (!((GasInput)irecipe.getInput()).ingredient.isGasEqual((GasStack)ingredients[0])) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    @Override
    public void addGuiElements() {
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public GasStack inputStack;
        public PositionedStack outputStack;

        public PositionedStack getResult() {
            return this.outputStack;
        }

        public CachedIORecipe(GasStack input, ItemStack output) {
            super((TemplateRecipeHandler)ChemicalCrystallizerRecipeHandler.this);
            this.inputStack = input;
            this.outputStack = new PositionedStack((Object)output, 131 - xOffset, 57 - yOffset);
        }

        public CachedIORecipe(CrystallizerRecipe recipe) {
            this(((GasInput)recipe.getInput()).ingredient, ((ItemStackOutput)recipe.getOutput()).output);
        }
    }
}

