/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.IEnergizedItem;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.Tier;
import mekanism.common.Upgrade;
import mekanism.common.base.IFactory;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ISustainedTank;
import mekanism.common.base.ITierItem;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.BlockMachine;
import mekanism.common.integration.IC2ItemManager;
import mekanism.common.inventory.InventoryPersonalChest;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2")})
public class ItemBlockMachine
extends ItemBlock
implements IEnergizedItem,
ISpecialElectricItem,
IFactory,
ISustainedInventory,
ISustainedTank,
IEnergyContainerItem,
IFluidContainerItem,
ITierItem,
ISecurityItem {
    public Block metaBlock;

    public ItemBlockMachine(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.setNoRepair();
        this.func_77625_d(1);
    }

    public int func_77647_b(int i) {
        return i;
    }

    public String func_77667_c(ItemStack itemstack) {
        if (BlockMachine.MachineType.get(itemstack) != null) {
            return this.func_77658_a() + "." + BlockMachine.MachineType.get((ItemStack)itemstack).name;
        }
        return "null";
    }

    public String func_77653_i(ItemStack itemstack) {
        BlockMachine.MachineType type = BlockMachine.MachineType.get(itemstack);
        if (type == BlockMachine.MachineType.BASIC_FACTORY || type == BlockMachine.MachineType.ADVANCED_FACTORY || type == BlockMachine.MachineType.ELITE_FACTORY) {
            Tier.BaseTier tier;
            Tier.BaseTier baseTier = type == BlockMachine.MachineType.BASIC_FACTORY ? Tier.BaseTier.BASIC : (tier = type == BlockMachine.MachineType.ADVANCED_FACTORY ? Tier.BaseTier.ADVANCED : Tier.BaseTier.ELITE);
            if (StatCollector.func_94522_b((String)("tile." + tier.getName() + IFactory.RecipeType.values()[this.getRecipeType(itemstack)].getUnlocalizedName() + "Factory"))) {
                return LangUtils.localize("tile." + tier.getName() + IFactory.RecipeType.values()[this.getRecipeType(itemstack)].getUnlocalizedName() + "Factory");
            }
            return tier.getLocalizedName() + " " + IFactory.RecipeType.values()[this.getRecipeType(itemstack)].getLocalizedName() + " " + super.func_77653_i(itemstack);
        }
        if (type == BlockMachine.MachineType.FLUID_TANK) {
            return LangUtils.localize("tile.FluidTank" + this.getBaseTier(itemstack).getName() + ".name");
        }
        return super.func_77653_i(itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        BlockMachine.MachineType type = BlockMachine.MachineType.get(itemstack);
        if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey)) {
            if (type == BlockMachine.MachineType.FLUID_TANK) {
                FluidStack fluidStack = this.getFluidStack(itemstack);
                if (fluidStack != null) {
                    list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localizeFluidStack(fluidStack) + ": " + (Object)((Object)EnumColor.GREY) + this.getFluidStack((Object[])new Object[]{itemstack}).amount + "mB");
                } else {
                    list.add((Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.empty") + ".");
                }
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + Tier.FluidTankTier.values()[this.getBaseTier((ItemStack)itemstack).ordinal()].storage + " mB");
            }
            list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.INDIGO) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails") + ".");
            list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.and") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.modeSwitchKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDesc") + ".");
        } else if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.modeSwitchKey)) {
            FluidStack fluidStack;
            if (this.hasSecurity(itemstack)) {
                list.add(SecurityUtils.getOwnerDisplay(entityplayer.func_70005_c_(), this.getOwner(itemstack)));
                list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.security") + ": " + SecurityUtils.getSecurityDisplay(itemstack, Side.CLIENT));
                if (SecurityUtils.isOverridden(itemstack, Side.CLIENT)) {
                    list.add((Object)((Object)EnumColor.RED) + "(" + LangUtils.localize("gui.overridden") + ")");
                }
            }
            if (type == BlockMachine.MachineType.BASIC_FACTORY || type == BlockMachine.MachineType.ADVANCED_FACTORY || type == BlockMachine.MachineType.ELITE_FACTORY) {
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.recipeType") + ": " + (Object)((Object)EnumColor.GREY) + IFactory.RecipeType.values()[this.getRecipeType(itemstack)].getLocalizedName());
            }
            if (type == BlockMachine.MachineType.FLUID_TANK) {
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.portableTank.bucketMode") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getBucketMode(itemstack)));
            }
            if (type.isElectric) {
                list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + LangUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergy(itemstack)));
            }
            if (this.hasTank(itemstack) && type != BlockMachine.MachineType.FLUID_TANK && (fluidStack = this.getFluidStack(itemstack)) != null) {
                list.add((Object)((Object)EnumColor.PINK) + LangUtils.localizeFluidStack(fluidStack) + ": " + (Object)((Object)EnumColor.GREY) + this.getFluidStack((Object[])new Object[]{itemstack}).amount + "mB");
            }
            if (type != BlockMachine.MachineType.CHARGEPAD && type != BlockMachine.MachineType.LOGISTICAL_SORTER) {
                list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localize("tooltip.inventory") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
            }
            if (type.supportsUpgrades && itemstack.field_77990_d != null && itemstack.field_77990_d.func_74764_b("upgrades")) {
                Map<Upgrade, Integer> upgrades = Upgrade.buildMap(itemstack.field_77990_d);
                for (Map.Entry<Upgrade, Integer> entry : upgrades.entrySet()) {
                    list.add((Object)((Object)entry.getKey().getColor()) + "- " + entry.getKey().getName() + (entry.getKey().canMultiply() ? ": " + (Object)((Object)EnumColor.GREY) + "x" + entry.getValue() : ""));
                }
            }
        } else {
            list.addAll(MekanismUtils.splitTooltip(type.getDescription(), itemstack));
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        BlockMachine.MachineType type = BlockMachine.MachineType.get(stack);
        if (type == BlockMachine.MachineType.FLUID_TANK && this.getBucketMode(stack)) {
            return false;
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place = true;
        BlockMachine.MachineType type = BlockMachine.MachineType.get(stack);
        if (type == BlockMachine.MachineType.DIGITAL_MINER) {
            for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                for (int yPos = y; yPos <= y + 1; ++yPos) {
                    for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                        Block b = world.func_147439_a(xPos, yPos, zPos);
                        if (yPos <= 255 && b.isReplaceable((IBlockAccess)world, xPos, yPos, zPos)) continue;
                        place = false;
                    }
                }
            }
        } else if (!(type != BlockMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR && type != BlockMachine.MachineType.SEISMIC_VIBRATOR || y + 1 <= 255 && world.func_147439_a(x, y + 1, z).isReplaceable((IBlockAccess)world, x, y + 1, z))) {
            place = false;
        }
        if (place && super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
            if (tileEntity instanceof TileEntityFluidTank) {
                TileEntityFluidTank tile = (TileEntityFluidTank)tileEntity;
                tile.tier = Tier.FluidTankTier.values()[this.getBaseTier(stack).ordinal()];
                tile.fluidTank.setCapacity(tile.tier.storage);
            }
            if (tileEntity instanceof ISecurityTile) {
                ISecurityTile security = (ISecurityTile)((Object)tileEntity);
                security.getSecurity().setOwner(this.getOwner(stack));
                if (this.hasSecurity(stack)) {
                    security.getSecurity().setMode(this.getSecurity(stack));
                }
                if (this.getOwner(stack) == null) {
                    security.getSecurity().setOwner(player.func_70005_c_());
                }
            }
            if (tileEntity instanceof IUpgradeTile && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("upgrades")) {
                ((IUpgradeTile)((Object)tileEntity)).getComponent().read(stack.field_77990_d);
            }
            if (tileEntity instanceof ISideConfiguration) {
                ISideConfiguration config = (ISideConfiguration)((Object)tileEntity);
                if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("sideDataStored")) {
                    config.getConfig().read(stack.field_77990_d);
                }
            }
            if (tileEntity instanceof ISustainedData && stack.field_77990_d != null) {
                ((ISustainedData)((Object)tileEntity)).readSustainedData(stack);
            }
            if (tileEntity instanceof IRedstoneControl && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("controlType")) {
                ((IRedstoneControl)((Object)tileEntity)).setControlType(IRedstoneControl.RedstoneControl.values()[stack.field_77990_d.func_74762_e("controlType")]);
            }
            if (tileEntity instanceof TileEntityFactory) {
                IFactory.RecipeType recipeType;
                TileEntityFactory factory = (TileEntityFactory)tileEntity;
                factory.recipeType = recipeType = IFactory.RecipeType.values()[this.getRecipeType(stack)];
                factory.upgradeComponent.setSupported(Upgrade.GAS, recipeType.fuelEnergyUpgrades());
                factory.secondaryEnergyPerTick = factory.getSecondaryEnergyPerTick(recipeType);
                world.func_147459_d(x, y, z, tileEntity.func_145838_q());
            }
            if (tileEntity instanceof ISustainedTank && this.hasTank(stack) && this.getFluidStack(stack) != null) {
                ((ISustainedTank)((Object)tileEntity)).setFluidStack(this.getFluidStack(stack), new Object[0]);
            }
            if (tileEntity instanceof ISustainedInventory) {
                ((ISustainedInventory)((Object)tileEntity)).setInventory(this.getInventory(stack), new Object[0]);
            }
            if (tileEntity instanceof TileEntityElectricBlock) {
                ((TileEntityElectricBlock)tileEntity).electricityStored = this.getEnergy(stack);
            }
            return true;
        }
        return false;
    }

    @Optional.Method(modid="IC2")
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Optional.Method(modid="IC2")
    public double getMaxCharge(ItemStack itemStack) {
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public int getTier(ItemStack itemStack) {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public double getTransferLimit(ItemStack itemStack) {
        return 0.0;
    }

    public boolean tryPlaceContainedLiquid(World world, ItemStack itemstack, int x, int y, int z) {
        boolean flag;
        if (this.getFluidStack(itemstack) == null || !this.getFluidStack(itemstack).getFluid().canBePlacedInWorld()) {
            return false;
        }
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        boolean bl = flag = !material.func_76220_a();
        if (!world.func_147437_c(x, y, z) && !flag) {
            return false;
        }
        if (world.field_73011_w.field_76575_d && this.getFluidStack(itemstack).getFluid() == FluidRegistry.WATER) {
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_72869_a("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            if (!world.field_72995_K && flag && !material.func_76224_d()) {
                world.func_147480_a(x, y, z, true);
            }
            world.func_147465_d(x, y, z, MekanismUtils.getFlowingBlock(this.getFluidStack(itemstack).getFluid()), 0, 3);
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        BlockMachine.MachineType type = BlockMachine.MachineType.get(itemstack);
        if (BlockMachine.MachineType.get(itemstack) == BlockMachine.MachineType.PERSONAL_CHEST) {
            if (!world.field_72995_K) {
                if (this.getOwner(itemstack) == null) {
                    this.setOwner(itemstack, entityplayer.func_70005_c_());
                }
                if (SecurityUtils.canAccess(entityplayer, itemstack)) {
                    InventoryPersonalChest inventory = new InventoryPersonalChest(entityplayer);
                    MekanismUtils.openPersonalChestGui((EntityPlayerMP)entityplayer, null, (IInventory)inventory, false);
                } else {
                    SecurityUtils.displayNoAccess(entityplayer);
                }
            }
        } else if (type == BlockMachine.MachineType.FLUID_TANK && this.getBucketMode(itemstack)) {
            if (SecurityUtils.canAccess(entityplayer, itemstack)) {
                MovingObjectPosition pos = this.func_77621_a(world, entityplayer, !entityplayer.func_70093_af());
                if (pos == null) {
                    return itemstack;
                }
                if (pos.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    Coord4D coord = new Coord4D(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, world.field_73011_w.field_76574_g);
                    if (!world.func_72962_a(entityplayer, coord.xCoord, coord.yCoord, coord.zCoord)) {
                        return itemstack;
                    }
                    if (!entityplayer.func_70093_af()) {
                        if (!entityplayer.func_82247_a(coord.xCoord, coord.yCoord, coord.zCoord, pos.field_72310_e, itemstack)) {
                            return itemstack;
                        }
                        FluidStack fluid = MekanismUtils.getFluid(world, coord, false);
                        if (fluid != null && (this.getFluidStack(itemstack) == null || this.getFluidStack(itemstack).isFluidEqual(fluid))) {
                            int needed = this.getCapacity(itemstack) - (this.getFluidStack(itemstack) != null ? this.getFluidStack((Object[])new Object[]{itemstack}).amount : 0);
                            if (fluid.amount > needed) {
                                return itemstack;
                            }
                            if (this.getFluidStack(itemstack) == null) {
                                this.setFluidStack(fluid, itemstack);
                            } else {
                                FluidStack newStack = this.getFluidStack(itemstack);
                                newStack.amount += fluid.amount;
                                this.setFluidStack(newStack, itemstack);
                            }
                            world.func_147468_f(coord.xCoord, coord.yCoord, coord.zCoord);
                        }
                    } else {
                        FluidStack stored = this.getFluidStack(itemstack);
                        if (stored == null || stored.amount < 1000) {
                            return itemstack;
                        }
                        Coord4D trans = coord.getFromSide(ForgeDirection.getOrientation((int)pos.field_72310_e));
                        if (!entityplayer.func_82247_a(trans.xCoord, trans.yCoord, trans.zCoord, pos.field_72310_e, itemstack)) {
                            return itemstack;
                        }
                        if (this.tryPlaceContainedLiquid(world, itemstack, trans.xCoord, trans.yCoord, trans.zCoord) && !entityplayer.field_71075_bZ.field_75098_d) {
                            FluidStack newStack = stored.copy();
                            newStack.amount -= 1000;
                            this.setFluidStack((FluidStack)(newStack.amount > 0 ? newStack : null), itemstack);
                        }
                    }
                }
                return itemstack;
            }
            SecurityUtils.displayNoAccess(entityplayer);
        }
        return itemstack;
    }

    @Override
    public int getRecipeType(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0;
        }
        return itemStack.field_77990_d.func_74762_e("recipeType");
    }

    @Override
    public void setRecipeType(int type, ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74768_a("recipeType", type);
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("Items", (NBTBase)nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            return itemStack.field_77990_d.func_150295_c("Items", 10);
        }
        return null;
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            if (fluidStack == null || fluidStack.amount == 0 || fluidStack.getFluidID() == 0) {
                itemStack.field_77990_d.func_82580_o("fluidTank");
            } else {
                itemStack.field_77990_d.func_74782_a("fluidTank", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
            }
        }
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            if (itemStack.field_77990_d.func_74764_b("fluidTank")) {
                return FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("fluidTank"));
            }
        }
        return null;
    }

    @Override
    public boolean hasTank(Object ... data) {
        if (!(data[0] instanceof ItemStack) || !(((ItemStack)data[0]).func_77973_b() instanceof ISustainedTank)) {
            return false;
        }
        BlockMachine.MachineType type = BlockMachine.MachineType.get((ItemStack)data[0]);
        return type == BlockMachine.MachineType.ELECTRIC_PUMP || type == BlockMachine.MachineType.FLUID_TANK || type == BlockMachine.MachineType.FLUIDIC_PLENISHER;
    }

    public void setBucketMode(ItemStack itemStack, boolean bucketMode) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74757_a("bucketMode", bucketMode);
    }

    public boolean getBucketMode(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return false;
        }
        return itemStack.field_77990_d.func_74767_n("bucketMode");
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (itemStack.field_77990_d == null || !BlockMachine.MachineType.get((ItemStack)itemStack).isElectric) {
            return 0.0;
        }
        return itemStack.field_77990_d.func_74769_h("electricity");
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (!BlockMachine.MachineType.get((ItemStack)itemStack).isElectric) {
            return;
        }
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double electricityStored = Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0);
        itemStack.field_77990_d.func_74780_a("electricity", electricityStored);
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return MekanismUtils.getMaxEnergy(itemStack, BlockMachine.MachineType.get((Block)Block.func_149634_a((Item)itemStack.func_77973_b()), (int)itemStack.func_77960_j()).baseEnergy);
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return BlockMachine.MachineType.get((ItemStack)itemStack).isElectric;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Override
    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min((double)energy * MekanismConfig.general.FROM_TE, energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return (int)Math.round(toReceive * MekanismConfig.general.TO_TE);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min((double)energy * MekanismConfig.general.FROM_TE, energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return (int)Math.round(toSend * MekanismConfig.general.TO_TE);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ItemStack theItem) {
        return (int)(this.getEnergy(theItem) * MekanismConfig.general.TO_TE);
    }

    @Override
    public int getMaxEnergyStored(ItemStack theItem) {
        return (int)(this.getMaxEnergy(theItem) * MekanismConfig.general.TO_TE);
    }

    @Optional.Method(modid="IC2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager(this);
    }

    @Optional.Method(modid="IC2")
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Optional.Method(modid="IC2")
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public FluidStack getFluid(ItemStack container) {
        return this.getFluidStack(container);
    }

    public int getCapacity(ItemStack container) {
        return Tier.FluidTankTier.values()[this.getBaseTier((ItemStack)container).ordinal()].storage;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (BlockMachine.MachineType.get(container) == BlockMachine.MachineType.FLUID_TANK && resource != null) {
            FluidStack stored = this.getFluidStack(container);
            if (stored != null && stored.getFluid() != resource.getFluid()) {
                return 0;
            }
            int toFill = stored == null ? Math.min(resource.amount, this.getCapacity(container)) : Math.min(resource.amount, this.getCapacity(container) - stored.amount);
            if (doFill) {
                int fillAmount = toFill + (stored == null ? 0 : stored.amount);
                this.setFluidStack(PipeUtils.copy(resource, (stored != null ? stored.amount : 0) + toFill), container);
            }
            return toFill;
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        FluidStack stored;
        if (BlockMachine.MachineType.get(container) == BlockMachine.MachineType.FLUID_TANK && (stored = this.getFluidStack(container)) != null) {
            FluidStack toDrain = PipeUtils.copy(stored, Math.min(stored.amount, maxDrain));
            if (doDrain) {
                stored.amount -= toDrain.amount;
                this.setFluidStack((FluidStack)(stored.amount > 0 ? stored : null), container);
            }
            return toDrain;
        }
        return null;
    }

    @Override
    public Tier.BaseTier getBaseTier(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return Tier.BaseTier.BASIC;
        }
        return Tier.BaseTier.values()[itemstack.field_77990_d.func_74762_e("tier")];
    }

    @Override
    public void setBaseTier(ItemStack itemstack, Tier.BaseTier tier) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.field_77990_d.func_74768_a("tier", tier.ordinal());
    }

    @Override
    public String getOwner(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("owner")) {
            return stack.field_77990_d.func_74779_i("owner");
        }
        return null;
    }

    @Override
    public void setOwner(ItemStack stack, String owner) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (owner == null || owner.isEmpty()) {
            stack.field_77990_d.func_82580_o("owner");
            return;
        }
        stack.field_77990_d.func_74778_a("owner", owner);
    }

    @Override
    public ISecurityTile.SecurityMode getSecurity(ItemStack stack) {
        if (stack.field_77990_d == null) {
            return ISecurityTile.SecurityMode.PUBLIC;
        }
        return ISecurityTile.SecurityMode.values()[stack.field_77990_d.func_74762_e("security")];
    }

    @Override
    public void setSecurity(ItemStack stack, ISecurityTile.SecurityMode mode) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74768_a("security", mode.ordinal());
    }

    @Override
    public boolean hasSecurity(ItemStack stack) {
        BlockMachine.MachineType type = BlockMachine.MachineType.get(stack);
        return type != BlockMachine.MachineType.LASER && type != BlockMachine.MachineType.CHARGEPAD && type != BlockMachine.MachineType.TELEPORTER && type != BlockMachine.MachineType.QUANTUM_ENTANGLOPORTER;
    }

    @Override
    public boolean hasOwner(ItemStack stack) {
        return this.hasSecurity(stack);
    }
}

