/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.common.HashList;
import mekanism.common.InventoryNetwork;
import mekanism.common.Mekanism;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.base.ITransporterTile;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.multipart.MultipartTransmitter;
import mekanism.common.multipart.PartLogisticalTransporter;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class MultipartTransporter
extends MultipartTransmitter<IInventory, InventoryNetwork>
implements ILogisticalTransporter {
    public HashList<TransporterStack> transit = new HashList();
    public EnumColor color;
    public Set<TransporterStack> needsSync = new HashSet<TransporterStack>();

    public MultipartTransporter(PartLogisticalTransporter multiPart) {
        super(multiPart);
    }

    public void update() {
        if (this.world().field_72995_K) {
            for (TransporterStack stack : this.transit) {
                if (stack == null) continue;
                stack.progress = Math.min(100, stack.progress + this.getPart().tier.speed);
            }
        } else {
            if (this.getTransmitterNetwork() == null) {
                return;
            }
            HashSet<TransporterStack> remove = new HashSet<TransporterStack>();
            this.getPart().pullItems();
            for (TransporterStack stack : this.transit) {
                if (!(stack.initiatedPath || stack.itemStack != null && this.recalculate(stack, null))) {
                    remove.add(stack);
                    continue;
                }
                stack.progress += this.getPart().tier.speed;
                if (stack.progress > 100) {
                    Coord4D prevSet = null;
                    if (stack.hasPath()) {
                        int currentIndex = stack.getPath().indexOf(this.coord());
                        if (currentIndex == 0) {
                            remove.add(stack);
                            continue;
                        }
                        Coord4D next = stack.getPath().get(currentIndex - 1);
                        if (!stack.isFinal(this)) {
                            if (next != null && stack.canInsertToTransporter(stack.getNext(this).getTileEntity((IBlockAccess)this.world()), ForgeDirection.getOrientation((int)stack.getSide(this)))) {
                                ITransporterTile nextTile = (ITransporterTile)next.getTileEntity((IBlockAccess)this.world());
                                nextTile.getTransmitter().entityEntering(stack, stack.progress % 100);
                                remove.add(stack);
                                continue;
                            }
                            if (next != null) {
                                prevSet = next;
                            }
                        } else if (stack.pathType != TransporterStack.Path.NONE && next != null && next.getTileEntity((IBlockAccess)this.world()) instanceof IInventory) {
                            this.needsSync.add(stack);
                            IInventory inventory = (IInventory)next.getTileEntity((IBlockAccess)this.world());
                            if (inventory != null) {
                                ItemStack rejected = InventoryUtils.putStackInInventory(inventory, stack.itemStack, stack.getSide(this), stack.pathType == TransporterStack.Path.HOME);
                                if (rejected == null) {
                                    TransporterManager.remove(stack);
                                    remove.add(stack);
                                    continue;
                                }
                                this.needsSync.add(stack);
                                stack.itemStack = rejected;
                                prevSet = next;
                            }
                        }
                    }
                    if (!this.recalculate(stack, prevSet)) {
                        remove.add(stack);
                        continue;
                    }
                    if (prevSet != null) {
                        stack.progress = 0;
                        continue;
                    }
                    stack.progress = 50;
                    continue;
                }
                if (stack.progress != 50) continue;
                if (stack.isFinal(this)) {
                    if (!(stack.pathType != TransporterStack.Path.DEST || this.checkSideForInsert(stack) && InventoryUtils.canInsert(stack.getDest().getTileEntity((IBlockAccess)this.world()), stack.color, stack.itemStack, stack.getSide(this), false))) {
                        if (this.recalculate(stack, null)) continue;
                        remove.add(stack);
                        continue;
                    }
                    if (!(stack.pathType != TransporterStack.Path.HOME || this.checkSideForInsert(stack) && InventoryUtils.canInsert(stack.getDest().getTileEntity((IBlockAccess)this.world()), stack.color, stack.itemStack, stack.getSide(this), true))) {
                        if (this.recalculate(stack, null)) continue;
                        remove.add(stack);
                        continue;
                    }
                    if (stack.pathType != TransporterStack.Path.NONE || this.recalculate(stack, null)) continue;
                    remove.add(stack);
                    continue;
                }
                TileEntity next = stack.getNext(this).getTileEntity((IBlockAccess)this.world());
                boolean recalculate = false;
                if (!stack.canInsertToTransporter(next, ForgeDirection.getOrientation((int)stack.getSide(this)))) {
                    recalculate = true;
                }
                if (!recalculate || this.recalculate(stack, null)) continue;
                remove.add(stack);
            }
            for (TransporterStack stack : remove) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(this.coord(), this.getPart().getSyncPacket(stack, true)), new Range4D(this.coord()));
                this.transit.remove(stack);
                MekanismUtils.saveChunk((TileEntity)this.getPart().tile());
            }
            for (TransporterStack stack : this.needsSync) {
                if (!this.transit.contains(stack)) continue;
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(this.coord(), this.getPart().getSyncPacket(stack, false)), new Range4D(this.coord()));
            }
            this.needsSync.clear();
        }
    }

    private boolean checkSideForInsert(TransporterStack stack) {
        ForgeDirection side = ForgeDirection.getOrientation((int)stack.getSide(this));
        return this.getPart().getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL || this.getPart().getConnectionType(side) == PartSidedPipe.ConnectionType.PUSH;
    }

    private boolean recalculate(TransporterStack stack, Coord4D from) {
        this.needsSync.add(stack);
        if (stack.pathType != TransporterStack.Path.NONE) {
            if (!TransporterManager.didEmit(stack.itemStack, stack.recalculatePath(this, 0)) && !stack.calculateIdle(this)) {
                TransporterUtils.drop(this, stack);
                return false;
            }
        } else if (!stack.calculateIdle(this)) {
            TransporterUtils.drop(this, stack);
            return false;
        }
        if (from != null) {
            stack.originalLocation = from;
        }
        return true;
    }

    @Override
    public ItemStack insert(Coord4D original, ItemStack itemStack, EnumColor color, boolean doEmit, int min) {
        return this.insert_do(original, itemStack, color, doEmit, min, false);
    }

    private ItemStack insert_do(Coord4D original, ItemStack itemStack, EnumColor color, boolean doEmit, int min, boolean force) {
        ForgeDirection from = this.coord().sideDifference(original).getOpposite();
        TransporterStack stack = new TransporterStack();
        stack.itemStack = itemStack;
        stack.originalLocation = original;
        stack.homeLocation = original;
        stack.color = color;
        if (force && !this.canReceiveFrom(original.getTileEntity((IBlockAccess)this.world()), from) || !stack.canInsertToTransporter(this, from)) {
            return itemStack;
        }
        ItemStack rejected = stack.recalculatePath(this, min);
        if (TransporterManager.didEmit(stack.itemStack, rejected)) {
            stack.itemStack = TransporterManager.getToUse(stack.itemStack, rejected);
            if (doEmit) {
                this.transit.add(stack);
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(this.coord(), this.getPart().getSyncPacket(stack, false)), new Range4D(this.coord()));
                MekanismUtils.saveChunk((TileEntity)this.getPart().tile());
            }
            return rejected;
        }
        return itemStack;
    }

    @Override
    public ItemStack insertRR(TileEntityLogisticalSorter outputter, ItemStack itemStack, EnumColor color, boolean doEmit, int min) {
        ForgeDirection from = this.coord().sideDifference(Coord4D.get(outputter)).getOpposite();
        TransporterStack stack = new TransporterStack();
        stack.itemStack = itemStack;
        stack.originalLocation = Coord4D.get(outputter);
        stack.homeLocation = Coord4D.get(outputter);
        stack.color = color;
        if (!this.canReceiveFrom(outputter, from) || !stack.canInsertToTransporter(this, from)) {
            return itemStack;
        }
        ItemStack rejected = stack.recalculateRRPath(outputter, this, min);
        if (TransporterManager.didEmit(stack.itemStack, rejected)) {
            stack.itemStack = TransporterManager.getToUse(stack.itemStack, rejected);
            if (doEmit) {
                this.transit.add(stack);
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(this.coord(), this.getPart().getSyncPacket(stack, false)), new Range4D(this.coord()));
                MekanismUtils.saveChunk((TileEntity)this.getPart().tile());
            }
            return rejected;
        }
        return itemStack;
    }

    @Override
    public void entityEntering(TransporterStack stack, int progress) {
        stack.progress = progress;
        this.transit.add(stack);
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(this.coord(), this.getPart().getSyncPacket(stack, false)), new Range4D(this.coord()));
        MekanismUtils.saveChunk((TileEntity)this.getPart().tile());
    }

    @Override
    public EnumColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(EnumColor c) {
        this.color = c;
    }

    @Override
    public boolean canEmitTo(TileEntity tileEntity, ForgeDirection side) {
        if (!this.getPart().canConnect(side)) {
            return false;
        }
        return this.getPart().getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL || this.getPart().getConnectionType(side) == PartSidedPipe.ConnectionType.PUSH;
    }

    @Override
    public boolean canReceiveFrom(TileEntity tileEntity, ForgeDirection side) {
        if (!this.getPart().canConnect(side)) {
            return false;
        }
        return this.getPart().getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL;
    }

    @Override
    public double getCost() {
        return this.getPart().getCost();
    }

    @Override
    public boolean canConnectMutual(ForgeDirection side) {
        return this.getPart().canConnectMutual(side);
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        return this.getPart().canConnect(side);
    }

    public PartLogisticalTransporter getPart() {
        return (PartLogisticalTransporter)this.containingPart;
    }
}

