/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.api.util.StackUtils;
import mekanism.common.LaserManager;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLaserTractorBeam
extends TileEntityContainerBlock
implements ILaserReceptor,
ISecurityTile {
    public static final double MAX_ENERGY = 5.0E9;
    public double collectedEnergy = 0.0;
    public double lastFired = 0.0;
    public boolean on = false;
    public Coord4D digging;
    public double diggingProgress;
    public static int[] availableSlotIDs = InventoryUtils.getIntRange(0, 26);
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

    public TileEntityLaserTractorBeam() {
        super("LaserTractorBeam");
        this.inventory = new ItemStack[27];
    }

    @Override
    public void receiveLaserEnergy(double energy, ForgeDirection side) {
        this.setEnergy(this.getEnergy() + energy);
    }

    @Override
    public boolean canLasersDig() {
        return false;
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            if (this.on) {
                Coord4D hitCoord;
                MovingObjectPosition mop = LaserManager.fireLaserClient(this, ForgeDirection.getOrientation((int)this.facing), this.lastFired, this.field_145850_b);
                Coord4D coord4D = hitCoord = mop == null ? null : new Coord4D(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, this.field_145850_b.field_73011_w.field_76574_g);
                if (hitCoord == null || !hitCoord.equals(this.digging)) {
                    this.digging = hitCoord;
                    this.diggingProgress = 0.0;
                }
                if (hitCoord != null) {
                    Block blockHit = hitCoord.getBlock((IBlockAccess)this.field_145850_b);
                    TileEntity tileHit = hitCoord.getTileEntity((IBlockAccess)this.field_145850_b);
                    float hardness = blockHit.func_149712_f(this.field_145850_b, hitCoord.xCoord, hitCoord.yCoord, hitCoord.zCoord);
                    if (!(hardness < 0.0f || tileHit instanceof ILaserReceptor && !((ILaserReceptor)tileHit).canLasersDig())) {
                        this.diggingProgress += this.lastFired;
                        if (this.diggingProgress < (double)hardness * MekanismConfig.general.laserEnergyNeededPerHardness) {
                            Mekanism.proxy.addHitEffects(hitCoord, mop);
                        }
                    }
                }
            }
        } else if (this.collectedEnergy > 0.0) {
            Coord4D hitCoord;
            double firing = this.collectedEnergy;
            if (!this.on || firing != this.lastFired) {
                this.on = true;
                this.lastFired = firing;
                Mekanism.packetHandler.sendToAllAround(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), Coord4D.get(this).getTargetPoint(50.0));
            }
            LaserManager.LaserInfo info = LaserManager.fireLaser(this, ForgeDirection.getOrientation((int)this.facing), firing, this.field_145850_b);
            Coord4D coord4D = hitCoord = info.movingPos == null ? null : new Coord4D(info.movingPos.field_72311_b, info.movingPos.field_72312_c, info.movingPos.field_72309_d, this.field_145850_b.field_73011_w.field_76574_g);
            if (hitCoord == null || !hitCoord.equals(this.digging)) {
                this.digging = hitCoord;
                this.diggingProgress = 0.0;
            }
            if (hitCoord != null) {
                Block blockHit = hitCoord.getBlock((IBlockAccess)this.field_145850_b);
                TileEntity tileHit = hitCoord.getTileEntity((IBlockAccess)this.field_145850_b);
                float hardness = blockHit.func_149712_f(this.field_145850_b, hitCoord.xCoord, hitCoord.yCoord, hitCoord.zCoord);
                if (!(hardness < 0.0f || tileHit instanceof ILaserReceptor && !((ILaserReceptor)tileHit).canLasersDig())) {
                    this.diggingProgress += firing;
                    if (this.diggingProgress >= (double)hardness * MekanismConfig.general.laserEnergyNeededPerHardness) {
                        List<ItemStack> drops = LaserManager.breakBlock(hitCoord, false, this.field_145850_b);
                        if (drops != null) {
                            this.receiveDrops(drops);
                        }
                        this.diggingProgress = 0.0;
                    }
                }
            }
            this.setEnergy(this.getEnergy() - firing);
        } else if (this.on) {
            this.on = false;
            this.diggingProgress = 0.0;
            Mekanism.packetHandler.sendToAllAround(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), Coord4D.get(this).getTargetPoint(50.0));
        }
    }

    public void setEnergy(double energy) {
        this.collectedEnergy = Math.max(0.0, Math.min(energy, 5.0E9));
    }

    public double getEnergy() {
        return this.collectedEnergy;
    }

    public void receiveDrops(List<ItemStack> drops) {
        block0: for (ItemStack drop : drops) {
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] == null) {
                    this.inventory[i] = drop;
                    continue block0;
                }
                ItemStack slot = this.inventory[i];
                if (!StackUtils.equalsWildcardWithNBT(slot, drop)) continue;
                int change = Math.min(drop.field_77994_a, slot.func_77976_d() - slot.field_77994_a);
                slot.field_77994_a += change;
                drop.field_77994_a -= change;
                if (drop.field_77994_a <= 0) continue block0;
            }
            this.dropItem(drop);
        }
    }

    public void dropItem(ItemStack stack) {
        EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, stack);
        item.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * 0.05;
        item.field_70181_x = this.field_145850_b.field_73012_v.nextGaussian() * 0.05 + 0.2;
        item.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * 0.05;
        item.field_145804_b = 10;
        this.field_145850_b.func_72838_d((Entity)item);
    }

    @Override
    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return availableSlotIDs;
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.on);
        data.add(this.collectedEnergy);
        data.add(this.lastFired);
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.on = dataStream.readBoolean();
            this.collectedEnergy = dataStream.readDouble();
            this.lastFired = dataStream.readDouble();
        }
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }
}

