/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.item;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyReceiver;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.energy.subgrid.SubTileEnergyRedstone;
import cofh.thermaldynamics.duct.item.TileItemDuctPowered;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileItemDuctFlux
extends TileItemDuctPowered {
    public final SubTileEnergyRedstone redstoneEnergy = new SubTileEnergyRedstone(this);
    boolean isSubNode = false;
    IEnergyReceiver[] energyCache;

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.checkSubNode();
    }

    public TileItemDuctFlux() {
        this.setSubEnergy(this.redstoneEnergy);
    }

    public void checkSubNode() {
        boolean bl = false;
        if (this.cachesExist()) {
            for (int i = 0; i < 6; ++i) {
                if (this.energyCache[i] == null) continue;
                bl = true;
                break;
            }
        }
        if (this.isSubNode != bl) {
            this.isSubNode = bl;
            if (this.energy.energyGrid != null) {
                this.energy.energyGrid.addBlock(this.energy);
            }
        }
    }

    @Override
    public boolean isSubNode() {
        return this.isSubNode;
    }

    @Override
    public void onNeighborTileChange(int n, int n2, int n3) {
        super.onNeighborTileChange(n, n2, n3);
        this.checkSubNode();
    }

    @Override
    public boolean tickPass(int n) {
        if (!super.tickPass(n)) {
            return false;
        }
        if (n == 0 && this.isSubNode && this.redstoneEnergy.internalGrid != null) {
            int n2 = this.redstoneEnergy.internalGrid.toDistribute;
            this.redstoneEnergy.internalGrid.myStorage.modifyEnergyStored(-this.transmitEnergy(n2));
        }
        return true;
    }

    public int transmitEnergy(int n) {
        byte by;
        int n2 = 0;
        if (!this.cachesExist()) {
            return 0;
        }
        for (by = this.internalSideCounter; by < this.neighborTypes.length && n2 < n; by = (byte)(by + 1)) {
            if (this.connectionTypes[by] != TileTDBase.ConnectionTypes.NORMAL || this.energyCache[by] == null) continue;
            if (this.energyCache[by].canConnectEnergy(ForgeDirection.VALID_DIRECTIONS[by ^ 1])) {
                n2 += this.energyCache[by].receiveEnergy(ForgeDirection.VALID_DIRECTIONS[by ^ 1], n - n2, false);
            }
            if (n2 < n) continue;
            this.tickInternalSideCounter(by + 1);
            break;
        }
        for (by = 0; by < this.internalSideCounter && n2 < n; by = (byte)(by + 1)) {
            if (this.connectionTypes[by] != TileTDBase.ConnectionTypes.NORMAL || this.energyCache[by] == null) continue;
            if (this.energyCache[by].canConnectEnergy(ForgeDirection.VALID_DIRECTIONS[by ^ 1])) {
                n2 += this.energyCache[by].receiveEnergy(ForgeDirection.VALID_DIRECTIONS[by ^ 1], n - n2, false);
            }
            if (n2 < n) continue;
            this.tickInternalSideCounter(by + 1);
            break;
        }
        return n2;
    }

    @Override
    public void createCaches() {
        super.createCaches();
        this.energyCache = new IEnergyReceiver[6];
    }

    @Override
    public void clearCache(int n) {
        super.clearCache(n);
        this.energyCache[n] = null;
    }

    @Override
    public void cacheImportant(TileEntity tileEntity, int n) {
        super.cacheImportant(tileEntity, n);
        if (tileEntity instanceof IEnergyReceiver) {
            this.energyCache[n] = (IEnergyReceiver)tileEntity;
        }
    }

    @Override
    public void cacheInputTile(TileEntity tileEntity, int n) {
        super.cacheInputTile(tileEntity, n);
        if (tileEntity instanceof IEnergyReceiver) {
            this.energyCache[n] = (IEnergyReceiver)tileEntity;
        }
    }

    @Override
    public void cacheStructural(TileEntity tileEntity, int n) {
        if (tileEntity instanceof IEnergyReceiver) {
            this.energyCache[n] = (IEnergyReceiver)tileEntity;
        }
        this.isOutput = true;
    }

    @Override
    public boolean isStructureTile(TileEntity tileEntity, int n) {
        return tileEntity instanceof IEnergyConnection && ((IEnergyConnection)tileEntity).canConnectEnergy(ForgeDirection.getOrientation((int)(n ^ 1)));
    }
}

