/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item;

import cofh.core.item.tool.ItemBowAdv;
import cofh.core.item.tool.ItemFishingRodAdv;
import cofh.core.item.tool.ItemShearsAdv;
import cofh.core.item.tool.ItemSickleAdv;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.core.TFProps;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Locale;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public enum VanillaEquipment {
    Wood(Item.ToolMaterial.WOOD, "plankWood"){

        @Override
        protected void createTools() {
            this.itemShears = new ItemShearsAdv(this.TOOL_MATERIAL);
            this.itemFishingRod = Items.field_151112_aM;
            this.itemSickle = new ItemSickleAdv(this.TOOL_MATERIAL);
            this.itemBow = Items.field_151031_f;
        }
    }
    ,
    Stone(Item.ToolMaterial.STONE, "cobblestone"),
    Iron{

        @Override
        protected void createTools() {
            this.itemShears = Items.field_151097_aZ;
            this.itemFishingRod = new ItemFishingRodAdv(this.TOOL_MATERIAL);
            this.itemSickle = new ItemSickleAdv(this.TOOL_MATERIAL);
            this.itemBow = new ItemBowAdv(this.TOOL_MATERIAL);
        }
    }
    ,
    Diamond(Item.ToolMaterial.EMERALD, "gemDiamond"),
    Gold;

    public final Item.ToolMaterial TOOL_MATERIAL;
    private final String ingot;
    private final float arrowSpeed = 1.0f;
    private float arrowDamage = 1.0f;
    private int luckModifier = 0;
    private int speedModifier = 0;
    public boolean[] enableTools = new boolean[4];
    public ItemShears itemShears;
    public ItemFishingRod itemFishingRod;
    public ItemSickleAdv itemSickle;
    public ItemBow itemBow;
    public ItemStack toolShears;
    public ItemStack toolFishingRod;
    public ItemStack toolSickle;
    public ItemStack toolBow;

    private VanillaEquipment() {
        this(null, null);
    }

    private VanillaEquipment(Item.ToolMaterial toolMaterial, String string2) {
        this.TOOL_MATERIAL = toolMaterial == null ? Item.ToolMaterial.valueOf((String)this.name().toUpperCase(Locale.US)) : toolMaterial;
        this.ingot = string2 == null ? "ingot" + this.name() : string2;
        this.luckModifier = this.TOOL_MATERIAL.func_77996_d() / 2;
        this.speedModifier = (int)(this.TOOL_MATERIAL.func_77998_b() / 5.0f);
        this.arrowDamage = 1.0f + this.TOOL_MATERIAL.func_78000_c() / 8.0f;
    }

    protected void createTools() {
        this.itemShears = new ItemShearsAdv(this.TOOL_MATERIAL);
        this.itemFishingRod = new ItemFishingRodAdv(this.TOOL_MATERIAL);
        this.itemSickle = new ItemSickleAdv(this.TOOL_MATERIAL);
        this.itemBow = new ItemBowAdv(this.TOOL_MATERIAL);
    }

    protected void preInitv() {
        ItemShearsAdv itemShearsAdv;
        String string = this.name();
        String string2 = string.toLowerCase(Locale.US);
        String string3 = "thermalfoundation.tool." + string2;
        String string4 = "Equipment." + string;
        string4 = string4 + ".Tools";
        if (this != Iron) {
            this.enableTools[0] = ThermalFoundation.config.get(string4, "Shears", true);
        }
        if (this != Wood) {
            this.enableTools[1] = ThermalFoundation.config.get(string4, "FishingRod", true);
        }
        this.enableTools[2] = ThermalFoundation.config.get(string4, "Sickle", true);
        if (this != Wood) {
            this.enableTools[3] = ThermalFoundation.config.get(string4, "Bow", true);
        }
        for (int i = 0; i < this.enableTools.length; ++i) {
            int n = i;
            this.enableTools[n] = this.enableTools[n] & !TFProps.disableAllTools;
        }
        String string5 = "thermalfoundation:tool/" + string2 + "/" + string;
        this.createTools();
        if (this.itemShears instanceof ItemShearsAdv) {
            itemShearsAdv = (ItemShearsAdv)this.itemShears;
            itemShearsAdv.setRepairIngot(this.ingot).func_77655_b(string3 + "Shears");
            itemShearsAdv.func_111206_d(string5 + "Shears").func_77637_a(ThermalFoundation.tabTools);
            itemShearsAdv.setShowInCreative(this.enableTools[0] | TFProps.showDisabledEquipment);
            GameRegistry.registerItem((Item)itemShearsAdv, (String)("tool.shears" + string));
        }
        if (this.itemFishingRod instanceof ItemFishingRodAdv) {
            itemShearsAdv = (ItemFishingRodAdv)this.itemFishingRod;
            itemShearsAdv.setRepairIngot(this.ingot).func_77655_b(string3 + "FishingRod");
            itemShearsAdv.func_111206_d(string5 + "FishingRod").func_77637_a(ThermalFoundation.tabTools);
            itemShearsAdv.setLuckModifier(this.luckModifier).setSpeedModifier(this.speedModifier);
            itemShearsAdv.setShowInCreative(this.enableTools[1] | TFProps.showDisabledEquipment);
            GameRegistry.registerItem((Item)itemShearsAdv, (String)("tool.fishingRod" + string));
        }
        this.itemSickle.setRepairIngot(this.ingot).func_77655_b(string3 + "Sickle");
        this.itemSickle.func_111206_d(string5 + "Sickle").func_77637_a(ThermalFoundation.tabTools);
        this.itemSickle.setShowInCreative(this.enableTools[2] | TFProps.showDisabledEquipment);
        GameRegistry.registerItem((Item)this.itemSickle, (String)("tool.sickle" + string));
        if (this.itemBow instanceof ItemBowAdv) {
            itemShearsAdv = (ItemBowAdv)this.itemBow;
            itemShearsAdv.setRepairIngot(this.ingot).setArrowSpeed(1.0f).setArrowDamage(this.arrowDamage).func_77655_b(string3 + "Bow");
            itemShearsAdv.func_111206_d(string5 + "Bow").func_77637_a(ThermalFoundation.tabTools);
            itemShearsAdv.setShowInCreative(this.enableTools[3] | TFProps.showDisabledEquipment);
            GameRegistry.registerItem((Item)itemShearsAdv, (String)("tool.bow" + string));
        }
    }

    protected void initializev() {
        String string = this.name();
        this.toolShears = new ItemStack((Item)this.itemShears);
        this.toolFishingRod = new ItemStack((Item)this.itemFishingRod);
        this.toolSickle = new ItemStack((Item)this.itemSickle);
        this.toolBow = new ItemStack((Item)this.itemBow);
        GameRegistry.registerCustomItemStack((String)("tool" + string + "Shears"), (ItemStack)this.toolShears);
        GameRegistry.registerCustomItemStack((String)("tool" + string + "FishingRod"), (ItemStack)this.toolFishingRod);
        GameRegistry.registerCustomItemStack((String)("tool" + string + "Sickle"), (ItemStack)this.toolSickle);
        GameRegistry.registerCustomItemStack((String)("tool" + string + "Bow"), (ItemStack)this.toolBow);
    }

    protected void postInitv() {
        if (this.enableTools[0]) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolShears, (Object[])new Object[]{" I", "I ", Character.valueOf('I'), this.ingot}));
        }
        if (this.enableTools[1]) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolFishingRod, (Object[])new Object[]{"  I", " I#", "S #", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood", Character.valueOf('#'), Items.field_151007_F}));
        }
        if (this.enableTools[2]) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolSickle, (Object[])new Object[]{" I ", "  I", "SI ", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood"}));
        }
        if (this.enableTools[3]) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolBow, (Object[])new Object[]{" I#", "S #", " I#", Character.valueOf('I'), this.ingot, Character.valueOf('S'), "stickWood", Character.valueOf('#'), Items.field_151007_F}));
        }
    }

    public static void preInit() {
        for (VanillaEquipment vanillaEquipment : VanillaEquipment.values()) {
            vanillaEquipment.preInitv();
        }
    }

    public static void initialize() {
        for (VanillaEquipment vanillaEquipment : VanillaEquipment.values()) {
            vanillaEquipment.initializev();
        }
    }

    public static void postInit() {
        for (VanillaEquipment vanillaEquipment : VanillaEquipment.values()) {
            vanillaEquipment.postInitv();
        }
    }
}

