/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.client;

import java.io.InputStream;
import java.text.DecimalFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import mantle.client.SmallFontRenderer;
import mantle.lib.client.MantleClientRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.Document;
import tconstruct.TConstruct;
import tconstruct.armor.ArmorProxyClient;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.common.TProxyCommon;
import tconstruct.tools.items.ManualInfo;

public class TProxyClient
extends TProxyCommon {
    public static DecimalFormat df = new DecimalFormat("##.#");
    public static SmallFontRenderer smallFontRenderer;
    public static IIcon metalBall;
    public static Minecraft mc;
    public static RenderItem itemRenderer;
    public static Document diary;
    public static Document volume1;
    public static Document volume2;
    public static Document smelter;
    public static Document weaponry;
    public static ManualInfo manualData;

    @Override
    public void initialize() {
        this.registerRenderer();
        this.readManuals();
    }

    public void registerRenderer() {
        Minecraft mc = Minecraft.func_71410_x();
        smallFontRenderer = new SmallFontRenderer(mc.field_71474_y, new ResourceLocation("textures/font/ascii.png"), mc.field_71446_o, false);
    }

    public void readManuals() {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        String CurrentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        Document diary_cl = this.readManual("/assets/tinker/manuals/" + CurrentLanguage + "/diary.xml", dbFactory);
        Document volume1_cl = this.readManual("/assets/tinker/manuals/" + CurrentLanguage + "/firstday.xml", dbFactory);
        Document volume2_cl = this.readManual("/assets/tinker/manuals/" + CurrentLanguage + "/materials.xml", dbFactory);
        Document smelter_cl = this.readManual("/assets/tinker/manuals/" + CurrentLanguage + "/smeltery.xml", dbFactory);
        Document weaponry_cl = this.readManual("/assets/tinker/manuals/" + CurrentLanguage + "/weaponry.xml", dbFactory);
        diary = diary_cl != null ? diary_cl : this.readManual("/assets/tinker/manuals/en_US/diary.xml", dbFactory);
        volume1 = volume1_cl != null ? volume1_cl : this.readManual("/assets/tinker/manuals/en_US/firstday.xml", dbFactory);
        volume2 = volume2_cl != null ? volume2_cl : this.readManual("/assets/tinker/manuals/en_US/materials.xml", dbFactory);
        smelter = smelter_cl != null ? smelter_cl : this.readManual("/assets/tinker/manuals/en_US/smeltery.xml", dbFactory);
        weaponry = weaponry_cl != null ? weaponry_cl : this.readManual("/assets/tinker/manuals/en_US/weaponry.xml", dbFactory);
        this.initManualIcons();
        this.initManualRecipes();
        this.initManualPages();
        manualData = new ManualInfo();
    }

    Document readManual(String location, DocumentBuilderFactory dbFactory) {
        try {
            InputStream stream = TConstruct.class.getResourceAsStream(location);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void initManualIcons() {
        MantleClientRegistry.registerManualIcon((String)"torch", (ItemStack)new ItemStack(Blocks.field_150478_aa));
        MantleClientRegistry.registerManualIcon((String)"sapling", (ItemStack)new ItemStack(Blocks.field_150345_g));
        MantleClientRegistry.registerManualIcon((String)"workbench", (ItemStack)new ItemStack(Blocks.field_150462_ai));
        MantleClientRegistry.registerManualIcon((String)"coal", (ItemStack)new ItemStack(Items.field_151044_h));
        MantleClientRegistry.registerManualIcon((String)"woodplanks", (ItemStack)new ItemStack(Blocks.field_150344_f));
        MantleClientRegistry.registerManualIcon((String)"stoneblock", (ItemStack)new ItemStack(Blocks.field_150348_b));
        MantleClientRegistry.registerManualIcon((String)"ironingot", (ItemStack)new ItemStack(Items.field_151042_j));
        MantleClientRegistry.registerManualIcon((String)"flint", (ItemStack)new ItemStack(Items.field_151145_ak));
        MantleClientRegistry.registerManualIcon((String)"cactus", (ItemStack)new ItemStack(Blocks.field_150434_aF));
        MantleClientRegistry.registerManualIcon((String)"bone", (ItemStack)new ItemStack(Items.field_151103_aS));
        MantleClientRegistry.registerManualIcon((String)"obsidian", (ItemStack)new ItemStack(Blocks.field_150343_Z));
        MantleClientRegistry.registerManualIcon((String)"netherrack", (ItemStack)new ItemStack(Blocks.field_150424_aL));
    }

    public void initManualRecipes() {
    }

    void initManualPages() {
    }

    public static Document getManualFromStack(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return volume1;
            }
            case 1: {
                return volume2;
            }
            case 2: {
                return smelter;
            }
            case 3: {
                return diary;
            }
        }
        return null;
    }

    public void recalculateHealth() {
        ArmorProxyClient.armorExtended.recalculateHealth((EntityPlayer)TProxyClient.mc.field_71439_g, TPlayerStats.get((EntityPlayer)TProxyClient.mc.field_71439_g));
    }

    static {
        itemRenderer = new RenderItem();
    }
}

