/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.preloader;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import tconstruct.preloader.TConstructLoaderContainer;
import tconstruct.preloader.helpers.PropertyManager;

public class ASMInterfaceRepair
implements IClassTransformer {
    public static Map<String, Boolean> APIInterfaces = new HashMap<String, Boolean>();

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (name.startsWith("tconstruct.") && !this.isBlacklisted(name)) {
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            boolean changed = false;
            if (this.verifyAPI(cn)) {
                changed = true;
            }
            if (changed) {
                ClassWriter cw = new ClassWriter(1);
                cn.accept((ClassVisitor)cw);
                bytes = cw.toByteArray();
                this.log("Altering definition of " + transformedName);
            }
        }
        return bytes;
    }

    private boolean isInternal(String path) {
        return path.startsWith("java/") || path.startsWith("cpw/mods/fml/") || path.startsWith("tconstruct/") || path.startsWith("com/google/") || path.startsWith("net/minecraftforge/") || path.startsWith("net/minecraft/");
    }

    private boolean isBlacklisted(String path) {
        return path.startsWith("tconstruct.plugins.") || path.startsWith("tconstruct.preloader.");
    }

    private boolean isClassAvailable(String inf) {
        if (APIInterfaces.containsKey(inf)) {
            return APIInterfaces.get(inf);
        }
        boolean isAvailable = false;
        Class<?> obj = null;
        try {
            obj = Class.forName(inf.replace("/", "."));
        }
        catch (Throwable _) {
            // empty catch block
        }
        isAvailable = obj != null;
        APIInterfaces.put(inf, isAvailable);
        return isAvailable;
    }

    private boolean verifyAPI(ClassNode cn) {
        boolean isAvailable;
        boolean changed = false;
        this.log("Examining " + cn.name);
        Iterator mn = cn.methods.iterator();
        while (mn.hasNext()) {
            MethodNode meth = (MethodNode)mn.next();
            SigChecker sc = new SigChecker(1, this);
            new SignatureReader(meth.desc).accept((SignatureVisitor)sc);
            isAvailable = sc.isAvailable;
            if (isAvailable) continue;
            mn.remove();
            changed = true;
        }
        Iterator i = cn.interfaces.iterator();
        while (i.hasNext()) {
            String inf = (String)i.next();
            if (this.isInternal(inf)) continue;
            isAvailable = this.isClassAvailable(inf);
            this.log(inf + " is " + (isAvailable ? "available" : "not available"));
            if (isAvailable) continue;
            i.remove();
            changed = true;
        }
        return changed;
    }

    private void log(String string) {
        if (PropertyManager.asmInterfaceRepair_verboseLog) {
            TConstructLoaderContainer.logger.info(string);
        }
    }

    class SigChecker
    extends SignatureVisitor {
        private ASMInterfaceRepair asmTransformer;
        public boolean isAvailable;

        public SigChecker(int api, ASMInterfaceRepair t) {
            super(api);
            this.isAvailable = true;
            this.asmTransformer = t;
        }

        public void visitInnerClassType(String name) {
            this.visitTypeVariable(name);
        }

        public void visitClassType(String name) {
            this.visitTypeVariable(name);
        }

        public void visitTypeVariable(String className) {
            if (ASMInterfaceRepair.this.isInternal(className)) {
                return;
            }
            this.isAvailable = this.isAvailable && this.asmTransformer.isClassAvailable(className);
            ASMInterfaceRepair.this.log(className + " is " + (this.isAvailable ? "available" : "not available"));
        }
    }
}

