/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm.wrapper;

import logisticspipes.asm.wrapper.AbstractWrapper;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.utils.item.ItemIdentifierInventory;
import net.minecraft.tileentity.TileEntity;

class CraftingRecipeProviderWrapper
extends AbstractWrapper
implements ICraftingRecipeProvider {
    private ICraftingRecipeProvider provider;
    private final String name;

    CraftingRecipeProviderWrapper(ICraftingRecipeProvider provider, String name) {
        this.provider = provider;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeName() {
        return "RecipeProvider";
    }

    @Override
    public boolean canOpenGui(TileEntity tile) {
        if (this.isEnabled()) {
            try {
                this.provider.canOpenGui(tile);
            }
            catch (Exception e) {
                this.handleException(e);
            }
            catch (NoClassDefFoundError e) {
                this.handleException(e);
            }
        }
        return false;
    }

    @Override
    public boolean importRecipe(TileEntity tile, ItemIdentifierInventory inventory) {
        if (this.isEnabled()) {
            try {
                this.provider.importRecipe(tile, inventory);
            }
            catch (Exception e) {
                this.handleException(e);
            }
            catch (NoClassDefFoundError e) {
                this.handleException(e);
            }
        }
        return false;
    }
}

