/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.debuggui;

import java.io.IOException;
import logisticspipes.commands.commands.debug.DebugGuiController;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import net.minecraft.entity.player.EntityPlayer;

public class DebugDataPacket
extends ModernPacket {
    private byte[] payload;
    private int identifier;

    public DebugDataPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        this.payload = data.readByteArray();
        this.identifier = data.readInt();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        DebugGuiController.instance().handleDataPacket(this.payload, this.identifier, player);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeByteArray(this.payload);
        data.writeInt(this.identifier);
    }

    @Override
    public ModernPacket template() {
        return new DebugDataPacket(this.getId());
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public DebugDataPacket setPayload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public DebugDataPacket setIdentifier(int identifier) {
        this.identifier = identifier;
        return this;
    }
}

