/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import logisticspipes.interfaces.ISpawnParticles;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipefxhandlers.PipeFXRenderHandler;
import lombok.NonNull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class ParticleFX
extends CoordinatesPacket {
    @NonNull
    private Collection<ISpawnParticles.ParticleCount> particles;

    public ParticleFX(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new ParticleFX(this.getId());
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        int nparticles = data.readInt();
        this.particles = new ArrayList<ISpawnParticles.ParticleCount>(nparticles);
        for (int i = 0; i < nparticles; ++i) {
            byte particle = data.readByte();
            int amount = data.readInt();
            this.particles.add(new ISpawnParticles.ParticleCount(Particles.values()[particle], amount));
        }
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeInt(this.particles.size());
        for (ISpawnParticles.ParticleCount pc : this.particles) {
            data.writeByte(pc.getParticle().ordinal());
            data.writeInt(pc.getAmount());
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        if (!Minecraft.func_71375_t()) {
            return;
        }
        for (ISpawnParticles.ParticleCount pc : this.particles) {
            PipeFXRenderHandler.spawnGenericParticle(pc.getParticle(), this.getPosX(), this.getPosY(), this.getPosZ(), pc.getAmount());
        }
    }

    @NonNull
    public Collection<ISpawnParticles.ParticleCount> getParticles() {
        return this.particles;
    }

    public ParticleFX setParticles(@NonNull Collection<ISpawnParticles.ParticleCount> particles) {
        if (particles == null) {
            throw new NullPointerException("particles");
        }
        this.particles = particles;
        return this;
    }
}

