/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.io.IOException;
import java.util.BitSet;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.transport.PipeFluidTransportLogistics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PipeFluidUpdate
extends CoordinatesPacket {
    private FluidStack[] renderCache = new FluidStack[ForgeDirection.values().length];
    private BitSet bits = new BitSet();

    public PipeFluidUpdate(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.bits = data.readBitSet();
        for (int i = 0; i < this.renderCache.length; ++i) {
            if (!this.bits.get(i)) continue;
            this.renderCache[i] = new FluidStack(FluidRegistry.getFluid((int)data.readInt()), data.readInt(), data.readNBTTagCompound());
        }
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        int i;
        super.writeData(data);
        for (i = 0; i < this.renderCache.length; ++i) {
            this.bits.set(i, this.renderCache[i] != null);
        }
        data.writeBitSet(this.bits);
        for (i = 0; i < this.renderCache.length; ++i) {
            if (this.renderCache[i] == null) continue;
            data.writeInt(FluidRegistry.getFluidID((Fluid)this.renderCache[i].getFluid()));
            data.writeInt(this.renderCache[i].amount);
            data.writeNBTTagCompound(this.renderCache[i].tag);
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe pipe = this.getPipe(player.field_70170_p);
        if (pipe == null || pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeFluidTransportLogistics)) {
            return;
        }
        ((PipeFluidTransportLogistics)pipe.pipe.transport).renderCache = this.renderCache;
    }

    @Override
    public ModernPacket template() {
        return new PipeFluidUpdate(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    private FluidStack[] getRenderCache() {
        return this.renderCache;
    }

    public PipeFluidUpdate setRenderCache(FluidStack[] renderCache) {
        this.renderCache = renderCache;
        return this;
    }
}

