/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class PipeFluidInsertion
extends FluidRoutedPipe {
    private List<Pair<Integer, Integer>> localJamList = new ArrayList<Pair<Integer, Integer>>();
    private int[] nextSendMax = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private int[] nextSendMin = new int[ForgeDirection.VALID_DIRECTIONS.length];

    public PipeFluidInsertion(Item item) {
        super(item);
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        ArrayList<Integer> tempJamList = new ArrayList<Integer>();
        if (!this.localJamList.isEmpty()) {
            ArrayList<Pair<Integer, Integer>> toRemove = new ArrayList<Pair<Integer, Integer>>();
            for (Pair<Integer, Integer> part : this.localJamList) {
                part.setValue2(part.getValue2() - 1);
                if (part.getValue2() <= 0) {
                    toRemove.add(part);
                    continue;
                }
                tempJamList.add(part.getValue1());
            }
            if (!toRemove.isEmpty()) {
                this.localJamList.removeAll(toRemove);
            }
        }
        PipeFluidTransportLogistics transport = (PipeFluidTransportLogistics)this.transport;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            FluidStack stack = transport.sideTanks[dir.ordinal()].getFluid();
            if (stack == null) continue;
            stack = stack.copy();
            if (this.nextSendMax[dir.ordinal()] > 0 && stack.amount < transport.sideTanks[dir.ordinal()].getCapacity()) {
                int n = dir.ordinal();
                this.nextSendMax[n] = this.nextSendMax[n] - 1;
                continue;
            }
            if (this.nextSendMin[dir.ordinal()] > 0) {
                int n = dir.ordinal();
                this.nextSendMin[n] = this.nextSendMin[n] - 1;
                continue;
            }
            Pair<Integer, Integer> result = SimpleServiceLocator.logisticsFluidManager.getBestReply(stack, this.getRouter(), tempJamList);
            if (result == null || result.getValue1() == null || result.getValue1() == 0 || result.getValue2() == 0) {
                this.nextSendMax[dir.ordinal()] = 100;
                this.nextSendMin[dir.ordinal()] = 10;
                continue;
            }
            if (!this.useEnergy((int)(0.01 * (double)result.getValue2().intValue()))) {
                this.nextSendMax[dir.ordinal()] = 100;
                this.nextSendMin[dir.ordinal()] = 10;
                continue;
            }
            FluidStack toSend = transport.sideTanks[dir.ordinal()].drain(result.getValue2().intValue(), true);
            ItemIdentifierStack liquidContainer = SimpleServiceLocator.logisticsFluidManager.getFluidContainer(toSend);
            LPTravelingItem.LPTravelingItemServer routed = SimpleServiceLocator.routedItemHelper.createNewTravelItem(liquidContainer);
            routed.setDestination(result.getValue1());
            routed.setTransportMode(IRoutedItem.TransportMode.Passive);
            this.queueRoutedItem(routed, dir);
            this.nextSendMax[dir.ordinal()] = 100;
            this.nextSendMin[dir.ordinal()] = 5;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74783_a("nextSendMax", this.nextSendMax);
        nbttagcompound.func_74783_a("nextSendMin", this.nextSendMin);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.nextSendMax = nbttagcompound.func_74759_k("nextSendMax");
        if (this.nextSendMax.length < 6) {
            this.nextSendMax = new int[6];
        }
        this.nextSendMin = nbttagcompound.func_74759_k("nextSendMin");
        if (this.nextSendMin.length < 6) {
            this.nextSendMin = new int[6];
        }
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_INSERTION;
    }

    @Override
    public boolean canInsertToTanks() {
        return false;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return false;
    }

    @Override
    public boolean canReceiveFluid() {
        return true;
    }
}

