/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.recipeproviders;

import java.lang.reflect.Method;
import logisticspipes.LogisticsPipes;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.utils.item.ItemIdentifierInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class RollingMachine
implements ICraftingRecipeProvider {
    private Class<?> tileRollingMachineClass = Class.forName("mods.railcraft.common.blocks.machine.alpha.TileRollingMachine");
    private Method getCraftMatrixMethod = this.tileRollingMachineClass.getMethod("getCraftMatrix", new Class[0]);

    @Override
    public boolean canOpenGui(TileEntity tile) {
        return this.tileRollingMachineClass.isInstance(tile);
    }

    private ItemStack getResult(InventoryCrafting inventorycrafting, World world) {
        if (inventorycrafting == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName("mods.railcraft.common.util.crafting.RollingMachineCraftingManager");
            Method inst = c.getMethod("getInstance", new Class[0]);
            Object instance = inst.invoke(null, new Object[0]);
            Method findMatchingRecipe = c.getMethod("findMatchingRecipe", InventoryCrafting.class, World.class);
            return (ItemStack)findMatchingRecipe.invoke(instance, inventorycrafting, world);
        }
        catch (Exception ex) {
            LogisticsPipes.log.error("getResult fail");
            return null;
        }
    }

    private InventoryCrafting getCraftMatrix(TileEntity tile) {
        try {
            return (InventoryCrafting)this.getCraftMatrixMethod.invoke((Object)tile, new Object[0]);
        }
        catch (Exception ex) {
            LogisticsPipes.log.error("getCraftMatrix fail");
            return null;
        }
    }

    @Override
    public boolean importRecipe(TileEntity tile, ItemIdentifierInventory inventory) {
        if (!this.tileRollingMachineClass.isInstance(tile)) {
            return false;
        }
        InventoryCrafting craftMatrix = this.getCraftMatrix(tile);
        if (craftMatrix == null) {
            return false;
        }
        ItemStack result = this.getResult(craftMatrix, tile.func_145831_w());
        if (result == null) {
            return false;
        }
        inventory.func_70299_a(9, result);
        for (int i = 0; i < craftMatrix.func_70302_i_() && i < inventory.func_70302_i_() - 2; ++i) {
            ItemStack newStack = craftMatrix.func_70301_a(i) == null ? null : craftMatrix.func_70301_a(i).func_77946_l();
            inventory.func_70299_a(i, newStack);
        }
        inventory.compact_first(9);
        return true;
    }
}

