/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import com.google.common.util.concurrent.AtomicDouble;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.properties.PropertiesBase;
import journeymap.client.properties.config.Config;
import journeymap.client.ui.component.CheckBox;
import journeymap.client.ui.component.DoubleSliderButton;
import journeymap.client.ui.component.IntSliderButton;
import journeymap.client.ui.component.ListPropertyButton;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.option.ButtonListSlot;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.option.StringListProvider;
import journeymap.common.Journeymap;

public class OptionSlotFactory {
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected static BufferedWriter docWriter;
    protected static File docFile;
    protected static boolean generateDocs;

    public static List<CategorySlot> getSlots(Map<Config.Category, List<SlotMetadata>> toolbars) {
        CategorySlot categorySlot;
        HashMap<Config.Category, List<SlotMetadata>> mergedMap = new HashMap<Config.Category, List<SlotMetadata>>();
        OptionSlotFactory.addSlots(mergedMap, Config.Category.MiniMap1, JourneymapClient.getMiniMapProperties1());
        OptionSlotFactory.addSlots(mergedMap, Config.Category.MiniMap2, JourneymapClient.getMiniMapProperties2());
        OptionSlotFactory.addSlots(mergedMap, Config.Category.FullMap, JourneymapClient.getFullMapProperties());
        OptionSlotFactory.addSlots(mergedMap, Config.Category.WebMap, JourneymapClient.getWebMapProperties());
        OptionSlotFactory.addSlots(mergedMap, Config.Category.Waypoint, JourneymapClient.getWaypointProperties());
        OptionSlotFactory.addSlots(mergedMap, Config.Category.Advanced, JourneymapClient.getCoreProperties());
        ArrayList<CategorySlot> categories = new ArrayList<CategorySlot>();
        for (Map.Entry<Config.Category, List<SlotMetadata>> entry : mergedMap.entrySet()) {
            Config.Category category = entry.getKey();
            categorySlot = new CategorySlot(category);
            for (SlotMetadata slotMetadata : entry.getValue()) {
                categorySlot.add(new ButtonListSlot(categorySlot).add(slotMetadata));
            }
            if (toolbars.containsKey((Object)category)) {
                ButtonListSlot toolbarSlot = new ButtonListSlot(categorySlot);
                for (SlotMetadata toolbar : toolbars.get((Object)category)) {
                    toolbarSlot.add(toolbar);
                }
                categorySlot.add(toolbarSlot);
            }
            categories.add(categorySlot);
        }
        Collections.sort(categories);
        int count = 0;
        for (CategorySlot categorySlot2 : categories) {
            count += categorySlot2.size();
        }
        if (generateDocs) {
            OptionSlotFactory.ensureDocFile();
            for (ScrollListPane.ISlot iSlot : categories) {
                categorySlot = (CategorySlot)iSlot;
                if (categorySlot.category == Config.Category.MiniMap2) continue;
                OptionSlotFactory.doc(categorySlot);
                OptionSlotFactory.docTable(true);
                categorySlot.sort();
                for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                    OptionSlotFactory.doc(slotMetadata, categorySlot.getCategory() == Config.Category.Advanced);
                }
                OptionSlotFactory.docTable(false);
            }
            OptionSlotFactory.endDoc();
        }
        return categories;
    }

    protected static void addSlots(HashMap<Config.Category, List<SlotMetadata>> mergedMap, Config.Category inheritedCategory, PropertiesBase properties) {
        Class<?> propertiesClass = properties.getClass();
        for (Map.Entry<Config.Category, List<SlotMetadata>> entry : OptionSlotFactory.buildSlots(null, inheritedCategory, propertiesClass, properties).entrySet()) {
            Config.Category category = entry.getKey();
            if (category == Config.Category.Inherit) {
                category = inheritedCategory;
            }
            List<Object> slotMetadataList = null;
            if (mergedMap.containsKey((Object)category)) {
                slotMetadataList = mergedMap.get((Object)category);
            } else {
                slotMetadataList = new ArrayList();
                mergedMap.put(category, slotMetadataList);
            }
            slotMetadataList.addAll((Collection)entry.getValue());
        }
    }

    protected static HashMap<Config.Category, List<SlotMetadata>> buildSlots(HashMap<Config.Category, List<SlotMetadata>> map, Config.Category inheritedCategory, Class<? extends PropertiesBase> propertiesClass, PropertiesBase properties) {
        if (map == null) {
            map = new HashMap();
        }
        for (Field field : propertiesClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Config.class)) continue;
            Config config = field.getAnnotation(Config.class);
            SlotMetadata<Object> slotMetadata = null;
            if (field.getType().equals(AtomicBoolean.class)) {
                slotMetadata = OptionSlotFactory.getBooleanSlotMetadata(properties, field);
            } else if (field.getType().equals(AtomicInteger.class)) {
                slotMetadata = OptionSlotFactory.getIntegerSlotMetadata(properties, field);
            } else if (field.getType().equals(AtomicDouble.class)) {
                slotMetadata = OptionSlotFactory.getDoubleSlotMetadata(properties, field);
            } else if (field.getType().equals(AtomicReference.class)) {
                slotMetadata = !config.stringListProvider().equals(Config.NoStringProvider.class) ? OptionSlotFactory.getStringSlotMetadata(properties, field) : OptionSlotFactory.getEnumSlotMetadata(properties, field);
            }
            if (slotMetadata != null) {
                List<SlotMetadata<Object>> list;
                slotMetadata.setOrder(config.sortOrder());
                Config.Category category = config.category();
                if (category == Config.Category.Inherit) {
                    category = inheritedCategory;
                }
                if ((list = map.get((Object)category)) == null) {
                    list = new ArrayList<SlotMetadata<Object>>();
                    map.put(category, list);
                }
                list.add(slotMetadata);
                continue;
            }
            Journeymap.getLogger().warn(String.format("Unable to create config gui for %s.%s using %s", properties.getClass().getSimpleName(), field.getName(), config));
        }
        Class<? extends PropertiesBase> parentClass = propertiesClass.getSuperclass();
        if (PropertiesBase.class.isAssignableFrom(parentClass)) {
            map = OptionSlotFactory.buildSlots(map, inheritedCategory, parentClass, properties);
        }
        return map;
    }

    static String getName(Config annotation) {
        return Constants.getString(annotation.key());
    }

    static String getTooltip(Config annotation) {
        String tooltip;
        String tooltipKey = annotation.key() + ".tooltip";
        if (tooltipKey.equals(tooltip = Constants.getString(tooltipKey))) {
            tooltip = null;
        }
        return tooltip;
    }

    static SlotMetadata<Boolean> getBooleanSlotMetadata(PropertiesBase properties, Field field) {
        Config annotation = field.getAnnotation(Config.class);
        try {
            AtomicBoolean property = (AtomicBoolean)field.get(properties);
            String name = OptionSlotFactory.getName(annotation);
            String tooltip = OptionSlotFactory.getTooltip(annotation);
            String defaultTip = Constants.getString("jm.config.default", annotation.defaultBoolean());
            boolean advanced = annotation.category() == Config.Category.Advanced;
            CheckBox button = new CheckBox(name, property, properties);
            SlotMetadata<Boolean> slotMetadata = new SlotMetadata<Boolean>(button, name, tooltip, defaultTip, annotation.defaultBoolean(), advanced);
            slotMetadata.setMasterPropertyForCategory(annotation.master());
            if (annotation.master()) {
                button.setLabelColors(65535, null, null);
            }
            return slotMetadata;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    static SlotMetadata<Integer> getIntegerSlotMetadata(PropertiesBase properties, Field field) {
        Config annotation = field.getAnnotation(Config.class);
        try {
            AtomicInteger property = (AtomicInteger)field.get(properties);
            String name = OptionSlotFactory.getName(annotation);
            String tooltip = OptionSlotFactory.getTooltip(annotation);
            String defaultTip = Constants.getString("jm.config.default_numeric", (int)annotation.minValue(), (int)annotation.maxValue(), (int)annotation.defaultValue());
            boolean advanced = annotation.category() == Config.Category.Advanced;
            IntSliderButton button = new IntSliderButton(properties, property, name + " : ", "", (int)annotation.minValue(), (int)annotation.maxValue(), true);
            button.setDefaultStyle(false);
            button.setDrawBackground(false);
            SlotMetadata<Integer> slotMetadata = new SlotMetadata<Integer>(button, name, tooltip, defaultTip, (int)annotation.defaultValue(), advanced);
            return slotMetadata;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    static SlotMetadata<Double> getDoubleSlotMetadata(PropertiesBase properties, Field field) {
        Config annotation = field.getAnnotation(Config.class);
        try {
            AtomicDouble property = (AtomicDouble)field.get(properties);
            String name = OptionSlotFactory.getName(annotation);
            String tooltip = OptionSlotFactory.getTooltip(annotation);
            String defaultTip = Constants.getString("jm.config.default_numeric", annotation.minValue(), annotation.maxValue(), annotation.defaultValue());
            boolean advanced = annotation.category() == Config.Category.Advanced;
            DoubleSliderButton button = new DoubleSliderButton(properties, property, name + " : ", "", annotation.minValue(), annotation.maxValue(), true);
            button.setDefaultStyle(false);
            button.setDrawBackground(false);
            SlotMetadata<Double> slotMetadata = new SlotMetadata<Double>(button, name, tooltip, defaultTip, annotation.defaultValue(), advanced);
            return slotMetadata;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    static SlotMetadata<String> getStringSlotMetadata(PropertiesBase properties, Field field) {
        Config annotation = field.getAnnotation(Config.class);
        try {
            AtomicReference property = (AtomicReference)field.get(properties);
            String name = OptionSlotFactory.getName(annotation);
            String tooltip = OptionSlotFactory.getTooltip(annotation);
            StringListProvider slp = annotation.stringListProvider().newInstance();
            boolean advanced = annotation.category() == Config.Category.Advanced;
            ListPropertyButton button = null;
            String defaultTip = null;
            if (slp instanceof LocationFormat.IdProvider) {
                button = new LocationFormat.Button(properties, property);
                defaultTip = Constants.getString("jm.config.default", ((LocationFormat.Button)button).getLabel(slp.getDefaultString()));
            } else {
                button = new ListPropertyButton<String>(slp.getStrings(), name, properties, property);
                defaultTip = Constants.getString("jm.config.default", slp.getDefaultString());
            }
            button.setDefaultStyle(false);
            button.setDrawBackground(false);
            SlotMetadata<String> slotMetadata = new SlotMetadata<String>(button, name, tooltip, defaultTip, slp.getDefaultString(), advanced);
            slotMetadata.setValueList(slp.getStrings());
            return slotMetadata;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static SlotMetadata<Enum> getEnumSlotMetadata(PropertiesBase properties, Field field) {
        Config annotation = field.getAnnotation(Config.class);
        try {
            AtomicReference property = (AtomicReference)field.get(properties);
            String name = OptionSlotFactory.getName(annotation);
            String tooltip = OptionSlotFactory.getTooltip(annotation);
            Class<?> enumClass = ((Enum)property.get()).getClass();
            ArrayList enumSet = new ArrayList(EnumSet.allOf(enumClass));
            Enum defaultEnumValue = (Enum)enumSet.get(0);
            try {
                defaultEnumValue = Enum.valueOf(enumClass, annotation.defaultEnum());
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Bad enumeration value for " + name + " default: " + annotation.defaultEnum());
            }
            String defaultTip = Constants.getString("jm.config.default", defaultEnumValue);
            boolean advanced = annotation.category() == Config.Category.Advanced;
            ListPropertyButton button = new ListPropertyButton(enumSet, name, properties, property);
            button.setDefaultStyle(false);
            button.setDrawBackground(false);
            SlotMetadata<Enum> slotMetadata = new SlotMetadata<Enum>(button, name, tooltip, defaultTip, defaultEnumValue, advanced);
            slotMetadata.setValueList(enumSet);
            return slotMetadata;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static void ensureDocFile() {
        if (docFile == null) {
            docFile = new File(Constants.JOURNEYMAP_DIR, "journeymap-options-wiki.txt");
            try {
                if (docFile.exists()) {
                    docFile.delete();
                }
                Files.createParentDirs((File)docFile);
                docWriter = Files.newWriter((File)docFile, (Charset)UTF8);
                docWriter.append(String.format("<!-- Generated %s -->", new Date()));
                docWriter.newLine();
                docWriter.append("=== Overview ===");
                docWriter.newLine();
                docWriter.append("{{version|5.0.0|page}}");
                docWriter.newLine();
                docWriter.append("This page lists all of the available options which can be configured in-game using the JourneyMap [[Options Manager]].");
                docWriter.append("(Note: All of this information can also be obtained from the tooltips within the [[Options Manager]] itself.) <br clear/> <br clear/>");
                docWriter.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static void doc(CategorySlot categorySlot) {
        try {
            docWriter.newLine();
            docWriter.append(String.format("==%s==", categorySlot.name.replace("Preset 1", "Preset (1 and 2)")));
            docWriter.newLine();
            docWriter.append(String.format("''%s''", categorySlot.getMetadata().iterator().next().tooltip.replace("Preset 1", "Preset (1 and 2)")));
            docWriter.newLine();
            docWriter.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void docTable(boolean start) {
        try {
            if (start) {
                docWriter.append("{| class=\"wikitable\" style=\"cellpadding=\"4\"");
                docWriter.newLine();
                docWriter.append("! scope=\"col\" | Option");
                docWriter.newLine();
                docWriter.append("! scope=\"col\" | Purpose");
                docWriter.newLine();
                docWriter.append("! scope=\"col\" | Range / Default Value");
                docWriter.newLine();
                docWriter.append("|-");
                docWriter.newLine();
            } else {
                docWriter.append("|}");
                docWriter.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void doc(SlotMetadata slotMetadata, boolean advanced) {
        try {
            String color = advanced ? "red" : "black";
            docWriter.append(String.format("| style=\"text-align:right; white-space: nowrap; font-weight:bold; padding:6px; color:%s\" | %s", color, slotMetadata.getName()));
            docWriter.newLine();
            docWriter.append(String.format("| %s ", slotMetadata.tooltip));
            if (slotMetadata.getValueList() != null) {
                docWriter.append(String.format("<br/><em>Choices available:</em> <code>%s</code>", Joiner.on((String)", ").join((Iterable)slotMetadata.getValueList())));
            }
            docWriter.newLine();
            docWriter.append(String.format("| <code>%s</code>", slotMetadata.range.replace("[", "").replace("]", "").trim()));
            docWriter.newLine();
            docWriter.append("|-");
            docWriter.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void endDoc() {
        try {
            docFile = null;
            docWriter.flush();
            docWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        generateDocs = false;
    }
}

