/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.QmunityLib;
import uk.co.qmunity.lib.client.gui.widget.BaseWidget;
import uk.co.qmunity.lib.client.gui.widget.IGuiWidget;
import uk.co.qmunity.lib.client.gui.widget.IWidgetListener;

public class GuiBase
extends GuiScreen
implements IWidgetListener {
    protected static final int COLOR_TEXT = 0xFFFFFF;
    private final List<IGuiWidget> widgets = new ArrayList<IGuiWidget>();
    private final ResourceLocation resLoc;
    protected int xSize = 176;
    protected int ySize = 166;
    protected String title = null;

    public GuiBase(ResourceLocation _resLoc, int xSize, int ySize) {
        this.resLoc = _resLoc;
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public GuiBase(ResourceLocation _resLoc, int xSize, int ySize, String title) {
        this(_resLoc, xSize, ySize);
        this.title = title;
    }

    protected void addWidget(IGuiWidget widget) {
        this.widgets.add(widget);
        widget.setListener(this);
    }

    public void func_146280_a(Minecraft par1Minecraft, int par2, int par3) {
        this.widgets.clear();
        super.func_146280_a(par1Minecraft, par2, par3);
    }

    public static void drawVerticalProgressBar(int xOffset, int yOffset, int h, int w, float value, float max, int color) {
        float perc = value / max;
        int height = (int)((float)h * perc);
        GuiBase.func_73734_a((int)xOffset, (int)(yOffset + h - height), (int)(xOffset + w), (int)(yOffset + h), (int)color);
    }

    public void drawHorizontalAlignedString(int xOffset, int yOffset, int w, String text, boolean useShadow) {
        int stringWidth = this.field_146289_q.func_78256_a(text);
        int newX = xOffset;
        if (stringWidth < w) {
            newX = w / 2 - stringWidth / 2 + xOffset;
        }
        this.field_146289_q.func_85187_a(text, newX, yOffset, 0xFFFFFF, useShadow);
    }

    public void drawString(int xOffset, int yOffset, String text, boolean useShadow) {
        this.field_146289_q.func_85187_a(text, xOffset, yOffset, 0xFFFFFF, useShadow);
    }

    public void func_73863_a(int x, int y, float partialTick) {
        super.func_73863_a(x, y, partialTick);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.resLoc);
        int x_ = (this.field_146294_l - this.xSize) / 2;
        int y_ = (this.field_146295_m - this.ySize) / 2;
        this.func_73729_b(x_, y_, 0, 0, this.xSize, this.ySize);
        for (IGuiWidget widget : this.widgets) {
            widget.render(x_, y_, partialTick);
        }
        if (this.title != null) {
            this.drawHorizontalAlignedString((this.field_146294_l - this.xSize) / 2 + 7, (this.field_146295_m - this.ySize) / 2 + 8, this.xSize - 14, I18n.func_135052_a((String)this.title, (Object[])new Object[0]), true);
        }
        ArrayList<String> tooltip = new ArrayList<String>();
        boolean shift = QmunityLib.proxy.isSneakingInGui();
        for (IGuiWidget widget : this.widgets) {
            if (!widget.getBounds().contains(x, y)) continue;
            widget.addTooltip(x, y, tooltip, shift);
        }
        if (!tooltip.isEmpty()) {
            ArrayList<String> localizedTooltip = new ArrayList<String>();
            for (String line : tooltip) {
                String[] lines;
                String localizedLine = I18n.func_135052_a((String)line, (Object[])new Object[0]);
                for (String locLine : lines = WordUtils.wrap((String)localizedLine, (int)50).split(System.getProperty("line.separator"))) {
                    localizedTooltip.add(locLine);
                }
            }
            this.drawHoveringText(localizedTooltip, x, y, this.field_146289_q);
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        for (IGuiWidget widget : this.widgets) {
            if (!widget.getBounds().contains(x, y) || widget instanceof BaseWidget && !((BaseWidget)widget).enabled) continue;
            widget.onMouseClicked(x, y, button);
        }
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
    }

    public void redraw() {
        this.field_146292_n.clear();
        this.widgets.clear();
        this.func_73866_w_();
    }

    public IGuiWidget getWidget(int id) {
        for (IGuiWidget widget : this.widgets) {
            if (widget.getID() != id) continue;
            return widget;
        }
        return null;
    }
}

