/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.client.gui.widget;

import cpw.mods.fml.client.FMLClientHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.client.gui.widget.BaseWidget;
import uk.co.qmunity.lib.client.gui.widget.IGuiAnimatedStat;
import uk.co.qmunity.lib.client.gui.widget.IGuiWidget;
import uk.co.qmunity.lib.client.gui.widget.IWidgetListener;

public class GuiAnimatedStat
extends BaseWidget
implements IGuiAnimatedStat,
IGuiWidget {
    private IGuiAnimatedStat affectingStat;
    private ItemStack iStack;
    private String texture = "";
    private final GuiScreen gui;
    private final List<String> textList = new ArrayList<String>();
    private int baseX;
    private int baseY;
    private int affectedY;
    private int width;
    private int height;
    private int oldBaseX;
    private int oldAffectedY;
    private int oldWidth;
    private int oldHeight;
    private boolean isClicked = false;
    private int minWidth = 17;
    private int minHeight = 17;
    private final int backGroundColor;
    private String title;
    private boolean leftSided;
    private boolean doneExpanding;
    private RenderItem itemRenderer;
    private float textSize;
    private float textScale = 1.0f;
    public static final int MAX_CHAR = 28;
    public static final int ANIMATED_STAT_SPEED = 10;
    private ResourceLocation iconResLoc;
    private IWidgetListener listener;

    public GuiAnimatedStat(GuiScreen gui, String title, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        super(-1, xPos, yPos, yPos, backGroundColor, new String[0]);
        ScaledResolution sr;
        this.gui = gui;
        this.baseX = xPos;
        this.baseY = yPos;
        this.affectingStat = affectingStat;
        this.width = this.minWidth;
        this.height = this.minHeight;
        this.backGroundColor = backGroundColor;
        this.setTitle(title);
        this.texture = "";
        this.leftSided = leftSided;
        this.textSize = gui != null ? ((sr = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d)).func_78326_a() < 520 ? (float)(sr.func_78326_a() - 220) * 0.0033f : 1.0f) : 1.0f;
        this.affectedY = this.baseY;
        if (affectingStat != null) {
            this.affectedY += affectingStat.getAffectedY() + affectingStat.getHeight();
        }
    }

    public GuiAnimatedStat(GuiScreen gui, int backgroundColor) {
        this(gui, "", 0, 0, backgroundColor, null, false);
    }

    public GuiAnimatedStat(GuiScreen gui, int backgroundColor, ItemStack icon) {
        this(gui, backgroundColor);
        this.iStack = icon;
    }

    public GuiAnimatedStat(GuiScreen gui, int backgroundColor, String texture) {
        this(gui, backgroundColor);
        this.texture = texture;
    }

    public GuiAnimatedStat(GuiScreen gui, String title, ItemStack icon, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        this(gui, title, xPos, yPos, backGroundColor, affectingStat, leftSided);
        this.iStack = icon;
    }

    public GuiAnimatedStat(GuiScreen gui, String title, String texture, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        this(gui, title, xPos, yPos, backGroundColor, affectingStat, leftSided);
        this.texture = texture;
    }

    @Override
    public void setParentStat(IGuiAnimatedStat stat) {
        this.affectingStat = stat;
    }

    @Override
    public Rectangle getButtonScaledRectangle(int origX, int origY, int width, int height) {
        int scaledX = (int)((float)(origX - this.baseX - (this.leftSided ? width : 0)) * this.textSize);
        int scaledY = (int)((float)(origY - this.affectedY) * this.textSize);
        return new Rectangle(scaledX + this.baseX + (this.leftSided ? (int)((float)width * this.textSize) : 0), scaledY + this.affectedY, (int)((float)width * this.textSize), (int)((float)height * this.textSize));
    }

    @Override
    public void scaleTextSize(float scale) {
        this.textSize *= scale;
        this.textScale = scale;
    }

    @Override
    public boolean isLeftSided() {
        return this.leftSided;
    }

    @Override
    public void setLeftSided(boolean leftSided) {
        this.leftSided = leftSided;
    }

    @Override
    public IGuiAnimatedStat setText(List<String> text) {
        this.textList.clear();
        for (String line : text) {
            for (String s : WordUtils.wrap((String)I18n.func_135052_a((String)line, (Object[])new Object[0]), (int)((int)(28.0f / this.textScale))).split(System.getProperty("line.separator"))) {
                this.textList.add(s);
            }
        }
        return this;
    }

    @Override
    public IGuiAnimatedStat setText(String text) {
        this.textList.clear();
        for (String s : WordUtils.wrap((String)I18n.func_135052_a((String)text, (Object[])new Object[0]), (int)((int)(28.0f / this.textScale))).split(System.getProperty("line.separator"))) {
            this.textList.add(s);
        }
        return this;
    }

    @Override
    public void setTextWithoutCuttingString(List<String> text) {
        this.textList.clear();
        this.textList.addAll(text);
    }

    @Override
    public void setMinDimensionsAndReset(int minWidth, int minHeight) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.width = minWidth;
        this.height = minHeight;
    }

    @Override
    public void update() {
        this.oldBaseX = this.baseX;
        this.oldAffectedY = this.affectedY;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        FontRenderer fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
        this.doneExpanding = true;
        if (this.isClicked) {
            int maxWidth = this.getMaxWidth(fontRenderer);
            int maxHeight = this.getMaxHeight(fontRenderer);
            for (int i = 0; i < 10; ++i) {
                if (this.width < maxWidth) {
                    ++this.width;
                    this.doneExpanding = false;
                }
                if (this.height < maxHeight) {
                    ++this.height;
                    this.doneExpanding = false;
                }
                if (this.width > maxWidth) {
                    --this.width;
                }
                if (this.height <= maxHeight) continue;
                --this.height;
            }
        } else {
            for (int i = 0; i < 10; ++i) {
                if (this.width > this.minWidth) {
                    --this.width;
                }
                if (this.height <= this.minHeight) continue;
                --this.height;
            }
            this.doneExpanding = false;
        }
        this.affectedY = this.baseY;
        if (this.affectingStat != null) {
            this.affectedY += this.affectingStat.getAffectedY() + this.affectingStat.getHeight();
        }
    }

    protected int getMaxWidth(FontRenderer fontRenderer) {
        int maxWidth = fontRenderer.func_78256_a(this.title);
        for (String line : this.textList) {
            if (fontRenderer.func_78256_a(line) <= maxWidth) continue;
            maxWidth = fontRenderer.func_78256_a(line);
        }
        maxWidth = (int)((float)maxWidth * this.textSize);
        return maxWidth += 20;
    }

    protected int getMaxHeight(FontRenderer fontRenderer) {
        int maxHeight = 12;
        if (this.textList.size() > 0) {
            maxHeight += 4 + this.textList.size() * 10;
        }
        maxHeight = (int)((float)maxHeight * this.textSize);
        return maxHeight;
    }

    @Override
    public void render(FontRenderer fontRenderer, float zLevel, float partialTicks) {
        int renderBaseX = (int)((float)this.oldBaseX + (float)(this.baseX - this.oldBaseX) * partialTicks);
        int renderAffectedY = (int)((float)this.oldAffectedY + (float)(this.affectedY - this.oldAffectedY) * partialTicks);
        int renderWidth = (int)((float)this.oldWidth + (float)(this.width - this.oldWidth) * partialTicks);
        int renderHeight = (int)((float)this.oldHeight + (float)(this.height - this.oldHeight) * partialTicks);
        if (this.leftSided) {
            renderWidth *= -1;
        }
        Gui.func_73734_a((int)renderBaseX, (int)renderAffectedY, (int)(renderBaseX + renderWidth), (int)(renderAffectedY + renderHeight), (int)this.backGroundColor);
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)3.0f);
        GL11.glColor4d((double)0.0, (double)0.0, (double)0.0, (double)1.0);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(2);
        tess.func_78377_a((double)renderBaseX, (double)renderAffectedY, (double)zLevel);
        tess.func_78377_a((double)(renderBaseX + renderWidth), (double)renderAffectedY, (double)zLevel);
        tess.func_78377_a((double)(renderBaseX + renderWidth), (double)(renderAffectedY + renderHeight), (double)zLevel);
        tess.func_78377_a((double)renderBaseX, (double)(renderAffectedY + renderHeight), (double)zLevel);
        tess.func_78381_a();
        GL11.glEnable((int)3553);
        if (this.leftSided) {
            renderWidth *= -1;
        }
        if (this.doneExpanding) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(renderBaseX + (this.leftSided ? -renderWidth : 16)), (double)renderAffectedY, (double)0.0);
            GL11.glScaled((double)this.textSize, (double)this.textSize, (double)this.textSize);
            GL11.glTranslated((double)(-renderBaseX - (this.leftSided ? -renderWidth : 16)), (double)(-renderAffectedY), (double)0.0);
            fontRenderer.func_78261_a(this.title, renderBaseX + (this.leftSided ? -renderWidth + 2 : 18), renderAffectedY + 2, 0xFFFF00);
            for (int i = 0; i < this.textList.size(); ++i) {
                if (this.textList.get(i).contains("\u00a70") || this.textList.get(i).contains(EnumChatFormatting.DARK_RED.toString())) {
                    fontRenderer.func_78276_b(this.textList.get(i), renderBaseX + (this.leftSided ? -renderWidth + 2 : 18), renderAffectedY + i * 10 + 12, 0xFFFFFF);
                    continue;
                }
                fontRenderer.func_78261_a(this.textList.get(i), renderBaseX + (this.leftSided ? -renderWidth + 2 : 18), renderAffectedY + i * 10 + 12, 0xFFFFFF);
            }
            GL11.glPopMatrix();
        }
        if (renderHeight > 16 && renderWidth > 16) {
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (this.iStack == null) {
                if (this.iconResLoc == null) {
                    this.iconResLoc = new ResourceLocation(this.texture);
                }
                GuiAnimatedStat.drawTexture(this.iconResLoc, renderBaseX - (this.leftSided ? 16 : 0), renderAffectedY);
            } else if (this.gui != null || !(this.iStack.func_77973_b() instanceof ItemBlock)) {
                this.renderItem(fontRenderer, renderBaseX - (this.leftSided ? 16 : 0), renderAffectedY, this.iStack);
            }
        }
    }

    protected void renderItem(FontRenderer fontRenderer, int x, int y, ItemStack stack) {
        if (this.itemRenderer == null) {
            this.itemRenderer = new RenderItem();
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-50.0);
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        this.itemRenderer.func_82406_b(fontRenderer, FMLClientHandler.instance().getClient().field_71446_o, stack, x, y);
        this.itemRenderer.func_77021_b(fontRenderer, Minecraft.func_71410_x().func_110434_K(), stack, x, y);
        GL11.glEnable((int)3008);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public static void drawTexture(ResourceLocation texture, int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + 16), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)(x + 16), (double)(y + 16), 0.0, 1.0, 1.0);
        tessellator.func_78374_a((double)(x + 16), (double)y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)x, (double)y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    @Override
    public void onMouseClicked(int x, int y, int button) {
        if (button == 0 && this.mouseIsHoveringOverStat(x, y)) {
            this.isClicked = !this.isClicked;
            this.listener.actionPerformed(this);
        }
    }

    @Override
    public void closeWindow() {
        this.isClicked = false;
    }

    @Override
    public void openWindow() {
        this.isClicked = true;
    }

    @Override
    public boolean isClicked() {
        return this.isClicked;
    }

    private boolean mouseIsHoveringOverIcon(int x, int y) {
        if (this.leftSided) {
            return x <= this.baseX && x >= this.baseX - 16 && y >= this.affectedY && y <= this.affectedY + 16;
        }
        return x >= this.baseX && x <= this.baseX + 16 && y >= this.affectedY && y <= this.affectedY + 16;
    }

    private boolean mouseIsHoveringOverStat(int x, int y) {
        if (this.leftSided) {
            return x <= this.baseX && x >= this.baseX - this.width && y >= this.affectedY && y <= this.affectedY + this.height;
        }
        return x >= this.baseX && x <= this.baseX + this.width && y >= this.affectedY && y <= this.affectedY + this.height;
    }

    @Override
    public int getAffectedY() {
        return this.affectedY;
    }

    @Override
    public int getBaseX() {
        return this.baseX;
    }

    @Override
    public int getBaseY() {
        return this.baseY;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setBaseY(int y) {
        this.baseY = y;
    }

    @Override
    public void setTitle(String title) {
        this.title = I18n.func_135052_a((String)title, (Object[])new Object[0]);
    }

    @Override
    public boolean isDoneExpanding() {
        return this.doneExpanding;
    }

    @Override
    public void setBaseX(int x) {
        this.baseX = x;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setListener(IWidgetListener gui) {
        this.listener = gui;
    }

    @Override
    public int getID() {
        return -1;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        this.render(Minecraft.func_71410_x().field_71466_p, 0.0f, partialTick);
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> curTip, boolean shiftPressed) {
        if (this.mouseIsHoveringOverIcon(mouseX, mouseY)) {
            curTip.add(this.title);
        }
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.baseX - (this.leftSided ? this.width : 0), this.affectedY, this.width, this.height);
    }
}

