/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.DoubleBuffer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.vec.Vec3dCube;

@SideOnly(value=Side.CLIENT)
public class RenderUtils {
    private static float zLevel = 0.0f;
    private static RenderItem customRenderItem;

    public static final void vertexWithTexture(double x, double y, double z, float tx, float ty) {
        GL11.glTexCoord2f((float)tx, (float)ty);
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    public static void drawTexturedCube(Vec3dCube cube) {
        GL11.glNormal3d((double)0.0, (double)1.0, (double)0.0);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMaxY(), cube.getMaxZ(), 0.0f, 0.0f);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMaxY(), cube.getMaxZ(), 1.0f, 0.0f);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMaxY(), cube.getMinZ(), 1.0f, 1.0f);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMaxY(), cube.getMinZ(), 0.0f, 1.0f);
        GL11.glNormal3d((double)0.0, (double)-1.0, (double)0.0);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMinY(), cube.getMaxZ(), 0.0f, 0.0f);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMinY(), cube.getMaxZ(), 1.0f, 0.0f);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMinY(), cube.getMinZ(), 1.0f, 1.0f);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMinY(), cube.getMinZ(), 0.0f, 1.0f);
        GL11.glNormal3d((double)-1.0, (double)0.0, (double)0.0);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMinY(), cube.getMaxZ(), 1.0f, 0.0f);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMaxY(), cube.getMaxZ(), 1.0f, 1.0f);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMaxY(), cube.getMinZ(), 0.0f, 1.0f);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMinY(), cube.getMinZ(), 0.0f, 0.0f);
        GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMinY(), cube.getMinZ(), 1.0f, 0.0f);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMaxY(), cube.getMinZ(), 1.0f, 1.0f);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMaxY(), cube.getMaxZ(), 0.0f, 1.0f);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMinY(), cube.getMaxZ(), 0.0f, 0.0f);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)-1.0);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMinY(), cube.getMinZ(), 1.0f, 0.0f);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMaxY(), cube.getMinZ(), 1.0f, 1.0f);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMaxY(), cube.getMinZ(), 0.0f, 1.0f);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMinY(), cube.getMinZ(), 0.0f, 0.0f);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)1.0);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMinY(), cube.getMaxZ(), 0.0f, 0.0f);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMinY(), cube.getMaxZ(), 1.0f, 0.0f);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMaxY(), cube.getMaxZ(), 1.0f, 1.0f);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMaxY(), cube.getMaxZ(), 0.0f, 1.0f);
    }

    public static void drawTexturedCube(Vec3dCube cube, float minU, float minV, float maxU, float maxV) {
        GL11.glNormal3d((double)0.0, (double)1.0, (double)0.0);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMaxY(), cube.getMaxZ(), minU, minV);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMaxY(), cube.getMaxZ(), maxU, minV);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMaxY(), cube.getMinZ(), maxU, maxV);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMaxY(), cube.getMinZ(), minU, maxV);
        GL11.glNormal3d((double)0.0, (double)-1.0, (double)0.0);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMinY(), cube.getMaxZ(), minU, minV);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMinY(), cube.getMaxZ(), maxU, minV);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMinY(), cube.getMinZ(), maxU, maxV);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMinY(), cube.getMinZ(), minU, maxV);
        GL11.glNormal3d((double)-1.0, (double)0.0, (double)0.0);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMinY(), cube.getMaxZ(), maxU, minV);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMaxY(), cube.getMaxZ(), maxU, maxV);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMaxY(), cube.getMinZ(), minU, maxV);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMinY(), cube.getMinZ(), minU, minV);
        GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMinY(), cube.getMinZ(), maxU, minV);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMaxY(), cube.getMinZ(), maxU, maxV);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMaxY(), cube.getMaxZ(), minU, maxV);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMinY(), cube.getMaxZ(), minU, minV);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)-1.0);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMinY(), cube.getMinZ(), maxU, minV);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMaxY(), cube.getMinZ(), maxU, maxV);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMaxY(), cube.getMinZ(), minU, maxV);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMinY(), cube.getMinZ(), minU, minV);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)1.0);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMinY(), cube.getMaxZ(), minU, minV);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMinY(), cube.getMaxZ(), maxU, minV);
        RenderUtils.vertexWithTexture(cube.getMaxX(), cube.getMaxY(), cube.getMaxZ(), maxU, maxV);
        RenderUtils.vertexWithTexture(cube.getMinX(), cube.getMaxY(), cube.getMaxZ(), minU, maxV);
    }

    public static DoubleBuffer planeEquation(double x, double y, double z) {
        return RenderUtils.fromArray(x, y, z, 0.0);
    }

    public static DoubleBuffer fromArray(double ... eq) {
        DoubleBuffer b = BufferUtils.createDoubleBuffer((int)(eq.length * 2)).put(eq);
        b.flip();
        return b;
    }

    public static final void drawTexturedRect(double x, double y, double u, double v, double width, double height) {
        GL11.glPushMatrix();
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)0.0, (double)1.0);
        GL11.glVertex3d((double)x, (double)(y + height), (double)0.0);
        GL11.glTexCoord2d((double)1.0, (double)1.0);
        GL11.glVertex3d((double)(x + width), (double)(y + height), (double)0.0);
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex3d((double)(x + width), (double)y, (double)0.0);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex3d((double)x, (double)y, (double)0.0);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static final void drawColoredRect(double x, double y, double width, double height, int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        GL11.glPushMatrix();
        boolean isTextureEnabled = GL11.glIsEnabled((int)3553);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glBegin((int)7);
        GL11.glVertex3d((double)x, (double)(y + height), (double)0.0);
        GL11.glVertex3d((double)(x + width), (double)(y + height), (double)0.0);
        GL11.glVertex3d((double)(x + width), (double)y, (double)0.0);
        GL11.glVertex3d((double)x, (double)y, (double)0.0);
        GL11.glEnd();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isTextureEnabled) {
            GL11.glEnable((int)3553);
        }
        GL11.glPopMatrix();
    }

    public static final void drawHoveringText(List<String> text, int x, int y, FontRenderer font) {
        if (!text.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : text) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int j2 = x + 12;
            int k2 = y - 12;
            int i1 = 8;
            if (text.size() > 1) {
                i1 += 2 + (text.size() - 1) * 10;
            }
            zLevel = 300.0f;
            int j1 = -267386864;
            RenderUtils.drawGradientRect(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
            RenderUtils.drawGradientRect(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
            RenderUtils.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
            RenderUtils.drawGradientRect(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
            RenderUtils.drawGradientRect(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            RenderUtils.drawGradientRect(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
            RenderUtils.drawGradientRect(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
            RenderUtils.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
            RenderUtils.drawGradientRect(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
            for (int i2 = 0; i2 < text.size(); ++i2) {
                String s1 = text.get(i2);
                font.func_78261_a(s1, j2, k2, -1);
                if (i2 == 0) {
                    k2 += 2;
                }
                k2 += 10;
            }
            zLevel = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }

    public static final void drawGradientRect(int x1, int y1, int x2, int y2, int c1, int c2) {
        float f = (float)(c1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(c1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(c1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(c1 & 0xFF) / 255.0f;
        float f4 = (float)(c2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(c2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(c2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(c2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)x2, (double)y1, (double)zLevel);
        tessellator.func_78377_a((double)x1, (double)y1, (double)zLevel);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)x1, (double)y2, (double)zLevel);
        tessellator.func_78377_a((double)x2, (double)y2, (double)zLevel);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void renderItem(ItemStack item) {
        if (customRenderItem == null) {
            customRenderItem = new RenderItem(){

                public boolean shouldSpreadItems() {
                    return false;
                }
            };
            customRenderItem.func_76976_a(RenderManager.field_78727_a);
        }
        EntityItem ghostEntityItem = new EntityItem((World)Minecraft.func_71410_x().field_71441_e);
        ghostEntityItem.field_70290_d = 0.0f;
        ghostEntityItem.func_92058_a(item);
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        if (item.func_77973_b() instanceof ItemBlock) {
            ItemBlock testItem = (ItemBlock)item.func_77973_b();
            Block testBlock = testItem.field_150939_a;
            if (RenderBlocks.func_147739_a((int)testBlock.func_149645_b())) {
                GL11.glScaled((double)1.2, (double)1.2, (double)1.2);
            }
        }
        customRenderItem.func_76986_a(ghostEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
    }

    public static void drawColoredCube() {
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)1.0f);
    }
}

