/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.helper;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDropper;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockNote;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockTNT;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityComparator;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.part.compat.IMultipartCompat;
import uk.co.qmunity.lib.part.compat.MultipartSystem;
import uk.co.qmunity.lib.vec.Vec3i;

public class RedstoneHelper {
    public static int getVanillaSignalStrength(World world, int x, int y, int z, ForgeDirection side, ForgeDirection face) {
        int d;
        if (face != ForgeDirection.DOWN && face != ForgeDirection.UNKNOWN) {
            return 0;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150488_af) {
            if (side == ForgeDirection.DOWN) {
                return world.func_72805_g(x, y, z);
            }
            if (side == ForgeDirection.UP) {
                return 0;
            }
            d = Direction.func_82372_a((double)side.offsetX, (double)side.offsetZ);
            if (BlockRedstoneWire.func_150174_f((IBlockAccess)world, (int)x, (int)y, (int)z, (int)d) || BlockRedstoneWire.func_150174_f((IBlockAccess)world, (int)(x + side.offsetX + side.offsetX), (int)(y + side.offsetY + side.offsetY), (int)(z + side.offsetZ + side.offsetZ), (int)((d + 2) % 4))) {
                return world.func_72805_g(x, y, z);
            }
        }
        if (block instanceof BlockRedstoneComparator && block == Blocks.field_150413_aR) {
            return 0;
        }
        if (block == Blocks.field_150416_aS) {
            if (side == ForgeDirection.DOWN || side == ForgeDirection.UP) {
                return 0;
            }
            d = Direction.func_82372_a((double)side.offsetX, (double)side.offsetZ);
            return d == world.func_72805_g(x, y, z) % 4 ? 15 : 0;
        }
        if (block instanceof BlockRedstoneComparator) {
            if (side == ForgeDirection.DOWN || side == ForgeDirection.UP) {
                return 0;
            }
            d = Direction.func_82372_a((double)side.offsetX, (double)side.offsetZ);
            return d == world.func_72805_g(x, y, z) % 4 ? ((TileEntityComparator)world.func_147438_o(x, y, z)).func_145996_a() : 0;
        }
        return 0;
    }

    public static boolean canConnectVanilla(World world, int x, int y, int z, ForgeDirection side, ForgeDirection face) {
        if (side == ForgeDirection.UNKNOWN) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        int d = Direction.func_82372_a((double)side.offsetX, (double)side.offsetZ);
        if (!(block != Blocks.field_150413_aR && block != Blocks.field_150416_aS || face != ForgeDirection.DOWN && face != ForgeDirection.UNKNOWN || d % 2 != meta % 2)) {
            return true;
        }
        if (block instanceof BlockLever) {
            ForgeDirection leverFace;
            ForgeDirection forgeDirection = (meta %= 8) == 0 || meta == 7 ? ForgeDirection.UP : (meta == 5 || meta == 6 ? ForgeDirection.DOWN : (meta == 1 ? ForgeDirection.WEST : (meta == 2 ? ForgeDirection.EAST : (meta == 3 ? ForgeDirection.NORTH : (leverFace = meta == 4 ? ForgeDirection.SOUTH : ForgeDirection.UNKNOWN)))));
            if (face != ForgeDirection.UNKNOWN && face != leverFace) {
                return false;
            }
            return side != leverFace.getOpposite();
        }
        if (block instanceof BlockRedstoneComparator && (face == ForgeDirection.DOWN || face == ForgeDirection.UNKNOWN)) {
            return side != ForgeDirection.UP;
        }
        if (block instanceof BlockRedstoneWire) {
            return face == ForgeDirection.UNKNOWN || face == ForgeDirection.DOWN;
        }
        return block instanceof BlockDoor || block instanceof BlockRedstoneLight || block instanceof BlockTNT || block instanceof BlockDispenser || block instanceof BlockDropper || block instanceof BlockNote || block instanceof BlockPistonBase;
    }

    private static boolean isVanillaBlock(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        return b instanceof BlockRedstoneRepeater || b instanceof BlockLever || b instanceof BlockRedstoneWire || b instanceof BlockRedstoneComparator || b instanceof BlockDoor || b instanceof BlockRedstoneLight || b instanceof BlockTNT || b instanceof BlockDispenser || b instanceof BlockDropper || b instanceof BlockNote || b instanceof BlockPistonBase;
    }

    public static int getOutputWeak(World world, int x, int y, int z, ForgeDirection side, ForgeDirection face) {
        Vec3i location = new Vec3i(x, y, z);
        for (MultipartSystem s : MultipartSystem.getAvailableSystems()) {
            IMultipartCompat compat = s.getCompat();
            if (!compat.isMultipart(world, location)) continue;
            return compat.getWeakRedstoneOuput(world, location, side, face);
        }
        Block block = world.func_147439_a(x, y, z);
        int power = block.func_149709_b((IBlockAccess)world, x, y, z, side.getOpposite().ordinal());
        if (power > 0) {
            return power;
        }
        if (block.isNormalCube((IBlockAccess)world, x, y, z) && block.func_149662_c()) {
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                if (d == side) continue;
                power = Math.max(power, RedstoneHelper.getOutputStrong(world, x + d.offsetX, y + d.offsetY, z + d.offsetZ, d.getOpposite(), ForgeDirection.UNKNOWN));
            }
        }
        return power;
    }

    public static int getOutputStrong(World world, int x, int y, int z, ForgeDirection side, ForgeDirection face) {
        Vec3i location = new Vec3i(x, y, z);
        for (MultipartSystem s : MultipartSystem.getAvailableSystems()) {
            IMultipartCompat compat = s.getCompat();
            if (!compat.isMultipart(world, location)) continue;
            return compat.getStrongRedstoneOuput(world, location, side, face);
        }
        int power = RedstoneHelper.getVanillaSignalStrength(world, x, y, z, side, face);
        if (power > 0) {
            return power;
        }
        return world.func_147439_a(x, y, z).func_149748_c((IBlockAccess)world, x, y, z, side.getOpposite().ordinal());
    }

    public static int getOutputWeak(World world, int x, int y, int z, ForgeDirection side) {
        return RedstoneHelper.getOutputWeak(world, x, y, z, side, ForgeDirection.UNKNOWN);
    }

    public static int getOutputStrong(World world, int x, int y, int z, ForgeDirection side) {
        return RedstoneHelper.getOutputStrong(world, x, y, z, side, ForgeDirection.UNKNOWN);
    }

    public static int getOutput(World world, int x, int y, int z, ForgeDirection side) {
        return Math.max(RedstoneHelper.getOutputWeak(world, x, y, z, side), RedstoneHelper.getOutputStrong(world, x, y, z, side));
    }

    public static int getOutput(World world, int x, int y, int z, ForgeDirection side, ForgeDirection face) {
        return Math.max(RedstoneHelper.getOutputWeak(world, x, y, z, side, face), RedstoneHelper.getOutputStrong(world, x, y, z, side, face));
    }

    public static int getOutput(World world, int x, int y, int z) {
        int power = 0;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            power = Math.max(power, RedstoneHelper.getOutput(world, x, y, z, side));
        }
        return power;
    }

    public static int getInputWeak(World world, int x, int y, int z, ForgeDirection side, ForgeDirection face) {
        return RedstoneHelper.getOutputWeak(world, x + side.offsetX, y + side.offsetY, z + side.offsetZ, side.getOpposite(), face);
    }

    public static int getInputStrong(World world, int x, int y, int z, ForgeDirection side, ForgeDirection face) {
        return RedstoneHelper.getOutputStrong(world, x + side.offsetX, y + side.offsetY, z + side.offsetZ, side.getOpposite(), face);
    }

    public static int getInputWeak(World world, int x, int y, int z, ForgeDirection side) {
        return RedstoneHelper.getOutputWeak(world, x + side.offsetX, y + side.offsetY, z + side.offsetZ, side.getOpposite());
    }

    public static int getInputStrong(World world, int x, int y, int z, ForgeDirection side) {
        return RedstoneHelper.getOutputStrong(world, x + side.offsetX, y + side.offsetY, z + side.offsetZ, side.getOpposite());
    }

    public static int getInput(World world, int x, int y, int z, ForgeDirection side) {
        return RedstoneHelper.getOutput(world, x + side.offsetX, y + side.offsetY, z + side.offsetZ, side.getOpposite());
    }

    public static int getInput(World world, int x, int y, int z, ForgeDirection side, ForgeDirection face) {
        return RedstoneHelper.getOutput(world, x + side.offsetX, y + side.offsetY, z + side.offsetZ, side.getOpposite(), face);
    }

    public static int getInput(World world, int x, int y, int z) {
        int power = 0;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            power = Math.max(power, RedstoneHelper.getInput(world, x, y, z, side));
        }
        return power;
    }

    public static boolean canConnect(World world, int x, int y, int z, ForgeDirection side, ForgeDirection face) {
        Vec3i location = new Vec3i(x, y, z);
        if (RedstoneHelper.isVanillaBlock(world, x, y, z)) {
            return RedstoneHelper.canConnectVanilla(world, x, y, z, side, face);
        }
        for (MultipartSystem s : MultipartSystem.getAvailableSystems()) {
            IMultipartCompat compat = s.getCompat();
            if (!compat.isMultipart(world, location)) continue;
            return compat.canConnectRedstone(world, location, side, face);
        }
        try {
            return world.func_147439_a(x, y, z).canConnectRedstone((IBlockAccess)world, x, y, z, Direction.func_82372_a((double)side.offsetX, (double)side.offsetZ));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean canConnect(World world, int x, int y, int z, ForgeDirection side) {
        return RedstoneHelper.canConnect(world, x, y, z, side, ForgeDirection.UNKNOWN);
    }

    public static void notifyRedstoneUpdate(World world, int x, int y, int z, ForgeDirection direction, boolean strong) {
        int x_ = x + direction.offsetX;
        int y_ = y + direction.offsetY;
        int z_ = z + direction.offsetZ;
        if (world == null) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        world.func_147460_e(x_, y_, z_, block);
        if (strong) {
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                if (d == direction.getOpposite()) continue;
                world.func_147460_e(x_ + d.offsetX, y_ + d.offsetY, z_ + d.offsetZ, block);
            }
        }
    }
}

