/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.network.packet;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import uk.co.qmunity.lib.network.LocatedPacket;
import uk.co.qmunity.lib.network.NetworkHandler;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.compat.MultipartCompatibility;

public abstract class PacketCPart
extends LocatedPacket<PacketCPart> {
    protected ITilePartHolder holder = null;
    protected IPart part = null;
    protected String partId = null;

    public PacketCPart(ITilePartHolder holder, IPart part) {
        super(holder);
        this.holder = holder;
        this.part = part;
    }

    public PacketCPart() {
    }

    public abstract void handle(EntityPlayer var1);

    public abstract void writeData(DataOutput var1) throws IOException;

    public abstract void readData(DataInput var1) throws IOException;

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void handleClientSide(EntityPlayer player) {
        if (player == null || player.field_70170_p == null) {
            return;
        }
        this.holder = MultipartCompatibility.getPartHolder(player.field_70170_p, this.x, this.y, this.z);
        if (this.holder != null && this.holder.getPartMap().containsKey(this.partId)) {
            this.part = this.holder.getPartMap().get(this.partId);
        }
        this.doHandle(player);
    }

    @Override
    public final void handleServerSide(EntityPlayer player) {
    }

    public void doHandle(EntityPlayer player) {
        this.holder = MultipartCompatibility.getPartHolder(player.field_70170_p, this.x, this.y, this.z);
        if (this.holder != null) {
            this.part = this.holder.getPartMap().get(this.partId);
        }
        this.handle(player);
    }

    @Override
    public void write(DataOutput buffer) throws IOException {
        super.write(buffer);
        String partId = null;
        Map<String, IPart> parts = this.holder.getPartMap();
        for (String id : parts.keySet()) {
            if (parts.get(id) != this.part) continue;
            partId = id;
            break;
        }
        if (partId == null) {
            buffer.writeBoolean(false);
            return;
        }
        buffer.writeBoolean(true);
        buffer.writeUTF(partId);
        this.writeData(buffer);
    }

    @Override
    public void read(DataInput buffer) throws IOException {
        super.read(buffer);
        if (!buffer.readBoolean()) {
            return;
        }
        this.partId = buffer.readUTF();
        this.readData(buffer);
    }

    public void send() {
        NetworkHandler.QLIB.sendToAllAround(this, this.holder.getWorld(), 64.0);
    }
}

