/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.part;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.helper.ItemHelper;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.compat.OcclusionHelper;
import uk.co.qmunity.lib.raytrace.QMovingObjectPosition;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public abstract class PartBase
implements IPart {
    private ITilePartHolder parent;

    @Override
    public World getWorld() {
        return this.getParent().getWorld();
    }

    @Override
    public int getX() {
        return this.getParent().getX();
    }

    @Override
    public int getY() {
        return this.getParent().getY();
    }

    @Override
    public int getZ() {
        return this.getParent().getZ();
    }

    @Override
    public ITilePartHolder getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ITilePartHolder parent) {
        this.parent = parent;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void writeUpdateData(DataOutput buffer, int channel) throws IOException {
        if (channel == -1) {
            this.writeUpdateData(buffer);
        }
    }

    @Override
    public void readUpdateData(DataInput buffer, int channel) throws IOException {
        if (channel == -1) {
            this.readUpdateData(buffer);
        }
    }

    @Override
    public void sendUpdatePacket(int channel) {
        if (this.parent != null && this.getWorld() != null) {
            this.parent.sendUpdatePacket(this, channel);
        }
    }

    public void writeUpdateData(DataOutput buffer) throws IOException {
    }

    public void readUpdateData(DataInput buffer) throws IOException {
    }

    public void sendUpdatePacket() {
        this.sendUpdatePacket(-1);
    }

    @Override
    public ItemStack getPickedItem(QMovingObjectPosition mop) {
        return this.getItem();
    }

    @Override
    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack is = this.getItem();
        if (is != null) {
            is.field_77994_a = 1;
            items.add(is);
        }
        return items;
    }

    @Override
    public boolean breakAndDrop(EntityPlayer player, QMovingObjectPosition mop) {
        List<ItemStack> drops = this.getDrops();
        if (!(player != null && player.field_71075_bZ.field_75098_d || drops == null || drops.size() <= 0)) {
            for (ItemStack item : drops) {
                ItemHelper.dropItem(this.getWorld(), this.getX(), this.getY(), this.getZ(), item);
            }
        }
        return true;
    }

    @Override
    public double getHardness(EntityPlayer player, QMovingObjectPosition mop) {
        return 0.1;
    }

    @Override
    public int getLightValue() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderBreaking(Vec3i translation, RenderHelper renderer, RenderBlocks renderBlocks, int pass, QMovingObjectPosition mop) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vec3i translation, RenderHelper renderer, RenderBlocks renderBlocks, int pass) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vec3d translation, double delta, int pass) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderOnPass(int pass) {
        return pass == 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vec3dCube getRenderBounds() {
        return new Vec3dCube(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public boolean occlusionTest(IPart part) {
        return OcclusionHelper.occlusionTest((IPart)this, part);
    }
}

