/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.part.compat;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.part.IMicroblock;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.IPartCustomPlacement;
import uk.co.qmunity.lib.part.IPartPlacement;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.PartPlacementDefault;
import uk.co.qmunity.lib.part.compat.IMultipartCompat;
import uk.co.qmunity.lib.part.compat.MultipartSystem;
import uk.co.qmunity.lib.part.compat.PartUpdateManager;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class MultipartCompatibility {
    public static boolean addPartToWorld(IPart part, World world, Vec3i location) {
        return MultipartCompatibility.addPartToWorld(part, world, location, false);
    }

    public static boolean addPartToWorld(IPart part, World world, Vec3i location, boolean simulated) {
        for (MultipartSystem s : MultipartSystem.getAvailableSystems()) {
            if (!world.func_147437_c(location.getX(), location.getY(), location.getZ()) && !s.getCompat().isMultipart(world, location) && !s.getCompat().canBeMultipart(world, location) || !s.getCompat().addPartToWorld(part, world, location, simulated)) continue;
            return true;
        }
        return false;
    }

    public static boolean addPartToWorldBruteforce(IPart part, World world, Vec3i location) {
        for (MultipartSystem s : MultipartSystem.getAvailableSystems()) {
            if (!world.func_147437_c(location.getX(), location.getY(), location.getZ()) && !s.getCompat().isMultipart(world, location) && !s.getCompat().canBeMultipart(world, location) || !s.getCompat().addPartToWorldBruteforce(part, world, location)) continue;
            return true;
        }
        return false;
    }

    public static boolean placePartInWorld(IPart part, World world, Vec3i location, ForgeDirection clickedFace, EntityPlayer player, ItemStack item) {
        return MultipartCompatibility.placePartInWorld(part, world, location, clickedFace, player, item, false);
    }

    public static boolean placePartInWorld(IPart part, World world, Vec3i location, ForgeDirection clickedFace, EntityPlayer player, ItemStack item, boolean simulated) {
        if (simulated) {
            PartUpdateManager.setUpdatesEnabled(false);
        }
        LinkedHashMap<IMultipartCompat, Integer> passes = new LinkedHashMap<IMultipartCompat, Integer>();
        int totalPasses = 0;
        for (MultipartSystem s : MultipartSystem.getAvailableSystems()) {
            IMultipartCompat c = s.getCompat();
            int p = c.getPlacementPasses();
            passes.put(c, p);
            totalPasses = Math.max(totalPasses, p);
        }
        for (int pass = 0; pass < totalPasses; ++pass) {
            for (IMultipartCompat c : passes.keySet()) {
                if (pass >= (Integer)passes.get(c) || !c.placePartInWorld(part, world, location.clone(), clickedFace, player, item, pass, simulated)) continue;
                if (!player.field_71075_bZ.field_75098_d && !simulated) {
                    --item.field_77994_a;
                }
                if (simulated) {
                    PartUpdateManager.setUpdatesEnabled(true);
                }
                return true;
            }
        }
        if (simulated) {
            PartUpdateManager.setUpdatesEnabled(true);
        }
        return false;
    }

    public static ITilePartHolder getPartHolder(World world, Vec3i location) {
        if (world == null) {
            return null;
        }
        for (MultipartSystem s : MultipartSystem.getAvailableSystems()) {
            if (!s.getCompat().isMultipart(world, location)) continue;
            return s.getCompat().getPartHolder(world, location);
        }
        return null;
    }

    public static ITilePartHolder getPartHolder(World world, int x, int y, int z) {
        return MultipartCompatibility.getPartHolder(world, new Vec3i(x, y, z));
    }

    public static List<IMicroblock> getMicroblocks(World world, int x, int y, int z) {
        return MultipartCompatibility.getMicroblocks(world, new Vec3i(x, y, z));
    }

    public static List<IMicroblock> getMicroblocks(World world, Vec3i location) {
        ArrayList<IMicroblock> l = new ArrayList<IMicroblock>();
        for (MultipartSystem s : MultipartSystem.getAvailableSystems()) {
            List<IMicroblock> ls = s.getCompat().getMicroblocks(world, location);
            if (ls == null) continue;
            for (IMicroblock m : ls) {
                if (l.contains(m)) continue;
                l.add(m);
            }
        }
        return l;
    }

    public static IPart getPart(World world, Vec3i location, String type) {
        ITilePartHolder h = MultipartCompatibility.getPartHolder(world, location);
        if (h == null) {
            return null;
        }
        for (IPart p : h.getParts()) {
            if (p.getType() != type) continue;
            return p;
        }
        return null;
    }

    public static IPart getPart(World world, int x, int y, int z, String type) {
        return MultipartCompatibility.getPart(world, new Vec3i(x, y, z), type);
    }

    public static <T> T getPart(World world, Vec3i location, Class<T> type) {
        ITilePartHolder h = MultipartCompatibility.getPartHolder(world, location);
        if (h == null) {
            return null;
        }
        for (IPart p : h.getParts()) {
            if (!type.isAssignableFrom(p.getClass())) continue;
            return (T)p;
        }
        return null;
    }

    public static <T> T getPart(World world, int x, int y, int z, Class<T> type) {
        return MultipartCompatibility.getPart(world, new Vec3i(x, y, z), type);
    }

    public static boolean checkOcclusion(World world, Vec3i location, Vec3dCube cube) {
        for (MultipartSystem s : MultipartSystem.getAvailableSystems()) {
            if (!s.getCompat().isMultipart(world, location) && !s.getCompat().canBeMultipart(world, location)) continue;
            return s.getCompat().checkOcclusion(world, location, cube);
        }
        return false;
    }

    public static boolean checkOcclusion(World world, int x, int y, int z, Vec3dCube cube) {
        return MultipartCompatibility.checkOcclusion(world, new Vec3i(x, y, z), cube);
    }

    public static IPartPlacement getPlacementForPart(IPart part, World world, Vec3i location, ForgeDirection face, MovingObjectPosition mop, EntityPlayer player) {
        IPartPlacement placement = null;
        if (!(part instanceof IPartCustomPlacement)) {
            return new PartPlacementDefault();
        }
        placement = ((IPartCustomPlacement)part).getPlacement(part, world, location, face, mop, player);
        if (placement != null) {
            return placement;
        }
        return null;
    }
}

