/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.part.compat.fmp;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.ExtendedMOP;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.microblock.Microblock;
import codechicken.multipart.INeighborTileChange;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.PartMap;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TNormalOcclusion;
import codechicken.multipart.TSlottedPart;
import codechicken.multipart.scalatraits.TSlottedTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.QmunityLib;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.client.renderer.RenderMultipart;
import uk.co.qmunity.lib.part.IMicroblock;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.IPartCenter;
import uk.co.qmunity.lib.part.IPartCollidable;
import uk.co.qmunity.lib.part.IPartInteractable;
import uk.co.qmunity.lib.part.IPartOccluding;
import uk.co.qmunity.lib.part.IPartRedstone;
import uk.co.qmunity.lib.part.IPartSelectable;
import uk.co.qmunity.lib.part.IPartSelectableCustom;
import uk.co.qmunity.lib.part.IPartSolid;
import uk.co.qmunity.lib.part.IPartThruHole;
import uk.co.qmunity.lib.part.IPartTicking;
import uk.co.qmunity.lib.part.IPartUpdateListener;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.PartRegistry;
import uk.co.qmunity.lib.part.compat.MultipartSystem;
import uk.co.qmunity.lib.part.compat.OcclusionHelper;
import uk.co.qmunity.lib.part.compat.PartUpdateManager;
import uk.co.qmunity.lib.part.compat.fmp.FMPDataInput;
import uk.co.qmunity.lib.part.compat.fmp.FMPDataOutput;
import uk.co.qmunity.lib.part.compat.fmp.FMPMicroblock;
import uk.co.qmunity.lib.part.compat.fmp.IFMPPart;
import uk.co.qmunity.lib.raytrace.QMovingObjectPosition;
import uk.co.qmunity.lib.raytrace.RayTracer;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class FMPPart
extends TMultiPart
implements ITilePartHolder,
TNormalOcclusion,
IRedstonePart,
INeighborTileChange,
IFMPPart,
ISidedHollowConnect,
TSlottedPart {
    private Map<String, IPart> parts = new HashMap<String, IPart>();
    private List<IPart> added = new ArrayList<IPart>();
    private boolean shouldDieInAFire = false;
    private boolean loaded = false;
    private boolean converted = false;
    private final boolean simulated;
    private boolean firstTick = true;

    public FMPPart(boolean simulated) {
        this.simulated = simulated;
    }

    public FMPPart() {
        this(false);
    }

    public FMPPart(Map<String, IPart> parts) {
        this();
        this.parts = parts;
    }

    public String getType() {
        return "qmunitylib_multipart";
    }

    @Override
    public List<IPart> getParts() {
        ArrayList<IPart> parts = new ArrayList<IPart>();
        for (String s : this.parts.keySet()) {
            IPart p = this.parts.get(s);
            if (p.getParent() == null) continue;
            parts.add(p);
        }
        return parts;
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        ArrayList<IndexedCuboid6> cubes = new ArrayList<IndexedCuboid6>();
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartSelectable)) continue;
            for (Vec3dCube c : ((IPartSelectable)p).getSelectionBoxes()) {
                cubes.add(new IndexedCuboid6((Object)0, new Cuboid6(c.clone().expand(0.001).toAABB())));
            }
        }
        if (cubes.size() == 0) {
            cubes.add(new IndexedCuboid6((Object)0, new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)));
        }
        return cubes;
    }

    public ExtendedMOP collisionRayTrace(Vec3 start, Vec3 end) {
        QMovingObjectPosition qmop = this.rayTrace(new Vec3d(start), new Vec3d(end));
        if (qmop == null) {
            return null;
        }
        new Cuboid6(qmop.getCube().clone().expand(0.001).toAABB()).setBlockBounds(this.tile().func_145838_q());
        Vec3 v = qmop.field_72307_f.func_72444_a(start);
        return new ExtendedMOP((MovingObjectPosition)qmop, (Object)0, v.field_72450_a * v.field_72450_a + v.field_72448_b * v.field_72448_b + v.field_72449_c * v.field_72449_c);
    }

    public void update() {
        if (this.firstTick) {
            if (this.converted) {
                for (IPart p : this.getParts()) {
                    if (!(p instanceof IPartUpdateListener)) continue;
                    ((IPartUpdateListener)p).onConverted();
                }
            } else if (!this.loaded) {
                for (IPart p : this.added) {
                    if (!(p instanceof IPartUpdateListener)) continue;
                    ((IPartUpdateListener)p).onAdded();
                }
            } else {
                for (IPart p : this.added) {
                    ((IPartUpdateListener)p).onLoaded();
                }
            }
            if (!this.world().field_72995_K) {
                this.sendDescUpdate();
            }
            this.firstTick = false;
        }
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartTicking)) continue;
            ((IPartTicking)p).update();
        }
        if (!this.world().field_72995_K && (this.shouldDieInAFire || this.getParts().size() == 0)) {
            this.tile().remPart((TMultiPart)this);
        }
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        NBTTagList l = new NBTTagList();
        for (Map.Entry<String, IPart> e : this.getPartMap().entrySet()) {
            NBTTagCompound t = new NBTTagCompound();
            t.func_74778_a("id", e.getKey());
            t.func_74778_a("type", e.getValue().getType());
            NBTTagCompound data = new NBTTagCompound();
            e.getValue().writeToNBT(data);
            t.func_74782_a("data", (NBTBase)data);
            l.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("parts", (NBTBase)l);
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        NBTTagList l = tag.func_150295_c("parts", (int)new NBTTagCompound().func_74732_a());
        for (int i = 0; i < l.func_74745_c(); ++i) {
            NBTTagCompound t = l.func_150305_b(i);
            String id = t.func_74779_i("id");
            IPart p = this.getPart(id);
            if (p == null) {
                p = PartRegistry.createPart(t.func_74779_i("type"), false);
                if (p == null) continue;
                p.setParent(this);
                this.parts.put(id, p);
            }
            NBTTagCompound data = t.func_74775_l("data");
            p.readFromNBT(data);
        }
        if (this.getParts().size() == 0) {
            this.shouldDieInAFire = true;
        }
        this.loaded = true;
        if (this.tile() != null && this.getWorld() != null) {
            this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
        }
    }

    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        FMPDataOutput buffer = new FMPDataOutput(packet);
        try {
            buffer.writeInt(this.getPartMap().size());
            for (Map.Entry<String, IPart> e : this.getPartMap().entrySet()) {
                buffer.writeUTF(e.getKey());
                buffer.writeUTF(e.getValue().getType());
                e.getValue().writeUpdateData(buffer, -1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        FMPDataInput buffer = new FMPDataInput(packet);
        try {
            int amt = buffer.readInt();
            for (int i = 0; i < amt; ++i) {
                String id = buffer.readUTF();
                String type = buffer.readUTF();
                IPart p = this.getPart(id);
                if (p == null) {
                    p = PartRegistry.createPart(type, true);
                    if (p == null) continue;
                    p.setParent(this);
                    this.parts.put(id, p);
                }
                p.readUpdateData(buffer, -1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public World getWorld() {
        return this.world();
    }

    @Override
    public int getX() {
        return this.x();
    }

    @Override
    public int getY() {
        return this.y();
    }

    @Override
    public int getZ() {
        return this.z();
    }

    @Override
    public void addPart(IPart part) {
        int before = this.parts.size();
        this.parts.put(this.genIdentifier(), part);
        part.setParent(this);
        if (!this.simulated) {
            if (part instanceof IPartUpdateListener) {
                ((IPartUpdateListener)part).onAdded();
            }
            for (IPart p : this.getParts()) {
                if (p == part || !(p instanceof IPartUpdateListener)) continue;
                ((IPartUpdateListener)p).onPartChanged(part);
            }
            if (before > 0) {
                PartUpdateManager.addPart(this, part);
            }
            if (this.tile() != null) {
                this.tile().func_70296_d();
                this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
                if (!this.getWorld().field_72995_K && before > 0) {
                    this.getWorld().func_147459_d(this.getX(), this.getY(), this.getZ(), this.tile().field_145854_h);
                }
            }
        }
    }

    @Override
    public boolean removePart(IPart part) {
        if (part == null) {
            return false;
        }
        if (!this.parts.containsValue(part)) {
            return false;
        }
        if (!this.simulated) {
            PartUpdateManager.removePart(this, part);
            if (part instanceof IPartUpdateListener) {
                ((IPartUpdateListener)part).onRemoved();
            }
        }
        String id = this.getIdentifier(part);
        this.parts.remove(id);
        part.setParent(null);
        if (!this.simulated) {
            for (IPart p : this.getParts()) {
                if (p == part || !(p instanceof IPartUpdateListener)) continue;
                ((IPartUpdateListener)p).onPartChanged(part);
            }
            this.tile().func_70296_d();
            this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
            if (!this.getWorld().field_72995_K) {
                this.getWorld().func_147459_d(this.getX(), this.getY(), this.getZ(), this.tile().field_145854_h);
            }
            this.refreshSlots();
        }
        return true;
    }

    private void refreshSlots() {
        if (this.tile() instanceof TSlottedTile) {
            TSlottedTile t = (TSlottedTile)this.tile();
            TMultiPart[] old = t.v_partMap();
            TMultiPart[] parts = new TMultiPart[old.length];
            for (int i = 0; i < old.length; ++i) {
                if (old[i] == null || old[i] == this) continue;
                parts[i] = old[i];
            }
            t.v_partMap_$eq(parts);
            t.bindPart((TMultiPart)this);
        }
    }

    private String genIdentifier() {
        String s = null;
        while (this.parts.containsKey(s = UUID.randomUUID().toString())) {
        }
        return s;
    }

    private String getIdentifier(IPart part) {
        for (String s : this.parts.keySet()) {
            if (!this.parts.get(s).equals(part)) continue;
            return s;
        }
        return null;
    }

    private IPart getPart(String id) {
        for (String s : this.parts.keySet()) {
            if (!s.equals(id)) continue;
            return this.parts.get(s);
        }
        return null;
    }

    @Override
    public boolean canAddPart(IPart part) {
        if (this.tile() == null) {
            return true;
        }
        if (part instanceof IPartCollidable) {
            ArrayList<Vec3dCube> cubes = new ArrayList<Vec3dCube>();
            ((IPartCollidable)part).addCollisionBoxesToList(cubes, null);
            for (Vec3dCube c : cubes) {
                if (this.getWorld().func_72855_b(c.clone().add(this.getX(), this.getY(), this.getZ()).toAABB())) continue;
                return false;
            }
        }
        if (part instanceof IPartOccluding) {
            for (Vec3dCube b : ((IPartOccluding)part).getOcclusionBoxes()) {
                NormallyOccludedPart nop = new NormallyOccludedPart(new Cuboid6(b.toAABB()));
                try {
                    if (this.tile().canAddPart((TMultiPart)nop)) continue;
                    return false;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }
        return OcclusionHelper.occlusionTest((ITilePartHolder)this, part);
    }

    @Override
    public QMovingObjectPosition rayTrace(Vec3d start, Vec3d end) {
        QMovingObjectPosition closest = null;
        double dist = Double.MAX_VALUE;
        for (IPart p : this.getParts()) {
            double d;
            QMovingObjectPosition mop;
            if (!(p instanceof IPartSelectable) || (mop = ((IPartSelectable)p).rayTrace(start, end)) == null || !((d = start.distanceTo(new Vec3d(mop.field_72307_f))) < dist)) continue;
            closest = mop;
            dist = d;
        }
        return closest;
    }

    @Override
    public void sendUpdatePacket(IPart part, int channel) {
        if (this.tile() != null && this.world() != null && this.getParts().contains(part)) {
            PartUpdateManager.sendPartUpdate(this, part, channel);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vector3 pos, int pass) {
        boolean did = false;
        RenderBlocks renderer = RenderBlocks.getInstance();
        RenderHelper.instance.setRenderCoords((IBlockAccess)this.getWorld(), (int)pos.x, (int)pos.y, (int)pos.z);
        renderer.field_147845_a = this.getWorld();
        for (IPart p : this.getParts()) {
            if (p.getParent() == null || !p.shouldRenderOnPass(pass)) continue;
            p.renderStatic(new Vec3i((int)pos.x, (int)pos.y, (int)pos.z), RenderHelper.instance, renderer, pass);
            RenderHelper.instance.resetRenderedSides();
            RenderHelper.instance.resetTextureRotations();
            RenderHelper.instance.resetTransformations();
            RenderHelper.instance.setColor(0xFFFFFF);
        }
        renderer.field_147845_a = null;
        RenderHelper.instance.reset();
        return did;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)pos.x, (double)pos.y, (double)pos.z);
        for (IPart p : this.getParts()) {
            if (p.getParent() == null) continue;
            GL11.glPushMatrix();
            if (p.shouldRenderOnPass(pass)) {
                p.renderDynamic(new Vec3d(0.0, 0.0, 0.0), frame, pass);
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBreaking(RenderBlocks renderBlocks) {
        QMovingObjectPosition mop = this.rayTrace(RayTracer.getStartVector((EntityPlayer)Minecraft.func_71410_x().field_71439_g), RayTracer.getEndVector((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        if (mop == null || mop.getPart() == null) {
            return;
        }
        RenderHelper.instance.setRenderCoords((IBlockAccess)this.getWorld(), this.getX(), this.getY(), this.getZ());
        RenderMultipart.renderBreaking((IBlockAccess)this.getWorld(), this.getX(), this.getY(), this.getZ(), renderBlocks, mop);
        RenderHelper.instance.reset();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean drawHighlight(MovingObjectPosition hit, EntityPlayer player, float frame) {
        QMovingObjectPosition mop = this.rayTrace(RayTracer.getStartVector((EntityPlayer)Minecraft.func_71410_x().field_71439_g), RayTracer.getEndVector((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        if (mop == null || mop.getPart() == null || !(mop.getPart() instanceof IPartSelectableCustom)) {
            return false;
        }
        return ((IPartSelectableCustom)mop.getPart()).drawHighlight(mop, player, frame);
    }

    @Override
    public void addCollisionBoxesToList(List<Vec3dCube> l, AxisAlignedBB bounds, Entity entity) {
        ArrayList<Vec3dCube> boxes = new ArrayList<Vec3dCube>();
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartCollidable)) continue;
            ArrayList<Vec3dCube> boxes_ = new ArrayList<Vec3dCube>();
            ((IPartCollidable)p).addCollisionBoxesToList(boxes_, entity);
            for (Vec3dCube c : boxes_) {
                Vec3dCube cube = c.clone();
                cube.add(this.getX(), this.getY(), this.getZ());
                cube.setPart(p);
                boxes.add(cube);
            }
            boxes_.clear();
        }
        for (Vec3dCube c : boxes) {
            if (!c.toAABB().func_72326_a(bounds)) continue;
            l.add(c);
        }
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        ArrayList<Cuboid6> cubes = new ArrayList<Cuboid6>();
        ArrayList<Vec3dCube> boxes = new ArrayList<Vec3dCube>();
        this.addCollisionBoxesToList(boxes, AxisAlignedBB.func_72330_a((double)this.x(), (double)this.y(), (double)this.z(), (double)(this.x() + 1), (double)(this.y() + 1), (double)(this.z() + 1)), null);
        for (Vec3dCube c : boxes) {
            cubes.add(new Cuboid6(c.clone().add(-this.x(), -this.y(), -this.z()).toAABB()));
        }
        return cubes;
    }

    public void onNeighborChanged() {
        super.onNeighborChanged();
        if (this.simulated) {
            return;
        }
        for (IPart p : this.getParts()) {
            if (p == null || !(p instanceof IPartUpdateListener)) continue;
            ((IPartUpdateListener)p).onNeighborBlockChange();
        }
    }

    public void onPartChanged(TMultiPart part) {
        FMPMicroblock changed = null;
        if (part instanceof Microblock) {
            changed = new FMPMicroblock((Microblock)part);
        }
        for (IPart p : this.getParts()) {
            if (p == null || !(p instanceof IPartUpdateListener)) continue;
            ((IPartUpdateListener)p).onPartChanged(changed);
        }
    }

    public Iterable<ItemStack> getDrops() {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        for (IPart p : this.getParts()) {
            List<ItemStack> d = p.getDrops();
            if (d == null) continue;
            l.addAll(d);
        }
        return l;
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        ArrayList<Cuboid6> cubes = new ArrayList<Cuboid6>();
        for (IPart p : this.getParts()) {
            if (p == null || !(p instanceof IPartOccluding)) continue;
            for (Vec3dCube c : ((IPartOccluding)p).getOcclusionBoxes()) {
                cubes.add((Cuboid6)new IndexedCuboid6((Object)0, new Cuboid6(c.toAABB())));
            }
        }
        return cubes;
    }

    public boolean occlusionTest(TMultiPart part) {
        if (part instanceof Microblock) {
            FMPMicroblock mb = new FMPMicroblock((Microblock)part);
            for (IPart p : this.getParts()) {
                if (p.occlusionTest(mb)) continue;
                return false;
            }
        }
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)part);
    }

    public boolean canConnectRedstone(int side) {
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartRedstone) || !((IPartRedstone)p).canConnectRedstone(ForgeDirection.getOrientation((int)side))) continue;
            return true;
        }
        return false;
    }

    public int strongPowerLevel(int side) {
        int max = 0;
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartRedstone)) continue;
            max = Math.max(max, ((IPartRedstone)p).getStrongPower(ForgeDirection.getOrientation((int)side)));
        }
        return max;
    }

    public int weakPowerLevel(int side) {
        int max = 0;
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartRedstone)) continue;
            max = Math.max(max, ((IPartRedstone)p).getWeakPower(ForgeDirection.getOrientation((int)side)));
        }
        return max;
    }

    public void onNeighborTileChanged(int arg0, boolean arg1) {
        if (this.simulated) {
            return;
        }
        for (IPart p : this.getParts()) {
            if (p == null || !(p instanceof IPartUpdateListener)) continue;
            ((IPartUpdateListener)p).onNeighborTileChange();
        }
    }

    public boolean weakTileChanges() {
        return true;
    }

    public void onAdded() {
        if (this.simulated) {
            return;
        }
        for (IPart p : this.getParts()) {
            if (p == null || !(p instanceof IPartUpdateListener)) continue;
            ((IPartUpdateListener)p).onAdded();
        }
    }

    public void onRemoved() {
        if (this.simulated) {
            return;
        }
        for (IPart p : this.getParts()) {
            if (p == null || !(p instanceof IPartUpdateListener)) continue;
            ((IPartUpdateListener)p).onRemoved();
        }
    }

    public void onChunkLoad() {
        if (this.simulated) {
            return;
        }
        for (IPart p : this.getParts()) {
            if (p == null || !(p instanceof IPartUpdateListener)) continue;
            ((IPartUpdateListener)p).onLoaded();
        }
    }

    public void onChunkUnload() {
        if (this.simulated) {
            return;
        }
        for (IPart p : this.getParts()) {
            if (p == null || !(p instanceof IPartUpdateListener)) continue;
            ((IPartUpdateListener)p).onUnloaded();
        }
    }

    public void onConverted() {
        this.converted = true;
        for (String s : this.parts.keySet()) {
            this.parts.get(s).setParent(this);
        }
    }

    public void onMoved() {
        for (IPart p : this.getParts()) {
            if (p == null || !(p instanceof IPartUpdateListener)) continue;
            ((IPartUpdateListener)p).onUnloaded();
            ((IPartUpdateListener)p).onLoaded();
            ((IPartUpdateListener)p).onNeighborBlockChange();
        }
    }

    public void onWorldJoin() {
        super.onWorldJoin();
        this.onChunkLoad();
    }

    public void onWorldSeparate() {
        super.onWorldSeparate();
        this.onChunkUnload();
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        QMovingObjectPosition mop = this.rayTrace(RayTracer.getStartVector(QmunityLib.proxy.getPlayer()), RayTracer.getEndVector(QmunityLib.proxy.getPlayer()));
        if (mop == null) {
            return null;
        }
        return mop.getPart().getItem();
    }

    public void harvest(MovingObjectPosition hit, EntityPlayer player) {
        if (this.world().field_72995_K) {
            return;
        }
        QMovingObjectPosition mop = this.rayTrace(RayTracer.getStartVector(player), RayTracer.getEndVector(player));
        if (mop != null) {
            if (mop.getPart().breakAndDrop(player, mop)) {
                mop.getPart().getParent().removePart(mop.getPart());
            }
            if (this.getParts().size() == 0) {
                super.harvest(hit, player);
            }
        }
    }

    public void click(EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        QMovingObjectPosition mop = this.rayTrace(RayTracer.getStartVector(player), RayTracer.getEndVector(player));
        if (mop != null && mop.getPart() instanceof IPartInteractable) {
            ((IPartInteractable)mop.getPart()).onClicked(player, mop, item);
        }
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        QMovingObjectPosition mop = this.rayTrace(RayTracer.getStartVector(player), RayTracer.getEndVector(player));
        if (mop != null && mop.getPart() instanceof IPartInteractable) {
            return ((IPartInteractable)mop.getPart()).onActivated(player, mop, item);
        }
        return false;
    }

    @Override
    public Map<String, IPart> getPartMap() {
        return this.parts;
    }

    @Override
    public List<IMicroblock> getMicroblocks() {
        return MultipartSystem.FMP.getCompat().getMicroblocks(this.getWorld(), new Vec3i(this));
    }

    @Override
    public boolean isSimulated() {
        return this.simulated;
    }

    public boolean isSolid(ForgeDirection face) {
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartSolid) || !((IPartSolid)p).isSideSolid(face)) continue;
            return true;
        }
        return true;
    }

    @Override
    public boolean isSolid(int side) {
        return this.isSolid(ForgeDirection.getOrientation((int)side));
    }

    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        QMovingObjectPosition mop = this.rayTrace(RayTracer.getStartVector(player), RayTracer.getEndVector(player));
        if (mop != null && mop.getPart() != null) {
            return (float)(30.0 * mop.getPart().getHardness(player, mop));
        }
        return 30.0f;
    }

    public int getLightValue() {
        int val = 0;
        for (IPart p : this.getParts()) {
            val = Math.max(val, p.getLightValue());
        }
        return val;
    }

    public int getHollowSize(int side) {
        int val = 0;
        boolean found = false;
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartThruHole)) continue;
            val = Math.max(val, ((IPartThruHole)p).getHollowSize(ForgeDirection.getOrientation((int)side)));
            found = true;
        }
        if (found && (val > 0 || val < 12)) {
            return val;
        }
        return 8;
    }

    public int getSlotMask() {
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartCenter)) continue;
            return PartMap.CENTER.mask;
        }
        return 0;
    }
}

