/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.client.renderer.RenderMultipart;
import uk.co.qmunity.lib.part.IMicroblock;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.IPartCollidable;
import uk.co.qmunity.lib.part.IPartFace;
import uk.co.qmunity.lib.part.IPartInteractable;
import uk.co.qmunity.lib.part.IPartOccluding;
import uk.co.qmunity.lib.part.IPartRedstone;
import uk.co.qmunity.lib.part.IPartSelectable;
import uk.co.qmunity.lib.part.IPartSolid;
import uk.co.qmunity.lib.part.IPartTicking;
import uk.co.qmunity.lib.part.IPartUpdateListener;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.PartRegistry;
import uk.co.qmunity.lib.part.compat.OcclusionHelper;
import uk.co.qmunity.lib.part.compat.PartUpdateManager;
import uk.co.qmunity.lib.raytrace.QMovingObjectPosition;
import uk.co.qmunity.lib.raytrace.RayTracer;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;

public class TileMultipart
extends TileEntity
implements ITilePartHolder {
    private Map<String, IPart> parts = new HashMap<String, IPart>();
    private boolean shouldDieInAFire = false;
    private boolean loaded = false;
    private final boolean simulated;
    private boolean firstTick = true;

    public TileMultipart(boolean simulated) {
        this.simulated = simulated;
    }

    public TileMultipart() {
        this(false);
    }

    @Override
    public World getWorld() {
        return this.func_145831_w();
    }

    @Override
    public int getX() {
        return this.field_145851_c;
    }

    @Override
    public int getY() {
        return this.field_145848_d;
    }

    @Override
    public int getZ() {
        return this.field_145849_e;
    }

    @Override
    public List<IPart> getParts() {
        ArrayList<IPart> parts = new ArrayList<IPart>();
        for (String s : this.parts.keySet()) {
            IPart p = this.parts.get(s);
            if (p.getParent() == null) continue;
            parts.add(p);
        }
        return parts;
    }

    @Override
    public boolean canAddPart(IPart part) {
        if (part instanceof IPartCollidable) {
            ArrayList<Vec3dCube> cubes = new ArrayList<Vec3dCube>();
            ((IPartCollidable)part).addCollisionBoxesToList(cubes, null);
            for (Vec3dCube c : cubes) {
                if (this.getWorld().func_72855_b(c.clone().add(this.getX(), this.getY(), this.getZ()).toAABB())) continue;
                return false;
            }
        }
        return OcclusionHelper.occlusionTest((ITilePartHolder)this, part);
    }

    @Override
    public void addPart(IPart part) {
        int before = this.parts.size();
        this.parts.put(this.genIdentifier(), part);
        part.setParent(this);
        if (!this.simulated) {
            if (part instanceof IPartUpdateListener) {
                ((IPartUpdateListener)part).onAdded();
            }
            for (IPart p : this.getParts()) {
                if (p == part || !(p instanceof IPartUpdateListener)) continue;
                ((IPartUpdateListener)p).onPartChanged(part);
            }
            if (before > 0) {
                PartUpdateManager.addPart(this, part);
            }
            this.func_70296_d();
            this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
            if (!this.getWorld().field_72995_K && before > 0) {
                this.getWorld().func_147459_d(this.getX(), this.getY(), this.getZ(), this.field_145854_h);
            }
        }
    }

    @Override
    public boolean removePart(IPart part) {
        if (part == null) {
            return false;
        }
        if (!this.parts.containsValue(part)) {
            return false;
        }
        if (part.getParent() == null || part.getParent() != this) {
            return false;
        }
        if (!this.simulated) {
            PartUpdateManager.removePart(this, part);
            if (part instanceof IPartUpdateListener) {
                ((IPartUpdateListener)part).onRemoved();
            }
        }
        String id = this.getIdentifier(part);
        this.parts.remove(id);
        part.setParent(null);
        if (!this.simulated) {
            for (IPart p : this.getParts()) {
                if (p == part || !(p instanceof IPartUpdateListener)) continue;
                ((IPartUpdateListener)p).onPartChanged(part);
            }
            this.func_70296_d();
            this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
            if (!this.getWorld().field_72995_K) {
                this.getWorld().func_147459_d(this.getX(), this.getY(), this.getZ(), this.field_145854_h);
            }
        }
        return true;
    }

    private String genIdentifier() {
        String s = null;
        while (this.parts.containsKey(s = UUID.randomUUID().toString())) {
        }
        return s;
    }

    private String getIdentifier(IPart part) {
        for (String s : this.parts.keySet()) {
            if (!this.parts.get(s).equals(part)) continue;
            return s;
        }
        return null;
    }

    private IPart getPart(String id) {
        for (String s : this.parts.keySet()) {
            if (!s.equals(id)) continue;
            return this.parts.get(s);
        }
        return null;
    }

    public int getLightValue() {
        int val = 0;
        for (IPart p : this.getParts()) {
            val = Math.max(val, p.getLightValue());
        }
        return val;
    }

    @Override
    public QMovingObjectPosition rayTrace(Vec3d start, Vec3d end) {
        QMovingObjectPosition closest = null;
        double dist = Double.MAX_VALUE;
        for (IPart p : this.getParts()) {
            double d;
            QMovingObjectPosition mop;
            if (!(p instanceof IPartSelectable) || (mop = ((IPartSelectable)p).rayTrace(start, end)) == null || !((d = start.distanceTo(new Vec3d(mop.field_72307_f))) < dist)) continue;
            closest = mop;
            dist = d;
        }
        return closest;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList l = new NBTTagList();
        this.writeParts(l, false);
        tag.func_74782_a("parts", (NBTBase)l);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList l = tag.func_150295_c("parts", (int)new NBTTagCompound().func_74732_a());
        this.readParts(l, false, false);
        this.loaded = true;
        if (this.getParts().size() == 0) {
            this.shouldDieInAFire = true;
        }
    }

    public void writeUpdateToNBT(NBTTagCompound tag) {
        NBTTagList l = new NBTTagList();
        this.writeParts(l, true);
        tag.func_74782_a("parts", (NBTBase)l);
    }

    public void readUpdateFromNBT(NBTTagCompound tag) {
        NBTTagList l = tag.func_150295_c("parts", (int)new NBTTagCompound().func_74732_a());
        this.readParts(l, true, true);
        this.func_145831_w().func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void writeParts(NBTTagList l, boolean update) {
        for (IPart p : this.getParts()) {
            String id = this.getIdentifier(p);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("id", id);
            tag.func_74778_a("type", p.getType());
            NBTTagCompound data = new NBTTagCompound();
            if (update) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream buffer = new DataOutputStream(baos);
                try {
                    p.writeUpdateData(buffer, -1);
                    baos.flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                data.func_74773_a("data", baos.toByteArray());
            } else {
                p.writeToNBT(data);
            }
            tag.func_74782_a("data", (NBTBase)data);
            l.func_74742_a((NBTBase)tag);
        }
    }

    private void readParts(NBTTagList l, boolean update, boolean client) {
        for (int i = 0; i < l.func_74745_c(); ++i) {
            NBTTagCompound tag = l.func_150305_b(i);
            String id = tag.func_74779_i("id");
            IPart p = this.getPart(id);
            if (p == null) {
                p = PartRegistry.createPart(tag.func_74779_i("type"), client);
                if (p == null) continue;
                p.setParent(this);
                this.parts.put(id, p);
            }
            NBTTagCompound data = tag.func_74775_l("data");
            if (update) {
                try {
                    p.readUpdateData(new DataInputStream(new ByteArrayInputStream(data.func_74770_j("data"))), -1);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            p.readFromNBT(data);
        }
    }

    @Override
    public void sendUpdatePacket(IPart part, int channel) {
        if (this.getWorld() != null && this.getParts().contains(part)) {
            PartUpdateManager.sendPartUpdate(this, part, channel);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeUpdateToNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readUpdateFromNBT(pkt.func_148857_g());
    }

    public void removePart(EntityPlayer player) {
        QMovingObjectPosition mop = this.rayTrace(RayTracer.getStartVector(player), RayTracer.getEndVector(player));
        if (mop != null && mop.getPart().breakAndDrop(player, mop)) {
            mop.getPart().getParent().removePart(mop.getPart());
        }
    }

    @Override
    public void addCollisionBoxesToList(List<Vec3dCube> l, AxisAlignedBB bounds, Entity entity) {
        ArrayList<Vec3dCube> boxes = new ArrayList<Vec3dCube>();
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartCollidable)) continue;
            ArrayList<Vec3dCube> boxes_ = new ArrayList<Vec3dCube>();
            ((IPartCollidable)p).addCollisionBoxesToList(boxes_, entity);
            for (Vec3dCube c : boxes_) {
                Vec3dCube cube = c.clone();
                cube.add(this.getX(), this.getY(), this.getZ());
                cube.setPart(p);
                boxes.add(cube);
            }
            boxes_.clear();
        }
        for (Vec3dCube c : boxes) {
            if (!c.toAABB().func_72326_a(bounds)) continue;
            l.add(c);
        }
    }

    public void onNeighborBlockChange() {
        if (this.simulated) {
            return;
        }
        this.onUpdate();
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartUpdateListener)) continue;
            ((IPartUpdateListener)p).onNeighborBlockChange();
        }
        this.onUpdate();
    }

    public void onNeighborChange() {
        if (this.simulated) {
            return;
        }
        this.onUpdate();
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartUpdateListener)) continue;
            ((IPartUpdateListener)p).onNeighborTileChange();
        }
        this.onUpdate();
    }

    private void onUpdate() {
        if (this.simulated) {
            return;
        }
        if (!this.func_145831_w().field_72995_K && this.getParts().size() == 0) {
            this.func_145831_w().func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean isSideSolid(ForgeDirection face) {
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartSolid) || !((IPartSolid)p).isSideSolid(face)) continue;
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        if (this.firstTick && this.loaded) {
            for (IPart p : this.getParts()) {
                if (!(p instanceof IPartUpdateListener)) continue;
                ((IPartUpdateListener)p).onLoaded();
            }
            this.firstTick = false;
        }
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartTicking)) continue;
            ((IPartTicking)p).update();
        }
        if (this.shouldDieInAFire) {
            this.getWorld().func_147468_f(this.getX(), this.getY(), this.getZ());
        }
    }

    public List<Vec3dCube> getOcclusionBoxes() {
        ArrayList<Vec3dCube> boxes = new ArrayList<Vec3dCube>();
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartOccluding)) continue;
            boxes.addAll(((IPartOccluding)p).getOcclusionBoxes());
        }
        return boxes;
    }

    public int getStrongOutput(ForgeDirection direction, ForgeDirection face) {
        int max = 0;
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartRedstone)) continue;
            if (p instanceof IPartFace) {
                if (((IPartFace)p).getFace() != face) continue;
                max = Math.max(max, ((IPartRedstone)p).getStrongPower(direction));
                continue;
            }
            max = Math.max(max, ((IPartRedstone)p).getStrongPower(direction));
        }
        return max;
    }

    public int getStrongOutput(ForgeDirection direction) {
        int max = 0;
        for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            max = Math.max(max, this.getStrongOutput(direction, face));
        }
        return max;
    }

    public int getWeakOutput(ForgeDirection direction, ForgeDirection face) {
        int max = 0;
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartRedstone)) continue;
            if (p instanceof IPartFace) {
                if (((IPartFace)p).getFace() != face) continue;
                max = Math.max(max, ((IPartRedstone)p).getWeakPower(direction));
                continue;
            }
            max = Math.max(max, ((IPartRedstone)p).getWeakPower(direction));
        }
        return max;
    }

    public int getWeakOutput(ForgeDirection direction) {
        int max = 0;
        for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            max = Math.max(max, this.getWeakOutput(direction, face));
        }
        return max;
    }

    public boolean canConnect(ForgeDirection direction, ForgeDirection face) {
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartRedstone) || !(p instanceof IPartFace ? ((IPartFace)p).getFace() == face && ((IPartRedstone)p).canConnectRedstone(direction) : ((IPartRedstone)p).canConnectRedstone(direction))) continue;
            return true;
        }
        return false;
    }

    public boolean canConnect(ForgeDirection direction) {
        for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.canConnect(direction, face)) continue;
            return true;
        }
        return false;
    }

    public void onChunkUnload() {
        if (this.simulated) {
            return;
        }
        for (IPart p : this.getParts()) {
            if (!(p instanceof IPartUpdateListener)) continue;
            ((IPartUpdateListener)p).onUnloaded();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public ItemStack pickUp(EntityPlayer player) {
        QMovingObjectPosition mop = this.rayTrace(RayTracer.getStartVector(player), RayTracer.getEndVector(player));
        if (mop != null) {
            return mop.getPart().getPickedItem(mop);
        }
        return null;
    }

    @Override
    public Map<String, IPart> getPartMap() {
        return this.parts;
    }

    public void onClicked(EntityPlayer player) {
        QMovingObjectPosition mop = this.rayTrace(RayTracer.getStartVector(player), RayTracer.getEndVector(player));
        if (mop != null && mop.getPart() instanceof IPartInteractable) {
            ((IPartInteractable)mop.getPart()).onClicked(player, mop, player.func_71045_bC());
        }
    }

    public boolean onActivated(EntityPlayer player) {
        QMovingObjectPosition mop = this.rayTrace(RayTracer.getStartVector(player), RayTracer.getEndVector(player));
        if (mop != null && mop.getPart() instanceof IPartInteractable) {
            return ((IPartInteractable)mop.getPart()).onActivated(player, mop, player.func_71045_bC());
        }
        return false;
    }

    @Override
    public List<IMicroblock> getMicroblocks() {
        ArrayList<IMicroblock> microblocks = new ArrayList<IMicroblock>();
        for (IPart p : this.getParts()) {
            if (!(p instanceof IMicroblock)) continue;
            microblocks.add((IMicroblock)p);
        }
        return microblocks;
    }

    @Override
    public boolean isSimulated() {
        return this.simulated;
    }

    public boolean shouldRenderInPass(int pass) {
        RenderMultipart.pass = pass;
        return true;
    }
}

