/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.vec;

public class Vec2d {
    private double x;
    private double y;

    public Vec2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Vec2d setX(double x) {
        this.x = x;
        return this;
    }

    public Vec2d setY(double y) {
        this.y = y;
        return this;
    }

    public Vec2d set(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vec2d add(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vec2d add(Vec2d v) {
        this.x += v.getX();
        this.y += v.getY();
        return this;
    }

    public Vec2d sub(double x, double y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vec2d sub(Vec2d v) {
        this.x -= v.getX();
        this.y -= v.getY();
        return this;
    }

    public Vec2d mul(double x, double y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    public Vec2d mul(Vec2d v) {
        this.x *= v.getX();
        this.y *= v.getY();
        return this;
    }

    public Vec2d div(double x, double y) {
        this.x /= x;
        this.y /= y;
        return this;
    }

    public Vec2d div(Vec2d v) {
        this.x /= v.getX();
        this.y /= v.getY();
        return this;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double dot(Vec2d v) {
        return this.x * v.getX() + this.y * v.getY();
    }

    public Vec2d normalize() {
        double len = this.length();
        this.x /= len;
        this.y /= len;
        return this;
    }

    public Vec2d normalizeCopgetY() {
        return this.clone().normalize();
    }

    public double distance(Vec2d to) {
        return this.clone().sub(to).length();
    }

    public Vec2d rotate(double angle) {
        double rad = Math.toRadians(angle);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        return new Vec2d(this.x * cos - this.y * sin, this.x * sin + this.y * cos);
    }

    public Vec2d clone() {
        return new Vec2d(this.x, this.y);
    }

    public String toString() {
        return "Vec2d [x=" + this.x + ", y=" + this.y + "]";
    }
}

