/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.vec;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.StringTokenizer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.vec.IWorldLocation;
import uk.co.qmunity.lib.vec.ImmutableVec3i;

public class Vec3i
implements IWorldLocation {
    protected int x;
    protected int y;
    protected int z;
    protected World w = null;

    public Vec3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3i(int x, int y, int z, World w) {
        this(x, y, z);
        this.w = w;
    }

    public Vec3i(TileEntity te) {
        this(te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145831_w());
    }

    public Vec3i(Vec3 vec) {
        this((int)vec.field_72450_a, (int)vec.field_72448_b, (int)vec.field_72449_c);
    }

    public Vec3i(Vec3 vec, World w) {
        this((int)vec.field_72450_a, (int)vec.field_72448_b, (int)vec.field_72449_c);
        this.w = w;
    }

    public Vec3i(IWorldLocation loc) {
        this(loc.getX(), loc.getY(), loc.getZ(), loc.getWorld());
    }

    public boolean hasWorld() {
        return this.w != null;
    }

    public Vec3i add(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vec3i add(ForgeDirection dir) {
        return this.add(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public Vec3i add(Vec3i vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    public Vec3i subtract(int x, int y, int z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vec3i subtract(ForgeDirection dir) {
        return this.subtract(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public Vec3i subtract(Vec3i vec) {
        return this.subtract(vec.x, vec.y, vec.z);
    }

    public Vec3i multiply(int x, int y, int z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vec3i multiply(int multiplier) {
        return this.multiply(multiplier, multiplier, multiplier);
    }

    public Vec3i multiply(ForgeDirection direction) {
        return this.multiply(direction.offsetX, direction.offsetY, direction.offsetZ);
    }

    public Vec3i divide(int x, int y, int z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        return this;
    }

    public Vec3i divide(int multiplier) {
        return this.divide(multiplier, multiplier, multiplier);
    }

    public Vec3i divide(ForgeDirection direction) {
        return this.divide(direction.offsetX, direction.offsetY, direction.offsetZ);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vec3i normalize() {
        Vec3i v = this.clone();
        double len = this.length();
        v.x = (int)((double)v.x / len);
        v.y = (int)((double)v.y / len);
        v.z = (int)((double)v.z / len);
        return v;
    }

    public Vec3i abs() {
        return new Vec3i(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public double dot(Vec3i v) {
        return this.x * v.getX() + this.y * v.getY() + this.z * v.getZ();
    }

    public Vec3i cross(Vec3i v) {
        return new Vec3i(this.y * v.getZ() - this.z * v.getY(), this.x * v.getZ() - this.z * v.getX(), this.x * v.getY() - this.y * v.getX());
    }

    public Vec3i getRelative(int x, int y, int z) {
        return this.clone().add(x, y, z);
    }

    public Vec3i getRelative(ForgeDirection dir) {
        return this.getRelative(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public ForgeDirection getDirectionTo(Vec3i vec) {
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            if (this.getX() + d.offsetX != vec.getX() || this.getY() + d.offsetY != vec.getY() || this.getZ() + d.offsetZ != vec.getZ()) continue;
            return d;
        }
        return ForgeDirection.UNKNOWN;
    }

    public Vec3i clone() {
        return new Vec3i(this.x, this.y, this.z, this.w);
    }

    public boolean hasTileEntity() {
        if (this.hasWorld()) {
            return this.w.func_147438_o(this.x, this.y, this.z) != null;
        }
        return false;
    }

    public TileEntity getTileEntity() {
        if (this.hasTileEntity()) {
            return this.w.func_147438_o(this.x, this.y, this.z);
        }
        return null;
    }

    public boolean isBlock(Block b) {
        return this.isBlock(b, false);
    }

    public boolean isBlock(Block b, boolean checkAir) {
        if (this.hasWorld()) {
            Block bl = this.w.func_147439_a(this.x, this.y, this.z);
            if (b == null && bl == Blocks.field_150350_a) {
                return true;
            }
            if (b == null && checkAir && bl.func_149688_o() == Material.field_151579_a) {
                return true;
            }
            if (b == null && checkAir && bl.isAir((IBlockAccess)this.w, this.x, this.y, this.z)) {
                return true;
            }
            return bl.getClass().isInstance(b);
        }
        return false;
    }

    public int getBlockMeta() {
        if (this.hasWorld()) {
            return this.w.func_72805_g(this.x, this.y, this.z);
        }
        return -1;
    }

    public Block getBlock() {
        return this.getBlock(false);
    }

    public Block getBlock(boolean airIsNull) {
        if (this.hasWorld()) {
            if (airIsNull && this.isBlock(null, true)) {
                return null;
            }
            return this.w.func_147439_a(this.x, this.y, this.z);
        }
        return null;
    }

    @Override
    public World getWorld() {
        return this.w;
    }

    public Vec3i setWorld(World world) {
        this.w = world;
        return this;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public Vec3i getImmutableCopy() {
        return new ImmutableVec3i(this);
    }

    public int distanceTo(Vec3i vec) {
        return this.distanceTo(vec.x, vec.y, vec.z);
    }

    public int distanceTo(int x, int y, int z) {
        int dx = x - this.x;
        int dy = y - this.y;
        int dz = z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vec3i) {
            Vec3i vec = (Vec3i)obj;
            return vec.w == this.w && vec.x == this.x && vec.y == this.y && vec.z == this.z;
        }
        return false;
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public String toString() {
        String s = "Vector3{";
        if (this.hasWorld()) {
            s = s + "w=" + this.w.field_73011_w.field_76574_g + ";";
        }
        s = s + "x=" + this.x + ";y=" + this.y + ";z=" + this.z + "}";
        return s;
    }

    public ForgeDirection toForgeDirection() {
        if (this.z >= this.x && this.z >= this.y) {
            return ForgeDirection.SOUTH;
        }
        if (this.z <= this.x && this.z <= this.y) {
            return ForgeDirection.NORTH;
        }
        if (this.x >= this.y && this.x >= this.z) {
            return ForgeDirection.EAST;
        }
        if (this.x <= this.y && this.x <= this.z) {
            return ForgeDirection.WEST;
        }
        if (this.y >= this.x && this.y >= this.z) {
            return ForgeDirection.UP;
        }
        if (this.y <= this.x && this.y <= this.z) {
            return ForgeDirection.DOWN;
        }
        return ForgeDirection.UNKNOWN;
    }

    public static Vec3i fromString(String s) {
        if (s.startsWith("Vector3{") && s.endsWith("}")) {
            World w = null;
            int x = 0;
            int y = 0;
            int z = 0;
            String s2 = s.substring(s.indexOf("{") + 1, s.lastIndexOf("}"));
            StringTokenizer st = new StringTokenizer(s2, ";");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (t.toLowerCase().startsWith("w")) {
                    int world = Integer.parseInt(t.split("=")[1]);
                    if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                        for (WorldServer wo : MinecraftServer.func_71276_C().field_71305_c) {
                            if (wo.field_73011_w.field_76574_g != world) continue;
                            w = wo;
                            break;
                        }
                    } else {
                        w = Vec3i.getClientWorld(world);
                    }
                }
                if (t.toLowerCase().startsWith("x")) {
                    x = Integer.parseInt(t.split("=")[1]);
                }
                if (t.toLowerCase().startsWith("y")) {
                    y = Integer.parseInt(t.split("=")[1]);
                }
                if (!t.toLowerCase().startsWith("z")) continue;
                z = Integer.parseInt(t.split("=")[1]);
            }
            if (w != null) {
                return new Vec3i(x, y, z, w);
            }
            return new Vec3i(x, y, z);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static World getClientWorld(int world) {
        if (Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g != world) {
            return null;
        }
        return Minecraft.func_71410_x().field_71441_e;
    }
}

