/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.client.thread;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ichun.common.core.EntityHelperBase;
import ichun.common.core.config.Config;
import ichun.common.core.config.ConfigHandler;
import ichun.common.core.updateChecker.ModVersionChecker;
import ichun.common.core.updateChecker.ModVersionInfo;
import ichun.common.core.util.ObfHelper;
import ichun.common.core.util.ResourceHelper;
import ichun.common.iChunUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

@SideOnly(value=Side.CLIENT)
public class ThreadStatistics
extends Thread {
    public int type;
    public Object[] data;
    public static final ArrayList<String> infectionHash = new ArrayList();
    public static final Random rand = new Random();
    public static Config stats;

    public ThreadStatistics(int type1, Object ... data1) {
        this.setName("iChunUtil Statistics Thread");
        this.setDaemon(true);
        this.type = type1;
        this.data = data1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block15: {
            try {
                HttpEntity entity;
                CloseableHttpClient httpclient = HttpClients.createDefault();
                HttpPost httppost = new HttpPost("http://ichun.us/infect/stats2.php");
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(2);
                params.add(new BasicNameValuePair("event", Integer.toString(this.type)));
                params.add(new BasicNameValuePair("UUID", Minecraft.func_71410_x().func_110432_I().func_148255_b().replaceAll("-", "")));
                if (this.type != 4) {
                    params.add(new BasicNameValuePair("time", Long.toString(System.currentTimeMillis())));
                    switch (this.type) {
                        case 1: {
                            params.add(new BasicNameValuePair("version", "4.2.2".replaceAll(" ", "").replaceAll("\\.", "_")));
                            StringBuilder sb = new StringBuilder();
                            if (!ObfHelper.obfuscation) {
                                sb.append("devEnv-");
                            }
                            ArrayList<ModVersionInfo> mods = ModVersionChecker.getListOf_iChunMods();
                            for (int i = 0; i < mods.size(); ++i) {
                                sb.append(mods.get((int)i).modName.replaceAll(" ", "").replaceAll("\\.", "_") + "_" + mods.get((int)i).modVersion.replaceAll("\\.", "_"));
                                if (i >= mods.size() - 1) continue;
                                sb.append("-");
                            }
                            params.add(new BasicNameValuePair("mods", sb.toString()));
                            params.add(new BasicNameValuePair("level", Integer.toString(ThreadStatistics.getImmunityLevel())));
                            break;
                        }
                        case 2: {
                            params.add(new BasicNameValuePair("infector", (String)this.data[1]));
                        }
                        case 3: {
                            params.add(new BasicNameValuePair("level", Integer.toString((Integer)this.data[0])));
                        }
                    }
                }
                httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
                HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                if (this.type != 4 || (entity = response.getEntity()) == null) break block15;
                InputStream is = entity.getContent();
                try {
                    int lv = Integer.parseInt(IOUtils.toString((InputStream)is, (String)"UTF-8").trim());
                    if (lv >= 0) {
                        stats.get("statsData").set(ThreadStatistics.getInfectionHash(lv));
                        stats.save();
                    } else {
                        new ThreadStatistics(1, new Object[0]).start();
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void checkFirstLaunch() {
        stats = ConfigHandler.createConfig(new File(ResourceHelper.getConfigFolder(), "iChunUtil_Stats.cfg"), "ichunutilstats", "iChunUtil Stats", null, iChunUtil.instance);
        stats.setCurrentCategory("stats");
        stats.createIntBoolProperty("statsOptOut", true, false, !Minecraft.func_71410_x().field_71474_y.field_74355_t);
        stats.createStringProperty("statsIdentifier", false, false, "");
        stats.createStringProperty("statsData", false, false, "");
        if (stats.getInt("statsOptOut") == 1) {
            iChunUtil.console("Opting out of stat collection :(");
        } else {
            boolean isPatientZero;
            boolean bl = isPatientZero = ThreadStatistics.getImmunityLevel() == 0;
            if (stats.getString("statsData").trim().isEmpty() || ThreadStatistics.getInfectionLevel(stats.getString("statsData")) == -1) {
                stats.get("statsData").set(isPatientZero ? ThreadStatistics.getInfectionHash(0) : "");
                stats.save();
            }
            String firstLaunchHash = ThreadStatistics.createFirstLaunchHash();
            if (stats.getString("statsIdentifier").trim().isEmpty() || !stats.getString("statsIdentifier").equals(firstLaunchHash)) {
                stats.get("statsIdentifier").set(firstLaunchHash);
                stats.save();
                new ThreadStatistics(4, new Object[0]).start();
            }
        }
    }

    public static String createFirstLaunchHash() {
        rand.setSeed(Math.abs(Minecraft.func_71410_x().func_110432_I().func_148255_b().hashCode() - "FirstRunV2".hashCode()));
        return RandomStringUtils.random((int)20, (int)32, (int)127, (boolean)false, (boolean)false, null, (Random)rand);
    }

    public static int getImmunityLevel() {
        Minecraft mc = Minecraft.func_71410_x();
        return EntityHelperBase.getImmunityLevel(mc.func_110432_I().func_148255_b());
    }

    public static int getInfectionLevel(String s) {
        if (s.isEmpty()) {
            return -1;
        }
        if (infectionHash.isEmpty()) {
            ThreadStatistics.generateInfectionHash();
        }
        for (int i = 0; i < infectionHash.size(); ++i) {
            if (!infectionHash.get(i).equals(s)) continue;
            return i;
        }
        return -1;
    }

    public static String getInfectionHash(int i) {
        if (infectionHash.isEmpty()) {
            ThreadStatistics.generateInfectionHash();
        }
        if (i >= infectionHash.size()) {
            return "CHEATER";
        }
        return infectionHash.get(i);
    }

    public static void generateInfectionHash() {
        infectionHash.clear();
        Minecraft mc = Minecraft.func_71410_x();
        float immunity = 1.0f;
        int i = 0;
        while (immunity > 0.0f) {
            rand.setSeed(Math.abs(mc.func_110432_I().func_148255_b().replaceAll("-", "").hashCode() + infectionHash.size() * Math.abs("infection".hashCode())));
            infectionHash.add(RandomStringUtils.random((int)20, (int)32, (int)127, (boolean)false, (boolean)false, null, (Random)rand));
            immunity -= EntityHelperBase.RARITY[i];
            ++i;
        }
    }
}

