/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gcewing.sg.BaseBlock;
import gcewing.sg.BaseUtils;
import gcewing.sg.BlockPos;
import gcewing.sg.EnumWorldBlockLayer;
import gcewing.sg.IBlockState;
import gcewing.sg.IProperty;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseBlockUtils {
    public static String getNameForBlock(Block block) {
        if (block != null) {
            return Block.field_149771_c.func_148750_c((Object)block).toString();
        }
        return "";
    }

    public static boolean blockIsGettingExternallyPowered(World world, BlockPos blockPos) {
        for (EnumFacing enumFacing : BaseUtils.facings) {
            if (!BaseBlockUtils.isPoweringSide(world, blockPos.offset(enumFacing), enumFacing)) continue;
            return true;
        }
        return false;
    }

    static boolean isPoweringSide(World world, BlockPos blockPos, EnumFacing enumFacing) {
        Block block = world.func_147439_a(blockPos.x, blockPos.y, blockPos.z);
        if (block.func_149709_b((IBlockAccess)world, blockPos.x, blockPos.y, blockPos.z, enumFacing.ordinal()) > 0) {
            return true;
        }
        if (block.shouldCheckWeakPower((IBlockAccess)world, blockPos.x, blockPos.y, blockPos.z, enumFacing.ordinal())) {
            for (EnumFacing enumFacing2 : BaseUtils.facings) {
                if (enumFacing2 == BaseUtils.oppositeFacing(enumFacing)) continue;
                BlockPos blockPos2 = blockPos.offset(enumFacing2);
                Block block2 = world.func_147439_a(blockPos2.x, blockPos2.y, blockPos2.z);
                if (block2.func_149748_c((IBlockAccess)world, blockPos2.x, blockPos2.y, blockPos2.z, enumFacing2.ordinal()) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static IBlockState getBlockStateFromItemStack(ItemStack itemStack) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        int n = 0;
        if (itemStack.func_77973_b().func_77614_k()) {
            n = itemStack.func_77973_b().func_77647_b(itemStack.func_77960_j());
        }
        if (block instanceof BaseBlock) {
            return ((BaseBlock)block).getStateFromMeta(n);
        }
        return new MetaBlockState(block, n);
    }

    public static IBlockState getBlockStateFromMeta(Block block, int n) {
        if (block instanceof BaseBlock) {
            return ((BaseBlock)block).getStateFromMeta(n);
        }
        return new MetaBlockState(block, n);
    }

    public static int getMetaFromBlockState(IBlockState iBlockState) {
        if (iBlockState instanceof MetaBlockState) {
            return ((MetaBlockState)iBlockState).meta;
        }
        return ((BaseBlock)iBlockState.getBlock()).getMetaFromState(iBlockState);
    }

    public static Block getWorldBlock(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return iBlockAccess.func_147439_a(blockPos.x, blockPos.y, blockPos.z);
    }

    public static IBlockState getWorldBlockState(IBlockAccess iBlockAccess, BlockPos blockPos) {
        Block block = iBlockAccess.func_147439_a(blockPos.x, blockPos.y, blockPos.z);
        int n = iBlockAccess.func_72805_g(blockPos.x, blockPos.y, blockPos.z);
        if (block instanceof BaseBlock) {
            return ((BaseBlock)block).getStateFromMeta(n);
        }
        return new MetaBlockState(block, n);
    }

    public static boolean setWorldBlockState(World world, BlockPos blockPos, IBlockState iBlockState, int n) {
        Block block = iBlockState.getBlock();
        int n2 = BaseBlockUtils.getMetaFromBlockState(iBlockState);
        return world.func_147465_d(blockPos.x, blockPos.y, blockPos.z, block, n2, n);
    }

    public static void markWorldBlockForUpdate(World world, BlockPos blockPos) {
        world.func_147471_g(blockPos.x, blockPos.y, blockPos.z);
    }

    public static void notifyWorldNeighborsOfStateChange(World world, BlockPos blockPos, Block block) {
        world.func_147459_d(blockPos.x, blockPos.y, blockPos.z, block);
    }

    public static TileEntity getWorldTileEntity(IBlockAccess iBlockAccess, BlockPos blockPos) {
        return iBlockAccess.func_147438_o(blockPos.x, blockPos.y, blockPos.z);
    }

    public static World getTileEntityWorld(TileEntity tileEntity) {
        return tileEntity.func_145831_w();
    }

    public static BlockPos getTileEntityPos(TileEntity tileEntity) {
        return new BlockPos(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
    }

    public static boolean blockCanRenderInLayer(Block block, EnumWorldBlockLayer enumWorldBlockLayer) {
        if (block instanceof BaseBlock) {
            return ((BaseBlock)block).canRenderInLayer(enumWorldBlockLayer);
        }
        switch (enumWorldBlockLayer) {
            case SOLID: {
                return block.canRenderInPass(0);
            }
            case TRANSLUCENT: {
                return block.canRenderInPass(1);
            }
        }
        return false;
    }

    public static IBlockState getDefaultBlockState(Block block) {
        if (block instanceof BaseBlock) {
            return ((BaseBlock)block).getDefaultState();
        }
        return new MetaBlockState(block, 0);
    }

    public static void playWorldAuxSFX(World world, int n, BlockPos blockPos, IBlockState iBlockState) {
        Block block = iBlockState.getBlock();
        int n2 = BaseBlockUtils.getMetaFromBlockState(iBlockState);
        int n3 = n2 << 12 | Block.func_149682_b((Block)block);
        world.func_72926_e(n, blockPos.getX(), blockPos.getY(), blockPos.getZ(), n3);
    }

    public static float getBlockHardness(Block block, World world, BlockPos blockPos) {
        return block.func_149712_f(world, blockPos.x, blockPos.y, blockPos.z);
    }

    public static String getBlockHarvestTool(IBlockState iBlockState) {
        Block block = iBlockState.getBlock();
        int n = BaseBlockUtils.getMetaFromBlockState(iBlockState);
        return block.getHarvestTool(n);
    }

    public static int getBlockHarvestLevel(IBlockState iBlockState) {
        Block block = iBlockState.getBlock();
        int n = BaseBlockUtils.getMetaFromBlockState(iBlockState);
        return block.getHarvestLevel(n);
    }

    public static float getPlayerBreakSpeed(EntityPlayer entityPlayer, IBlockState iBlockState, BlockPos blockPos) {
        Block block = iBlockState.getBlock();
        int n = BaseBlockUtils.getMetaFromBlockState(iBlockState);
        return entityPlayer.getBreakSpeed(block, false, n, blockPos.x, blockPos.y, blockPos.z);
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getSpriteForBlockState(IBlockState iBlockState) {
        if (iBlockState != null) {
            Block block = iBlockState.getBlock();
            int n = BaseBlockUtils.getMetaFromBlockState(iBlockState);
            return block.func_149691_a(2, n);
        }
        return null;
    }

    public static void spawnBlockStackAsEntity(World world, BlockPos blockPos, ItemStack itemStack) {
        BaseBlockUtils.spawnItemStackAsEntity(world, blockPos, itemStack);
    }

    public static void spawnItemStackAsEntity(World world, BlockPos blockPos, ItemStack itemStack) {
        float f = 0.7f;
        double d = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d3 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)blockPos.x + d, (double)blockPos.y + d2, (double)blockPos.z + d3, itemStack);
        entityItem.field_145804_b = 10;
        world.func_72838_d((Entity)entityItem);
    }

    public static ItemStack blockStackWithState(IBlockState iBlockState, int n) {
        Block block = iBlockState.getBlock();
        int n2 = BaseBlockUtils.getMetaFromBlockState(iBlockState);
        return new ItemStack(block, n, n2);
    }

    public static ItemStack newBlockStack(IBlockState iBlockState) {
        Block block = iBlockState.getBlock();
        int n = BaseBlockUtils.getMetaFromBlockState(iBlockState);
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            return new ItemStack(item, 1, n);
        }
        return null;
    }

    public static NBTTagCompound nbtFromBlockPos(BlockPos blockPos) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74768_a("x", blockPos.getX());
        nBTTagCompound.func_74768_a("y", blockPos.getY());
        nBTTagCompound.func_74768_a("z", blockPos.getZ());
        return nBTTagCompound;
    }

    public static BlockPos blockPosFromNBT(NBTTagCompound nBTTagCompound) {
        return new BlockPos(nBTTagCompound.func_74762_e("x"), nBTTagCompound.func_74762_e("y"), nBTTagCompound.func_74762_e("z"));
    }

    protected static class MetaBlockState
    implements IBlockState {
        protected Block block;
        public int meta;

        public MetaBlockState(Block block, int n) {
            this.block = block;
            this.meta = n;
        }

        @Override
        public Collection<IProperty> getPropertyNames() {
            return null;
        }

        @Override
        public <T extends Comparable<T>> T getValue(IProperty<T> iProperty) {
            return null;
        }

        @Override
        public <T extends Comparable<T>, V extends T> IBlockState withProperty(IProperty<T> iProperty, V v) {
            return null;
        }

        @Override
        public <T extends Comparable<T>> IBlockState cycleProperty(IProperty<T> iProperty) {
            return null;
        }

        @Override
        public ImmutableMap<IProperty, Comparable> getProperties() {
            return null;
        }

        @Override
        public Block getBlock() {
            return this.block;
        }
    }
}

