/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlock;
import gcewing.sg.BaseTileEntity;
import gcewing.sg.BaseUtils;
import gcewing.sg.BlockPos;
import gcewing.sg.IBlockState;
import gcewing.sg.IProperty;
import gcewing.sg.PropertyTurn;
import gcewing.sg.Trans3;
import gcewing.sg.Vector3;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseOrientation {
    public static boolean debugPlacement = false;
    public static boolean debugOrientation = false;
    public static BaseBlock.IOrientationHandler orient4WaysByState = new Orient4WaysByState();
    public static BaseBlock.IOrientationHandler orient24WaysByTE = new Orient24WaysByTE();

    public static class Orient24WaysByTE
    extends BaseBlock.Orient1Way {
        @Override
        public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Vector3 vector3) {
            TileEntity tileEntity = iBlockAccess.func_147438_o(blockPos.x, blockPos.y, blockPos.z);
            if (tileEntity instanceof BaseTileEntity) {
                BaseTileEntity baseTileEntity = (BaseTileEntity)tileEntity;
                return Trans3.sideTurn(vector3, baseTileEntity.side, baseTileEntity.turn);
            }
            return super.localToGlobalTransformation(iBlockAccess, blockPos, iBlockState, vector3);
        }
    }

    public static class Orient4WaysByState
    implements BaseBlock.IOrientationHandler {
        public static IProperty FACING = new PropertyTurn("facing");

        @Override
        public void defineProperties(BaseBlock baseBlock) {
            baseBlock.addProperty(FACING);
        }

        @Override
        public IBlockState onBlockPlaced(Block block, World world, BlockPos blockPos, EnumFacing enumFacing, float f, float f2, float f3, IBlockState iBlockState, EntityLivingBase entityLivingBase) {
            EnumFacing enumFacing2 = this.getHorizontalFacing((Entity)entityLivingBase);
            if (debugPlacement) {
                System.out.printf("BaseOrientation.Orient4WaysByState: Placing block with FACING = %s\n", enumFacing2);
            }
            return iBlockState.withProperty(FACING, enumFacing2);
        }

        protected EnumFacing getHorizontalFacing(Entity entity) {
            return BaseUtils.horizontalFacings[BaseUtils.iround((double)entity.field_70177_z / 90.0) & 3];
        }

        @Override
        public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Vector3 vector3) {
            int n;
            EnumFacing enumFacing = (EnumFacing)iBlockState.getValue(FACING);
            if (debugOrientation) {
                System.out.printf("BaseOrientation.Orient4WaysByState.localToGlobalTransformation: for %s: facing = %s\n", iBlockState, enumFacing);
            }
            switch (enumFacing) {
                case NORTH: {
                    n = 0;
                    break;
                }
                case WEST: {
                    n = 1;
                    break;
                }
                case SOUTH: {
                    n = 2;
                    break;
                }
                case EAST: {
                    n = 3;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return new Trans3(vector3).turn(n);
        }
    }
}

