/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseMod;
import gcewing.sg.BaseTileEntity;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class BaseTEChunkManager
implements ForgeChunkManager.LoadingCallback {
    public boolean debug = false;
    BaseMod base;

    public BaseTEChunkManager(BaseMod baseMod) {
        this.base = baseMod;
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)baseMod, (ForgeChunkManager.LoadingCallback)this);
        if (this.debug) {
            System.out.printf("%s: BaseTEChunkManager: Chunk loading callback installed\n", this.base.modPackage);
        }
    }

    protected ForgeChunkManager.Ticket newTicket(World world) {
        if (this.debug) {
            System.out.printf("%s: BaseTEChunkManager.newTicket for %s\n", this.base.modPackage, world);
        }
        return ForgeChunkManager.requestTicket((Object)this.base, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> list, World world) {
        if (this.debug) {
            System.out.printf("%s: BaseTEChunkManager.ticketsLoaded for %s\n", this.base.modPackage, world);
        }
        for (ForgeChunkManager.Ticket ticket : list) {
            NBTTagCompound nBTTagCompound = ticket.getModData();
            if (nBTTagCompound == null || !nBTTagCompound.func_74779_i("type").equals("TileEntity")) continue;
            int n = nBTTagCompound.func_74762_e("xCoord");
            int n2 = nBTTagCompound.func_74762_e("yCoord");
            int n3 = nBTTagCompound.func_74762_e("zCoord");
            TileEntity tileEntity = world.func_147438_o(n, n2, n3);
            if (this.debug) {
                System.out.printf("%s: BaseTEChunkManager.ticketsLoaded: Ticket for %s at (%d, %d, %d)\n", this.base.modPackage, tileEntity, n, n2, n3);
            }
            if (tileEntity instanceof BaseTileEntity && this.reinstateChunkTicket((BaseTileEntity)tileEntity, ticket)) continue;
            if (this.debug) {
                System.out.printf("%s: BaseTEChunkManager.ticketsLoaded: : Unable to reinstate ticket\n", this.base.modPackage);
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }

    public void setForcedChunkRange(BaseTileEntity baseTileEntity, int n, int n2, int n3, int n4) {
        baseTileEntity.releaseChunkTicket();
        ForgeChunkManager.Ticket ticket = this.getChunkTicket(baseTileEntity);
        if (ticket != null) {
            NBTTagCompound nBTTagCompound = ticket.getModData();
            nBTTagCompound.func_74778_a("type", "TileEntity");
            nBTTagCompound.func_74768_a("xCoord", baseTileEntity.field_145851_c);
            nBTTagCompound.func_74768_a("yCoord", baseTileEntity.field_145848_d);
            nBTTagCompound.func_74768_a("zCoord", baseTileEntity.field_145849_e);
            nBTTagCompound.func_74768_a("rangeMinX", n);
            nBTTagCompound.func_74768_a("rangeMinZ", n2);
            nBTTagCompound.func_74768_a("rangeMaxX", n3);
            nBTTagCompound.func_74768_a("rangeMaxZ", n4);
            this.forceChunkRangeOnTicket(baseTileEntity, ticket);
        }
    }

    public void clearForcedChunkRange(BaseTileEntity baseTileEntity) {
        baseTileEntity.releaseChunkTicket();
    }

    protected void forceChunkRangeOnTicket(BaseTileEntity baseTileEntity, ForgeChunkManager.Ticket ticket) {
        NBTTagCompound nBTTagCompound = ticket.getModData();
        int n = nBTTagCompound.func_74762_e("rangeMinX");
        int n2 = nBTTagCompound.func_74762_e("rangeMinZ");
        int n3 = nBTTagCompound.func_74762_e("rangeMaxX");
        int n4 = nBTTagCompound.func_74762_e("rangeMaxZ");
        if (this.debug) {
            System.out.printf("BaseChunkLoadingTE: Forcing range (%s,%s)-(%s,%s) in dimension %s\n", n, n2, n3, n4, baseTileEntity.func_145831_w().field_73011_w.field_76574_g);
        }
        int n5 = baseTileEntity.field_145851_c >> 4;
        int n6 = baseTileEntity.field_145849_e >> 4;
        for (int i = n; i <= n3; ++i) {
            for (int j = n2; j <= n4; ++j) {
                int n7 = n5 + i;
                int n8 = n6 + j;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(n7, n8));
            }
        }
    }

    protected ForgeChunkManager.Ticket getChunkTicket(BaseTileEntity baseTileEntity) {
        if (baseTileEntity.chunkTicket == null) {
            baseTileEntity.chunkTicket = this.newTicket(baseTileEntity.func_145831_w());
        }
        return baseTileEntity.chunkTicket;
    }

    public boolean reinstateChunkTicket(BaseTileEntity baseTileEntity, ForgeChunkManager.Ticket ticket) {
        if (baseTileEntity.chunkTicket == null) {
            if (this.debug) {
                System.out.printf("BaseChunkLoadingTE: Reinstating chunk ticket %s\n", ticket);
            }
            baseTileEntity.chunkTicket = ticket;
            this.forceChunkRangeOnTicket(baseTileEntity, ticket);
            return true;
        }
        return false;
    }

    public void dumpChunkLoadingState(BaseTileEntity baseTileEntity, String string) {
        System.out.printf("%s: Chunk loading state:\n", string);
        System.out.printf("Chunk ticket = %s\n", baseTileEntity.chunkTicket);
        if (baseTileEntity.chunkTicket != null) {
            System.out.printf("Loaded chunks:", new Object[0]);
            for (Object e : baseTileEntity.chunkTicket.getChunkList()) {
                ChunkCoordIntPair chunkCoordIntPair = (ChunkCoordIntPair)e;
                System.out.printf(" (%d,%d)", chunkCoordIntPair.field_77276_a, chunkCoordIntPair.field_77275_b);
            }
            System.out.printf("\n", new Object[0]);
        }
    }
}

