/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlock;
import gcewing.sg.BaseMod;
import gcewing.sg.BaseOrientation;
import gcewing.sg.BlockPos;
import gcewing.sg.DHDTE;
import gcewing.sg.IBlockState;
import gcewing.sg.SGBaseBlock;
import gcewing.sg.SGBaseTE;
import gcewing.sg.SGCraft;
import gcewing.sg.SGGui;
import gcewing.sg.Vector3;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DHDBlock
extends BaseBlock<DHDTE> {
    protected static String[] textures = new String[]{"dhd_top", "dhd_side", "stargateBlock", "dhd_button_dim"};
    protected static BaseMod.ModelSpec model = new BaseMod.ModelSpec("dhd.smeg", new Vector3(0.0, -0.5, 0.0), textures);

    public DHDBlock() {
        super(Material.field_151576_e, DHDTE.class);
        this.func_149711_c(1.5f);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    @Override
    public String[] getTextureNames() {
        return textures;
    }

    @Override
    public BaseMod.ModelSpec getModelSpec(IBlockState iBlockState) {
        return model;
    }

    @Override
    public BaseBlock.IOrientationHandler getOrientationHandler() {
        return BaseOrientation.orient4WaysByState;
    }

    @Override
    public int func_149645_b() {
        return -1;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public void onBlockAdded(World world, BlockPos blockPos, IBlockState iBlockState) {
        if (SGBaseBlock.debugMerge) {
            System.out.printf("DHDBlock.onBlockAdded: at %s\n", blockPos);
        }
        this.checkForLink(world, blockPos);
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos blockPos, IBlockState iBlockState, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.onBlockPlacedBy(world, blockPos, iBlockState, entityLivingBase, itemStack);
        this.checkForLink(world, blockPos);
    }

    @Override
    public boolean canHarvestBlock(IBlockState iBlockState, EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public void breakBlock(World world, BlockPos blockPos, IBlockState iBlockState) {
        SGBaseTE sGBaseTE;
        DHDTE dHDTE = (DHDTE)this.getTileEntity((IBlockAccess)world, blockPos);
        super.breakBlock(world, blockPos, iBlockState);
        if (dHDTE == null) {
            System.out.printf("DHDBlock.breakBlock: No tile entity at %s\n", blockPos);
        } else if (dHDTE.isLinkedToStargate && (sGBaseTE = dHDTE.getLinkedStargateTE()) != null) {
            sGBaseTE.clearLinkToController();
        }
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos blockPos, IBlockState iBlockState, EntityPlayer entityPlayer, EnumFacing enumFacing, float f, float f2, float f3) {
        SGGui sGGui = (double)f2 > 0.5 ? SGGui.SGController : SGGui.DHDFuel;
        SGCraft.mod.openGui(entityPlayer, (Enum)sGGui, world, blockPos);
        return true;
    }

    public void checkForLink(World world, BlockPos blockPos) {
        DHDTE dHDTE = (DHDTE)this.getTileEntity((IBlockAccess)world, blockPos);
        if (dHDTE != null) {
            dHDTE.checkForLink();
        } else {
            System.out.printf("DHDBlock.breakBlock: No tile entity at %d\n", blockPos);
        }
    }
}

